/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.components.customvisualization.ui.preferences;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.components.customvisualization.ui.ComponentDescriptor;
import com.jaspersoft.studio.editor.action.exporter.BaseResource;
import com.jaspersoft.studio.editor.action.exporter.IExportedResourceHandler;
import com.jaspersoft.studio.editor.action.exporter.IPropertyCustomExporter;
import com.jaspersoft.studio.editor.action.exporter.IResourceDefinition;
import com.jaspersoft.studio.messages.Messages;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import net.sf.jasperreports.eclipse.MScopedPreferenceStore;
import net.sf.jasperreports.eclipse.ui.FolderDestinationDialog;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Pair;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;

public class ExportedCVCHandler
implements IExportedResourceHandler,
IPropertyCustomExporter {
    private static final String CONTAINER_NAME = "cvComponents";
    private List<IResourceDefinition> cachedExportableResources = null;
    private Pair<String, List<IResourceDefinition>> cachedImportableResources = null;

    public String getResourceNameExport() {
        return "Custom Vistualization Components (" + this.getExportableResources().size() + ")";
    }

    public String getResourceNameImport(File exportedContainer) {
        return "Custom Vistualization Components (" + this.getRestorableResources(exportedContainer).size() + ")";
    }

    public List<IResourceDefinition> getRestorableResources(File exportedContainer) {
        String containerPath = exportedContainer.getAbsolutePath();
        if (this.cachedImportableResources == null || !((String)this.cachedImportableResources.getKey()).equals(containerPath)) {
            ArrayList<BaseResource> result = new ArrayList<BaseResource>();
            File importedDir = new File(exportedContainer, CONTAINER_NAME);
            if (importedDir.exists()) {
                File[] fileArray = importedDir.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File[] propertiesFiles;
                    File templateFolder = fileArray[n2];
                    File[] fileArray2 = propertiesFiles = templateFolder.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".json");
                        }
                    });
                    int n3 = propertiesFiles.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        File properitesFile = fileArray2[n4];
                        ComponentDescriptor cd = this.readComponentDescriptor(properitesFile);
                        if (cd != null) {
                            String componentName = cd.getLabel();
                            BaseResource templateResource = new BaseResource(componentName);
                            templateResource.setData((Object)properitesFile.getAbsolutePath());
                            result.add(templateResource);
                        }
                        ++n4;
                    }
                    ++n2;
                }
            }
            this.cachedImportableResources = new Pair((Object)containerPath, result);
        }
        return (List)this.cachedImportableResources.getValue();
    }

    public List<IResourceDefinition> getExportableResources() {
        if (this.cachedExportableResources == null) {
            this.cachedExportableResources = new ArrayList<IResourceDefinition>();
            IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            String paths = store.getString("com.jaspersoft.studio.cvc.resource.paths");
            List<String> pathsList = this.parseString(paths);
            for (String dir : pathsList) {
                File[] definitionFiles;
                File componentsLocation = new File(dir);
                File[] fileArray = definitionFiles = componentsLocation.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.endsWith(".json");
                    }
                });
                int n = definitionFiles.length;
                int n2 = 0;
                while (n2 < n) {
                    File f = fileArray[n2];
                    ComponentDescriptor cd = this.readComponentDescriptor(f);
                    if (cd != null) {
                        BaseResource templateResource = new BaseResource(cd.getLabel());
                        templateResource.setData((Object)f.getAbsolutePath());
                        this.cachedExportableResources.add((IResourceDefinition)templateResource);
                    }
                    ++n2;
                }
            }
        }
        return this.cachedExportableResources;
    }

    private ComponentDescriptor readComponentDescriptor(File resource) {
        ComponentDescriptor result;
        block5: {
            ObjectMapper mapper = new ObjectMapper();
            FileInputStream is = null;
            result = null;
            try {
                try {
                    is = new FileInputStream(resource);
                    BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    mapper.configure(JsonGenerator.Feature.ESCAPE_NON_ASCII, true);
                    result = (ComponentDescriptor)mapper.readValue((Reader)in, ComponentDescriptor.class);
                }
                catch (Exception ex) {
                    JaspersoftStudioPlugin.getInstance().logError((Throwable)ex);
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(is);
                throw throwable;
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)is);
        }
        return result;
    }

    protected List<String> parseString(String stringList) {
        StringTokenizer st = new StringTokenizer(stringList, String.valueOf(File.pathSeparator) + "\n\r");
        ArrayList<String> v = new ArrayList<String>();
        while (st.hasMoreElements()) {
            v.add(st.nextElement().toString());
        }
        return v;
    }

    protected String createList(List<String> items) {
        StringBuffer path = new StringBuffer("");
        for (String item : items) {
            path.append(item);
            path.append(File.pathSeparator);
        }
        return path.toString();
    }

    protected String getFolderName(HashSet<String> usedNames, String baseName) {
        if (!usedNames.contains(baseName)) {
            return baseName;
        }
        int index = 1;
        String newName = String.valueOf(baseName) + "_" + index;
        while (usedNames.contains(newName)) {
            newName = String.valueOf(baseName) + "_" + ++index;
        }
        return newName;
    }

    protected void removeUnwantedComponents(File destinationFolder, HashSet<String> allowedTemplates) {
        File[] definitionFiles;
        File[] fileArray = definitionFiles = destinationFolder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".json");
            }
        });
        int n = definitionFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File definitionFile = fileArray[n2];
            if (!allowedTemplates.contains(definitionFile.getName())) {
                File[] filesToDelete;
                ComponentDescriptor componentToRemove = this.readComponentDescriptor(definitionFile);
                File thumbnail = new File(definitionFile.getParent(), componentToRemove.getThumbnail());
                thumbnail.delete();
                final String definitionFileName = FilenameUtils.removeExtension((String)definitionFile.getName());
                File[] fileArray2 = filesToDelete = destinationFolder.listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String fileNameWithOutExt = FilenameUtils.removeExtension((String)name);
                        return fileNameWithOutExt.equals(definitionFileName) || fileNameWithOutExt.equals(String.valueOf(definitionFileName) + ".min");
                    }
                });
                int n3 = filesToDelete.length;
                int n4 = 0;
                while (n4 < n3) {
                    File fileToDelete = fileArray2[n4];
                    fileToDelete.delete();
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public File exportContentFolder(List<IResourceDefinition> resourcesToExport) {
        IPreferenceStore store = JaspersoftStudioPlugin.getInstance().getPreferenceStore();
        String paths = store.getString("com.jaspersoft.studio.cvc.resource.paths");
        List<String> pathsList = this.parseString(paths);
        if (pathsList.isEmpty()) {
            return null;
        }
        File tempDir = new File(System.getProperty("java.io.tmpdir"));
        tempDir.deleteOnExit();
        File destDir = new File(tempDir, CONTAINER_NAME);
        if (destDir.exists()) {
            net.sf.jasperreports.eclipse.util.FileUtils.recursiveDelete((File)destDir);
        }
        destDir.mkdirs();
        HashMap<String, HashSet<String>> componentsToExportMap = new HashMap<String, HashSet<String>>();
        for (IResourceDefinition definition : resourcesToExport) {
            File templateDefinition = new File(definition.getData().toString());
            File contentFolder = templateDefinition.getParentFile();
            String templateDefinitionName = templateDefinition.getName();
            HashSet<String> templateNames = (HashSet<String>)componentsToExportMap.get(contentFolder.getAbsolutePath());
            if (templateNames == null) {
                templateNames = new HashSet<String>();
                componentsToExportMap.put(contentFolder.getAbsolutePath(), templateNames);
            }
            templateNames.add(templateDefinitionName);
        }
        HashSet<String> usedNames = new HashSet<String>();
        for (String path : pathsList) {
            File filePath = new File(path);
            HashSet componentsToExportSet = (HashSet)componentsToExportMap.get(path);
            if (!filePath.exists() || !filePath.isDirectory() || filePath.list().length <= 0 || componentsToExportSet == null || componentsToExportSet.size() <= 0) continue;
            String folderName = this.getFolderName(usedNames, filePath.getName());
            usedNames.add(folderName);
            File containerfolder = new File(destDir, folderName);
            try {
                FileUtils.copyDirectory((File)filePath, (File)containerfolder);
                this.removeUnwantedComponents(containerfolder, componentsToExportSet);
            }
            catch (IOException e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError((Throwable)e);
            }
        }
        return destDir;
    }

    public void restoreContentFolder(File exportedContainer, List<IResourceDefinition> resourcesToImport) {
        FolderDestinationDialog destDialog = new FolderDestinationDialog(UIUtils.getShell(), Messages.ExportedStudioTemplatesHandler_dialogTitle, Messages.ExportedStudioTemplatesHandler_dialogDescription);
        destDialog.open();
        if (destDialog.getDirectory() != null) {
            MScopedPreferenceStore store = (MScopedPreferenceStore)JaspersoftStudioPlugin.getInstance().getPreferenceStore();
            IEclipsePreferences pref = store.getQualifierStore();
            String s = store.getString("com.jaspersoft.studio.cvc.resource.paths");
            List<String> paths = this.parseString(s);
            File importedDir = new File(exportedContainer, CONTAINER_NAME);
            File targetDir = new File(destDialog.getDirectory());
            HashMap<String, HashSet<String>> componentsToImportMap = new HashMap<String, HashSet<String>>();
            for (IResourceDefinition definition : resourcesToImport) {
                File componentDefinition = new File(definition.getData().toString());
                File contentFolder = componentDefinition.getParentFile();
                String templateDefinitionName = componentDefinition.getName();
                HashSet<String> templateNames = (HashSet<String>)componentsToImportMap.get(contentFolder.getAbsolutePath());
                if (templateNames == null) {
                    templateNames = new HashSet<String>();
                    componentsToImportMap.put(contentFolder.getAbsolutePath(), templateNames);
                }
                templateNames.add(templateDefinitionName);
            }
            File[] fileArray = importedDir.listFiles();
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File templateFolder = fileArray[n2];
                HashSet componentsToImportSet = (HashSet)componentsToImportMap.get(templateFolder.getAbsolutePath());
                if (componentsToImportSet != null && !componentsToImportSet.isEmpty()) {
                    try {
                        File targetFile = new File(targetDir, templateFolder.getName());
                        FileUtils.copyDirectory((File)templateFolder, (File)targetFile);
                        paths.add(targetFile.getAbsolutePath());
                        this.removeUnwantedComponents(templateFolder, componentsToImportSet);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError((Throwable)e);
                    }
                }
                ++n2;
            }
            String newPaths = this.createList(paths);
            pref.put("com.jaspersoft.studio.cvc.resource.paths", newPaths);
            try {
                store.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public List<String> getHandledProperties() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("com.jaspersoft.studio.cvc.resource.paths");
        return result;
    }
}

