/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.translation.resources;

import com.jaspersoft.translation.resources.AbstractResourceDefinition;
import com.jaspersoft.translation.resources.IResourcesInput;
import java.io.InputStream;
import java.util.Locale;

public class PackageResourceDefinition
extends AbstractResourceDefinition {
    private String locale;
    private String packageName;
    private String fileName;
    private String description;
    private ClassLoader propertiesLoader;
    private String filePath;
    private IResourcesInput parent;

    public PackageResourceDefinition(String locale, String packageName, String fileName, String description, String filePath, IResourcesInput parent) {
        this.locale = locale;
        this.packageName = packageName;
        this.fileName = fileName;
        this.description = description;
        this.propertiesLoader = this.getClass().getClassLoader();
        this.parent = parent;
        this.filePath = filePath;
    }

    public PackageResourceDefinition(String locale, String packageName, String fileName, String description, ClassLoader loader, String filePath, IResourcesInput parent) {
        this.locale = locale;
        this.packageName = packageName;
        this.fileName = fileName;
        this.description = description;
        this.propertiesLoader = loader;
        this.parent = parent;
        this.filePath = filePath;
    }

    @Override
    public String getLocale() {
        return this.locale;
    }

    public String getPath() {
        return this.filePath;
    }

    @Override
    public String getPackageName() {
        return this.packageName;
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    protected InputStream getFileInput() {
        return this.propertiesLoader.getResourceAsStream(this.filePath);
    }

    @Override
    protected InputStream getLocalizedInput(Locale loc) {
        String locName = new String(this.fileName);
        if (locName.endsWith(".properties")) {
            locName = locName.substring(0, locName.length() - 11);
            Locale[] localeArray = Locale.getAvailableLocales();
            int n = localeArray.length;
            int n2 = 0;
            while (n2 < n) {
                String newPath;
                InputStream stream;
                Locale searchedLoc = localeArray[n2];
                if (searchedLoc.getLanguage().equals(loc.getLanguage()) && (stream = this.propertiesLoader.getResourceAsStream(String.valueOf(newPath = this.filePath.substring(0, this.filePath.length() - this.fileName.length())) + locName + "_" + searchedLoc.toString() + ".properties")) != null) {
                    return stream;
                }
                ++n2;
            }
        }
        return null;
    }

    @Override
    public String getPluginName() {
        return this.parent.getPluginName();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof PackageResourceDefinition) {
            PackageResourceDefinition resource = (PackageResourceDefinition)obj;
            return PackageResourceDefinition.safeEquals(this.getPath(), resource.getPath()) && super.equals(obj);
        }
        return false;
    }
}

