/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.checks.internal;

import java.util.ArrayList;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.checks.IMessageCheck;
import org.eclipse.babel.core.message.checks.proximity.IProximityAnalyzer;
import org.eclipse.babel.core.util.BabelUtils;

public class SimilarValueCheck
implements IMessageCheck {
    private String[] similarKeys;
    private IProximityAnalyzer analyzer;

    public SimilarValueCheck(IProximityAnalyzer analyzer) {
        this.analyzer = analyzer;
    }

    @Override
    public boolean checkKey(IMessagesBundleGroup messagesBundleGroup, IMessage message) {
        ArrayList<String> keys = new ArrayList<String>();
        if (message != null) {
            String value1 = message.getValue().toLowerCase();
            IMessagesBundle messagesBundle = messagesBundleGroup.getMessagesBundle(message.getLocale());
            for (IMessage similarEntry : messagesBundle.getMessages()) {
                String value2;
                if (message.getKey().equals(similarEntry.getKey()) || BabelUtils.equals(value1, value2 = similarEntry.getValue().toLowerCase()) || !(this.analyzer.analyse(value1, value2) >= 0.75)) continue;
                keys.add(similarEntry.getKey());
            }
            if (!keys.isEmpty()) {
                keys.add(message.getKey());
            }
        }
        this.similarKeys = keys.toArray(new String[0]);
        return !keys.isEmpty();
    }

    public String[] getSimilarMessageKeys() {
        return this.similarKeys;
    }
}

