/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.internal;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import org.eclipse.babel.core.configuration.DirtyHack;
import org.eclipse.babel.core.util.BabelUtils;

public abstract class AbstractMessageModel
implements Serializable {
    private static final long serialVersionUID = -5829777506986851278L;
    private transient PropertyChangeSupport changeSupport;

    final synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null) {
            return;
        }
        if (this.changeSupport == null) {
            this.changeSupport = new PropertyChangeSupport(this);
        }
        this.changeSupport.addPropertyChangeListener(listener);
    }

    final synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        if (listener == null || this.changeSupport == null) {
            return;
        }
        this.changeSupport.removePropertyChangeListener(listener);
    }

    final synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        if (this.changeSupport == null) {
            return new PropertyChangeListener[0];
        }
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected final void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        if (this.changeSupport == null || !DirtyHack.isFireEnabled()) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        if (this.changeSupport == null || !DirtyHack.isFireEnabled()) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(PropertyChangeEvent event) {
        if (this.changeSupport == null || !DirtyHack.isFireEnabled()) {
            return;
        }
        this.changeSupport.firePropertyChange(event);
    }

    protected final void firePropertyChange(String propertyName, double oldValue, double newValue) {
        this.firePropertyChange(propertyName, new Double(oldValue), new Double(newValue));
    }

    protected final void firePropertyChange(String propertyName, float oldValue, float newValue) {
        this.firePropertyChange(propertyName, new Float(oldValue), new Float(newValue));
    }

    protected final void firePropertyChange(String propertyName, int oldValue, int newValue) {
        if (this.changeSupport == null || !DirtyHack.isFireEnabled()) {
            return;
        }
        this.changeSupport.firePropertyChange(propertyName, oldValue, newValue);
    }

    protected final void firePropertyChange(String propertyName, long oldValue, long newValue) {
        this.firePropertyChange(propertyName, new Long(oldValue), new Long(newValue));
    }

    protected final boolean equals(Object o1, Object o2) {
        return BabelUtils.equals(o1, o2);
    }
}

