/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.resource.ser;

import java.util.Arrays;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.resource.ser.DefaultPropertiesSerializerConfig;
import org.eclipse.babel.core.message.resource.ser.IPropertiesSerializerConfig;

public class PropertiesSerializer {
    public static final String GENERATED_BY = "#Generated by Eclipse Messages Editor (Eclipse Babel)";
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private static final String SPECIAL_VALUE_SAVE_CHARS = "\t\f";
    private static final String SPECIAL_KEY_SAVE_CHARS = "=\t\f#!: ";
    private static final String SYSTEM_LINE_SEP = System.getProperty("line.separator");
    private static final String[] FORCED_LINE_SEP = new String[4];
    private IPropertiesSerializerConfig config;

    static {
        PropertiesSerializer.FORCED_LINE_SEP[0] = null;
        PropertiesSerializer.FORCED_LINE_SEP[1] = "\\\\n";
        PropertiesSerializer.FORCED_LINE_SEP[2] = "\\\\r\\\\n";
        PropertiesSerializer.FORCED_LINE_SEP[3] = "\\\\r";
    }

    public PropertiesSerializer(IPropertiesSerializerConfig config) {
        this.config = config == null ? new DefaultPropertiesSerializerConfig() : config;
    }

    public String serialize(IMessagesBundle messagesBundle) {
        String lineBreak = SYSTEM_LINE_SEP;
        int numOfLineBreaks = this.config.getGroupSepBlankLineCount();
        StringBuffer text = new StringBuffer();
        String headComment = messagesBundle.getComment();
        if (this.config.isShowSupportEnabled() && !headComment.startsWith(GENERATED_BY)) {
            text.append(GENERATED_BY);
            text.append(SYSTEM_LINE_SEP);
        }
        if (headComment != null && headComment.length() > 0) {
            text.append(headComment);
        }
        String group = null;
        int equalIndex = -1;
        Object[] keys = messagesBundle.getKeys();
        if (this.config.isKeySortingEnabled()) {
            Arrays.sort(keys);
        }
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            IMessage message = messagesBundle.getMessage((String)key);
            String value = message.getValue();
            String comment = message.getComment();
            if (value != null) {
                String lineStyleCh;
                if (this.config.isUnicodeEscapeEnabled()) {
                    value = value.replaceAll("\\\\", "\\\\\\\\");
                }
                if ((lineStyleCh = FORCED_LINE_SEP[this.config.getNewLineStyle()]) != null) {
                    value = value.replaceAll("\r\n|\r|\n", lineStyleCh);
                } else {
                    value = value.replaceAll("\r", "\\\\r");
                    value = value.replaceAll("\n", "\\\\n");
                }
            } else {
                value = "";
            }
            if (this.config.isGroupKeysEnabled()) {
                String newGroup = this.getKeyGroup((String)key);
                if (newGroup == null || !newGroup.equals(group)) {
                    group = newGroup;
                    equalIndex = this.getEqualIndex((String)key, group, messagesBundle);
                    int j = 0;
                    while (j < numOfLineBreaks) {
                        text.append(lineBreak);
                        ++j;
                    }
                }
            } else {
                equalIndex = this.getEqualIndex((String)key, null, messagesBundle);
            }
            if (this.config.isUnicodeEscapeEnabled()) {
                key = this.convertUnicodeToEncoded((String)key);
                value = this.convertUnicodeToEncoded(value);
            }
            if (comment != null && comment.length() > 0) {
                text.append(comment);
            }
            this.appendKey(text, (String)key, equalIndex, message.isActive());
            this.appendValue(text, value, equalIndex, message.isActive());
            text.append(lineBreak);
            ++i;
        }
        return text.toString();
    }

    private String convertUnicodeToEncoded(String str) {
        int len = str.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        int x = 0;
        while (x < len) {
            char aChar = str.charAt(x);
            if (aChar < ' ' || aChar > '~') {
                outBuffer.append('\\');
                outBuffer.append('u');
                outBuffer.append(this.toHex(aChar >> 12 & 0xF));
                outBuffer.append(this.toHex(aChar >> 8 & 0xF));
                outBuffer.append(this.toHex(aChar >> 4 & 0xF));
                outBuffer.append(this.toHex(aChar & 0xF));
            } else {
                outBuffer.append(aChar);
            }
            ++x;
        }
        return outBuffer.toString();
    }

    private char toHex(int nibble) {
        char hexChar = HEX_DIGITS[nibble & 0xF];
        if (!this.config.isUnicodeEscapeUppercase()) {
            return Character.toLowerCase(hexChar);
        }
        return hexChar;
    }

    private void appendValue(StringBuffer text, String value, int equalIndex, boolean active) {
        if (value != null) {
            if (value.startsWith(" ")) {
                value = "\\" + value;
            }
            int lineLength = this.config.getWrapLineLength() - 1;
            int valueStartPos = equalIndex;
            valueStartPos = this.config.isSpacesAroundEqualsEnabled() ? (valueStartPos += 3) : ++valueStartPos;
            if (this.config.isNewLineNice()) {
                value = value.replaceAll("(\\\\r\\\\n|\\\\r|\\\\n)", "$1\\\\" + SYSTEM_LINE_SEP);
            }
            if (this.config.isWrapLinesEnabled() && valueStartPos < lineLength) {
                StringBuffer valueBuf = new StringBuffer(value);
                while (valueBuf.length() + valueStartPos > lineLength || valueBuf.indexOf("\n") != -1) {
                    int endPos = Math.min(valueBuf.length(), lineLength - valueStartPos);
                    String line = valueBuf.substring(0, endPos);
                    if (line.endsWith("\\") && valueBuf.length() > endPos + 1 && valueBuf.substring(endPos, endPos + 1).toLowerCase().equals("u")) {
                        this.saveValue(text, valueBuf.substring(0, --endPos));
                        text.append("\\");
                        text.append(SYSTEM_LINE_SEP);
                    } else {
                        int breakPos = line.indexOf(SYSTEM_LINE_SEP);
                        if (breakPos != -1) {
                            endPos = breakPos + SYSTEM_LINE_SEP.length();
                            this.saveValue(text, valueBuf.substring(0, endPos));
                        } else {
                            breakPos = line.lastIndexOf(32);
                            if (breakPos != -1) {
                                endPos = breakPos + 1;
                                this.saveValue(text, valueBuf.substring(0, endPos));
                                text.append("\\");
                                text.append(SYSTEM_LINE_SEP);
                            } else {
                                breakPos = line.lastIndexOf("\\u");
                                if (breakPos != -1) {
                                    if (breakPos > 0) {
                                        endPos = breakPos;
                                        this.saveValue(text, valueBuf.substring(0, endPos));
                                        text.append("\\");
                                        text.append(SYSTEM_LINE_SEP);
                                    } else {
                                        endPos = breakPos + 6;
                                        this.saveValue(text, valueBuf.substring(0, endPos));
                                        text.append("\\");
                                        text.append(SYSTEM_LINE_SEP);
                                    }
                                } else {
                                    this.saveValue(text, valueBuf.substring(0, endPos));
                                    text.append("\\");
                                    text.append(SYSTEM_LINE_SEP);
                                }
                            }
                        }
                    }
                    valueBuf.delete(0, endPos);
                    if (!this.config.isWrapAlignEqualsEnabled()) {
                        valueStartPos = this.config.getWrapIndentLength();
                    }
                    if (!active && valueStartPos > 0) {
                        text.append("##");
                    }
                    int i = 0;
                    while (i < valueStartPos) {
                        text.append(' ');
                        ++i;
                    }
                }
                text.append(valueBuf);
            } else {
                this.saveValue(text, value);
            }
        }
    }

    private void appendKey(StringBuffer text, String key, int equalIndex, boolean active) {
        if (!active) {
            text.append("##");
        }
        this.saveKey(text, key);
        int i = 0;
        while (i < equalIndex - key.length()) {
            text.append(' ');
            ++i;
        }
        if (this.config.isSpacesAroundEqualsEnabled()) {
            text.append(" = ");
        } else {
            text.append("=");
        }
    }

    private void saveKey(StringBuffer buf, String str) {
        this.saveText(buf, str, SPECIAL_KEY_SAVE_CHARS);
    }

    private void saveValue(StringBuffer buf, String str) {
        this.saveText(buf, str, SPECIAL_VALUE_SAVE_CHARS);
    }

    private void saveText(StringBuffer buf, String str, String escapeChars) {
        int len = str.length();
        int x = 0;
        while (x < len) {
            char aChar = str.charAt(x);
            if (escapeChars.indexOf(aChar) != -1) {
                buf.append('\\');
            }
            buf.append(aChar);
            ++x;
        }
    }

    private String getKeyGroup(String key) {
        String sep = this.config.getGroupLevelSeparator();
        int depth = this.config.getGroupLevelDepth();
        int endIndex = 0;
        int levelFound = 0;
        int i = 0;
        while (i < depth) {
            int sepIndex = key.indexOf(sep, endIndex);
            if (sepIndex != -1) {
                endIndex = sepIndex + 1;
                ++levelFound;
            }
            ++i;
        }
        if (levelFound != 0) {
            if (levelFound < depth) {
                return key;
            }
            return key.substring(0, endIndex - 1);
        }
        return null;
    }

    private int getEqualIndex(String key, String group, IMessagesBundle messagesBundle) {
        int equalIndex = -1;
        boolean alignEquals = this.config.isAlignEqualsEnabled();
        boolean groupKeys = this.config.isGroupKeysEnabled();
        boolean groupAlignEquals = this.config.isGroupAlignEqualsEnabled();
        if (!alignEquals || groupKeys && !groupAlignEquals || groupKeys && group == null) {
            return key.length();
        }
        String[] keys = messagesBundle.getKeys();
        int i = 0;
        while (i < keys.length) {
            int index;
            String iterKey = keys[i];
            if ((!groupKeys || groupAlignEquals && iterKey.startsWith(group)) && (index = iterKey.length()) > equalIndex) {
                equalIndex = index;
            }
            ++i;
        }
        return equalIndex;
    }
}

