/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.strategy;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Locale;
import org.eclipse.babel.core.message.internal.MessageException;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.resource.internal.PropertiesFileResource;
import org.eclipse.babel.core.message.resource.ser.IPropertiesDeserializerConfig;
import org.eclipse.babel.core.message.resource.ser.IPropertiesSerializerConfig;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.babel.core.message.strategy.IMessagesBundleGroupStrategy;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.core.util.NameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class PropertiesFileGroupStrategy
implements IMessagesBundleGroupStrategy {
    private static final MessagesBundle[] EMPTY_MESSAGES = new MessagesBundle[0];
    private File file;
    private final String baseName;
    private final String fileExtension;
    private final String fileMatchPattern;
    private final IPropertiesSerializerConfig serializerConfig;
    private final IPropertiesDeserializerConfig deserializerConfig;

    public PropertiesFileGroupStrategy(File file, IPropertiesSerializerConfig serializerConfig, IPropertiesDeserializerConfig deserializerConfig) {
        this.serializerConfig = serializerConfig;
        this.deserializerConfig = deserializerConfig;
        this.file = file;
        this.fileExtension = file.getName().replaceFirst("(.*\\.)(.*)", "$2");
        String patternCore = "((_[a-z]{2,3})|(_[a-z]{2,3}_[A-Z]{2})|(_[a-z]{2,3}_[A-Z]{2}_\\w*))?(\\." + this.fileExtension + ")$";
        String namePattern = "^(.*?)" + patternCore;
        this.baseName = file.getName().replaceFirst(namePattern, "$1");
        this.fileMatchPattern = "^(" + this.baseName + ")" + patternCore;
    }

    @Override
    public String createMessagesBundleGroupName() {
        return String.valueOf(this.baseName) + "[...]." + this.fileExtension;
    }

    @Override
    public MessagesBundle[] loadMessagesBundles() throws MessageException {
        File[] resources = null;
        File parentDir = this.file.getParentFile();
        if (parentDir != null) {
            resources = parentDir.listFiles();
        }
        ArrayList<MessagesBundle> bundles = new ArrayList<MessagesBundle>();
        if (resources != null) {
            int i = 0;
            while (i < resources.length) {
                File resource = resources[i];
                String resourceName = resource.getName();
                if (resource.isFile() && resourceName.matches(this.fileMatchPattern)) {
                    String localeText = resourceName.replaceFirst(this.fileMatchPattern, "$2");
                    Locale locale = BabelUtils.parseLocale(localeText);
                    bundles.add(this.createBundle(locale, resource));
                }
                ++i;
            }
        }
        return bundles.toArray(EMPTY_MESSAGES);
    }

    @Override
    public MessagesBundle createMessagesBundle(Locale locale) {
        return null;
    }

    protected MessagesBundle createBundle(Locale locale, File resource) throws MessageException {
        try {
            return new MessagesBundle(new PropertiesFileResource(locale, new PropertiesSerializer(this.serializerConfig), new PropertiesDeserializer(this.deserializerConfig), resource));
        }
        catch (FileNotFoundException e) {
            throw new MessageException("Cannot create bundle for locale " + locale + " and resource " + resource, e);
        }
    }

    @Override
    public String createMessagesBundleId() {
        String path = this.file.getAbsolutePath();
        int index = path.indexOf("src");
        String pathBeforeSrc = path.substring(0, Math.max(index - 1, 0));
        int lastIndexOf = pathBeforeSrc.lastIndexOf(File.separatorChar);
        String relativeFilePath = path.substring(Math.max(index, 0), Math.max(path.length(), 0));
        String projectName = path.substring(Math.max(lastIndexOf + 1, 0), Math.max(index - 1, 0));
        if (projectName.equals("")) {
            projectName = "no_project";
        }
        IFile f = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName).getFile(relativeFilePath);
        return NameUtils.getResourceBundleId((IResource)f);
    }

    @Override
    public String getProjectName() {
        IPath path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        Path fullPath = null;
        fullPath = this.file.getAbsolutePath().contains(path.toOSString()) ? new Path(this.file.getAbsolutePath()) : new Path(this.file.getAbsolutePath());
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFileForLocation((IPath)fullPath);
        if (file != null) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(file.getFullPath().segments()[0]).getName();
        }
        return null;
    }
}

