/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.tree.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.util.BabelUtils;

public class KeyTreeNode
implements Comparable<KeyTreeNode>,
IKeyTreeNode {
    public static final KeyTreeNode[] EMPTY_KEY_TREE_NODES = new KeyTreeNode[0];
    private IKeyTreeNode parent;
    private final String name;
    private String messageKey;
    private final Map<String, IKeyTreeNode> children = new TreeMap<String, IKeyTreeNode>();
    private boolean usedAsKey = false;
    private IMessagesBundleGroup messagesBundleGroup;

    public KeyTreeNode(IKeyTreeNode parent, String name, String messageKey, IMessagesBundleGroup messagesBundleGroup) {
        this.parent = parent;
        this.name = name;
        this.messageKey = messageKey;
        if (parent != null) {
            parent.addChild(this);
        }
        this.messagesBundleGroup = messagesBundleGroup;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public IKeyTreeNode getParent() {
        return this.parent;
    }

    @Override
    public String getMessageKey() {
        return this.messageKey;
    }

    IKeyTreeNode[] getPath() {
        ArrayList<KeyTreeNode> nodes = new ArrayList<KeyTreeNode>();
        IKeyTreeNode node = this;
        while (node != null && node.getName() != null) {
            nodes.add(0, (KeyTreeNode)node);
            node = node.getParent();
        }
        return nodes.toArray(EMPTY_KEY_TREE_NODES);
    }

    @Override
    public IKeyTreeNode[] getChildren() {
        return this.children.values().toArray(EMPTY_KEY_TREE_NODES);
    }

    boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public IKeyTreeNode getChild(String childName) {
        return this.children.get(childName);
    }

    Collection<IKeyTreeNode> getChildrenInternal() {
        return this.children.values();
    }

    @Override
    public int compareTo(KeyTreeNode node) {
        if (this.parent == null && node.parent != null) {
            return -1;
        }
        if (this.parent != null && node.parent == null) {
            return 1;
        }
        return this.name.compareTo(node.name);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof KeyTreeNode)) {
            return false;
        }
        KeyTreeNode node = (KeyTreeNode)obj;
        return BabelUtils.equals(this.name, node.name) && BabelUtils.equals(this.parent, node.parent);
    }

    public String toString() {
        return this.messageKey;
    }

    @Override
    public void addChild(IKeyTreeNode childNode) {
        this.children.put(childNode.getName(), childNode);
    }

    public void removeChild(KeyTreeNode childNode) {
        this.children.remove(childNode.getName());
    }

    public Collection<KeyTreeNode> getBranch() {
        ArrayList<KeyTreeNode> childNodes = new ArrayList<KeyTreeNode>();
        childNodes.add(this);
        IKeyTreeNode[] iKeyTreeNodeArray = this.getChildren();
        int n = iKeyTreeNodeArray.length;
        int n2 = 0;
        while (n2 < n) {
            IKeyTreeNode childNode = iKeyTreeNodeArray[n2];
            childNodes.addAll(((KeyTreeNode)childNode).getBranch());
            ++n2;
        }
        return childNodes;
    }

    public Collection<IKeyTreeNode> getDescendants() {
        ArrayList<IKeyTreeNode> descendants = new ArrayList<IKeyTreeNode>();
        for (IKeyTreeNode child : this.children.values()) {
            descendants.add(child);
            descendants.addAll(((KeyTreeNode)child).getDescendants());
        }
        return descendants;
    }

    public void setUsedAsKey() {
        this.usedAsKey = true;
    }

    @Override
    public boolean isUsedAsKey() {
        return this.usedAsKey;
    }

    @Override
    public IMessagesBundleGroup getMessagesBundleGroup() {
        return this.messagesBundleGroup;
    }

    @Override
    public void setParent(IKeyTreeNode parentNode) {
        this.parent = parentNode;
    }
}

