/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.tree.visitor;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.IKeyTreeVisitor;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.core.message.tree.visitor.IKeyCheck;

public class KeyCheckVisitor
implements IKeyTreeVisitor {
    private static final KeyTreeNode[] EMPTY_NODES = new KeyTreeNode[0];
    private IKeyCheck keyCheck;
    private final MessagesBundleGroup messagesBundleGroup;
    private final Collection<IKeyTreeNode> passedNodes = new ArrayList<IKeyTreeNode>();
    private final Collection<IKeyTreeNode> failedNodes = new ArrayList<IKeyTreeNode>();

    public KeyCheckVisitor(MessagesBundleGroup messagesBundleGroup, IKeyCheck keyCheck) {
        this.keyCheck = keyCheck;
        this.messagesBundleGroup = messagesBundleGroup;
    }

    public KeyCheckVisitor(MessagesBundleGroup messagesBundleGroup) {
        this.messagesBundleGroup = messagesBundleGroup;
    }

    @Override
    public void visitKeyTreeNode(IKeyTreeNode node) {
        if (this.keyCheck == null) {
            return;
        }
        if (this.keyCheck.checkKey(this.messagesBundleGroup, node.getMessageKey())) {
            this.passedNodes.add(node);
        } else {
            this.failedNodes.add(node);
        }
    }

    public KeyTreeNode[] getPassedNodes() {
        return this.passedNodes.toArray(EMPTY_NODES);
    }

    public KeyTreeNode[] getFailedNodes() {
        return this.failedNodes.toArray(EMPTY_NODES);
    }

    public void reset() {
        this.passedNodes.clear();
        this.failedNodes.clear();
    }

    public void setKeyCheck(IKeyCheck newKeyCheck, boolean reset) {
        if (reset) {
            this.reset();
        }
        this.keyCheck = newKeyCheck;
    }
}

