/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.message.tree.visitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.IKeyTreeVisitor;

public class NodePathRegexVisitor
implements IKeyTreeVisitor {
    private List<IKeyTreeNode> nodes = new ArrayList<IKeyTreeNode>();
    private final String regex;

    public NodePathRegexVisitor(String regex) {
        this.regex = regex;
    }

    @Override
    public void visitKeyTreeNode(IKeyTreeNode node) {
        if (node.getMessageKey().matches(this.regex)) {
            this.nodes.add(node);
        }
    }

    public List<IKeyTreeNode> getKeyTreeNodes() {
        return this.nodes;
    }

    public List<String> getKeyTreeNodePaths() {
        ArrayList<String> paths = new ArrayList<String>(this.nodes.size());
        for (IKeyTreeNode node : this.nodes) {
            paths.add(node.getMessageKey());
        }
        return paths;
    }

    public IKeyTreeNode getKeyTreeNode() {
        if (this.nodes.size() > 0) {
            return this.nodes.get(0);
        }
        return null;
    }
}

