/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.refactoring;

import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.eclipse.babel.core.configuration.DirtyHack;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.IMessagesBundleGroup;
import org.eclipse.babel.core.message.manager.RBManager;
import org.eclipse.babel.core.refactoring.IRefactoringService;
import org.eclipse.babel.core.refactoring.KeyRefactoringDialog;
import org.eclipse.babel.core.util.PDEUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;

public class StandardRefactoring
implements IRefactoringService {
    public static String defaultLocaleTag = "[default]";

    public static IProject getProject(String projectName) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject p = iProjectArray[n2];
            if (p.getName().equalsIgnoreCase(projectName)) {
                if (PDEUtils.isFragment(p)) {
                    return PDEUtils.getFragmentHost(p);
                }
                return p;
            }
            ++n2;
        }
        return null;
    }

    public Set<Locale> getProvidedLocales(String bundleName, IProject project) {
        RBManager instance = RBManager.getInstance(project);
        HashSet<Locale> locales = new HashSet<Locale>();
        IMessagesBundleGroup group = instance.getMessagesBundleGroup(bundleName);
        if (group == null) {
            return locales;
        }
        for (IMessagesBundle bundle : group.getMessagesBundles()) {
            locales.add(bundle.getLocale());
        }
        return locales;
    }

    public static Locale getLocaleByDisplayName(Set<Locale> locales, String displayName) {
        for (Locale l : locales) {
            String name;
            String string = name = l == null ? defaultLocaleTag : l.getDisplayName();
            if (!name.equals(displayName) && (name.trim().length() != 0 || !displayName.equals(defaultLocaleTag))) continue;
            return l;
        }
        return null;
    }

    @Override
    public void refactorKey(String projectName, String resourceBundleId, String selectedLocale, String oldKey, String newKey, String enumName) {
        IProject project = StandardRefactoring.getProject(projectName);
        RBManager rbManager = RBManager.getInstance(projectName);
        IMessagesBundleGroup messagesBundleGroup = rbManager.getMessagesBundleGroup(resourceBundleId);
        DirtyHack.setFireEnabled(false);
        if ("All available".equals(selectedLocale)) {
            messagesBundleGroup.renameMessageKeys(oldKey, newKey);
        } else {
            IMessagesBundle messagesBundle = messagesBundleGroup.getMessagesBundle(StandardRefactoring.getLocaleByDisplayName(this.getProvidedLocales(resourceBundleId, project), selectedLocale));
            messagesBundle.renameMessageKey(oldKey, newKey);
        }
        DirtyHack.setFireEnabled(true);
        rbManager.writeToFile(rbManager.getMessagesBundleGroup(resourceBundleId));
    }

    @Override
    public void openRefactorDialog(String projectName, String resourceBundleId, String oldKey, String enumName) {
        KeyRefactoringDialog dialog = new KeyRefactoringDialog(Display.getDefault().getActiveShell());
        KeyRefactoringDialog.DialogConfiguration config = dialog.new KeyRefactoringDialog.DialogConfiguration();
        config.setPreselectedKey(oldKey);
        config.setPreselectedBundle(resourceBundleId);
        config.setProjectName(projectName);
        dialog.setDialogConfiguration(config);
        if (dialog.open() != 0) {
            return;
        }
        this.refactorKey(projectName, resourceBundleId, config.getSelectedLocale(), oldKey, config.getNewKey(), enumName);
    }

    @Override
    public void openRefactorDialog(IFile file, int selectionOffset) {
    }
}

