/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.core.util;

import java.util.Locale;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;

public class NameUtils {
    public static String getResourceBundleId(IResource resource) {
        String packageFragment = "";
        try {
            IJavaElement propertyFile = JavaCore.create((IResource)resource.getParent());
            if (propertyFile != null && propertyFile instanceof IPackageFragment) {
                packageFragment = ((IPackageFragment)propertyFile).getElementName();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return String.valueOf(packageFragment.length() > 0 ? String.valueOf(packageFragment) + "." : "") + NameUtils.getResourceBundleName(resource);
    }

    public static String getResourceBundleName(IResource res) {
        String name = res.getName();
        String regex = "^(.*?)((_[a-z]{2,3})|(_[a-z]{2,3}_[A-Z]{2})|(_[a-z]{2,3}_[A-Z]{2}_\\w*))?(\\." + res.getFileExtension() + ")$";
        return name.replaceFirst(regex, "$1");
    }

    public static Locale getLocaleByName(String bundleName, String localeID) {
        String theBundleName = bundleName;
        if (theBundleName.contains(".")) {
            theBundleName = theBundleName.substring(theBundleName.indexOf(".") + 1);
        }
        Locale locale = null;
        if ((localeID = localeID.substring(0, localeID.length() - "properties".length() - 1)).length() == theBundleName.length()) {
            return null;
        }
        localeID = localeID.substring(theBundleName.length() + 1);
        String[] localeTokens = localeID.split("_");
        switch (localeTokens.length) {
            case 1: {
                locale = new Locale(localeTokens[0]);
                break;
            }
            case 2: {
                locale = new Locale(localeTokens[0], localeTokens[1]);
                break;
            }
            case 3: {
                locale = new Locale(localeTokens[0], localeTokens[1], localeTokens[2]);
                break;
            }
            default: {
                locale = null;
            }
        }
        return locale;
    }
}

