/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.bundle;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.eclipse.babel.core.message.internal.MessageException;
import org.eclipse.babel.core.message.internal.MessagesBundle;
import org.eclipse.babel.core.message.resource.internal.AbstractPropertiesResource;
import org.eclipse.babel.core.message.resource.internal.PropertiesIFileResource;
import org.eclipse.babel.core.message.resource.ser.PropertiesDeserializer;
import org.eclipse.babel.core.message.resource.ser.PropertiesSerializer;
import org.eclipse.babel.core.message.strategy.IMessagesBundleGroupStrategy;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.editor.resource.EclipsePropertiesEditorResource;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.part.FileEditorInput;

public class DefaultBundleGroupStrategy
implements IMessagesBundleGroupStrategy {
    protected static final String PROPERTIES_EDITOR_CLASS_NAME = "org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditor";
    protected static final MessagesBundle[] EMPTY_BUNDLES = new MessagesBundle[0];
    protected IEditorSite site;
    private IFile file;
    private final String baseName;
    private final String fileMatchPattern;

    public DefaultBundleGroupStrategy(IEditorSite site, IFile file) {
        this.file = file;
        this.site = site;
        String patternCore = "((_[a-z]{2,3})|(_[a-z]{2,3}_[A-Z]{2})|(_[a-z]{2,3}_[A-Z]{2}_\\w*))?(\\." + file.getFileExtension() + ")$";
        String namePattern = "^(.*?)" + patternCore;
        this.baseName = file.getName().replaceFirst(namePattern, "$1");
        this.fileMatchPattern = "^(" + this.baseName + ")" + patternCore;
    }

    @Override
    public String createMessagesBundleGroupName() {
        return DefaultBundleGroupStrategy.getResourceBundleId((IResource)this.file);
    }

    @Override
    public String createMessagesBundleId() {
        return DefaultBundleGroupStrategy.getResourceBundleId((IResource)this.file);
    }

    public static String getResourceBundleId(IResource resource) {
        String packageFragment = "";
        try {
            IJavaElement propertyFile = JavaCore.create((IResource)resource.getParent());
            if (propertyFile != null && propertyFile instanceof IPackageFragment) {
                packageFragment = ((IPackageFragment)propertyFile).getElementName();
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {}
        return String.valueOf(packageFragment.length() > 0 ? String.valueOf(packageFragment) + "." : "") + DefaultBundleGroupStrategy.getResourceBundleName(resource);
    }

    public static String getResourceBundleName(IResource res) {
        String name = res.getName();
        String regex = "^(.*?)((_[a-z]{2,3})|(_[a-z]{2,3}_[A-Z]{2})|(_[a-z]{2,3}_[A-Z]{2}_\\w*))?(\\." + res.getFileExtension() + ")$";
        return name.replaceFirst(regex, "$1");
    }

    @Override
    public MessagesBundle[] loadMessagesBundles() throws MessageException {
        ArrayList<MessagesBundle> bundles = new ArrayList<MessagesBundle>();
        this.collectBundlesInContainer(this.file.getParent(), bundles);
        return bundles.toArray(EMPTY_BUNDLES);
    }

    protected void collectBundlesInContainer(IContainer container, Collection<MessagesBundle> bundlesCollector) throws MessageException {
        if (!container.exists()) {
            return;
        }
        IResource[] resources = null;
        try {
            resources = container.members();
        }
        catch (CoreException e) {
            throw new MessageException("Can't load resource bundles.", e);
        }
        int i = 0;
        while (i < resources.length) {
            String localeText;
            Locale locale;
            IResource resource = resources[i];
            String resourceName = resource.getName();
            if (resource instanceof IFile && resourceName.matches(this.fileMatchPattern) && UIUtils.isDisplayed(locale = BabelUtils.parseLocale(localeText = resourceName.replaceFirst(this.fileMatchPattern, "$2")))) {
                bundlesCollector.add(this.createBundle(locale, resource));
            }
            ++i;
        }
    }

    @Override
    public MessagesBundle createMessagesBundle(Locale locale) {
        IFile openedFile = this.getOpenedFile();
        IPath path = openedFile.getProjectRelativePath();
        String localeStr = locale != null ? "_" + locale.toString() : "";
        String newFilename = String.valueOf(this.getBaseName()) + localeStr + "." + openedFile.getFileExtension();
        IFile newFile = openedFile.getProject().getFile(path.removeLastSegments(1).addTrailingSeparator() + newFilename);
        if (!newFile.exists()) {
            try {
                newFile.create((InputStream)new ByteArrayInputStream(new byte[0]), 0, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
        return this.createBundle(locale, (IResource)newFile);
    }

    protected MessagesBundle createBundle(Locale locale, IResource resource) throws MessageException {
        try {
            AbstractPropertiesResource messagesResource = this.site == null ? new PropertiesIFileResource(locale, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), (IFile)resource, MessagesEditorPlugin.getDefault()) : new EclipsePropertiesEditorResource(locale, new PropertiesSerializer(MsgEditorPreferences.getSerializerConfig()), new PropertiesDeserializer(MsgEditorPreferences.getDeserializerConfig()), this.createEditor(resource, locale));
            return new MessagesBundle(messagesResource);
        }
        catch (PartInitException e) {
            throw new MessageException("Cannot create bundle for locale " + locale + " and resource " + resource, e);
        }
    }

    protected TextEditor createEditor(IResource resource, Locale locale) throws PartInitException {
        TextEditor textEditor = null;
        if (resource != null && resource instanceof IFile) {
            try {
                resource.refreshLocal(0, null);
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            FileEditorInput newEditorInput = new FileEditorInput((IFile)resource);
            textEditor = null;
            try {
                textEditor = (TextEditor)Class.forName(PROPERTIES_EDITOR_CLASS_NAME).newInstance();
            }
            catch (Exception exception) {
                textEditor = new TextEditor();
            }
            textEditor.init(this.site, (IEditorInput)newEditorInput);
        }
        return textEditor;
    }

    protected IFile getOpenedFile() {
        return this.file;
    }

    protected String getBaseName() {
        return this.baseName;
    }

    @Override
    public String getProjectName() {
        return ResourcesPlugin.getWorkspace().getRoot().getProject(this.file.getFullPath().segments()[0]).getName();
    }
}

