/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n;

import java.util.Locale;
import org.eclipse.babel.core.message.IMessage;
import org.eclipse.babel.core.message.IMessagesBundle;
import org.eclipse.babel.core.message.internal.Message;
import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.util.BabelUtils;
import org.eclipse.babel.editor.IMessagesEditorChangeListener;
import org.eclipse.babel.editor.i18n.EntryLeftBanner;
import org.eclipse.babel.editor.i18n.EntryRightBanner;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.internal.MessagesEditorChangeAdapter;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.widgets.NullableText;
import org.eclipse.swt.custom.CBanner;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.editors.text.TextEditor;

public abstract class AbstractI18NEntry
extends Composite {
    protected final AbstractMessagesEditor editor;
    protected final Locale locale;
    private boolean expanded = true;
    protected NullableText textBox;
    private CBanner banner;
    protected String focusGainedText;
    public static final String INSTANCE_CLASS = "org.eclipse.babel.editor.i18n.I18NEntry";
    private IMessagesEditorChangeListener msgEditorUpdateKey = new MessagesEditorChangeAdapter(){

        @Override
        public void selectedKeyChanged(String oldKey, String newKey) {
            AbstractI18NEntry.this.updateKey(newKey);
        }
    };

    public AbstractI18NEntry(Composite parent, AbstractMessagesEditor editor, Locale locale) {
        super(parent, 0);
        this.editor = editor;
        this.locale = locale;
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        this.setLayoutData(gd);
        this.banner = new CBanner((Composite)this, 0);
        EntryLeftBanner bannerLeft = new EntryLeftBanner((Composite)this.banner, this);
        EntryRightBanner bannerRight = new EntryRightBanner((Composite)this.banner, this);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        this.banner.setLeft((Control)bannerLeft);
        this.banner.setRight((Control)bannerRight);
        this.banner.setSimple(false);
        this.banner.setLayoutData((Object)gridData);
        this.createTextbox();
    }

    public AbstractMessagesEditor getResourceBundleEditor() {
        return this.editor;
    }

    public void setExpanded(boolean expanded) {
        this.expanded = expanded;
        this.textBox.setVisible(expanded);
        if (expanded) {
            GridData gridData = new GridData();
            gridData.verticalAlignment = 4;
            gridData.grabExcessVerticalSpace = true;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            gridData.heightHint = UIUtils.getHeightInChars((Control)this.textBox, 3);
            this.textBox.setLayoutData(gridData);
            GridData gd = new GridData(1808);
            this.setLayoutData(gd);
            this.getParent().pack();
            this.getParent().layout(true, true);
        } else {
            GridData gridData = (GridData)this.textBox.getLayoutData();
            gridData.verticalAlignment = 1;
            gridData.grabExcessVerticalSpace = false;
            this.textBox.setLayoutData(gridData);
            gridData = (GridData)this.getLayoutData();
            gridData.heightHint = this.banner.getSize().y;
            gridData.verticalAlignment = 1;
            gridData.grabExcessVerticalSpace = false;
            this.setLayoutData(gridData);
            this.getParent().pack();
            this.getParent().layout(true, true);
        }
    }

    public boolean getExpanded() {
        return this.expanded;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public boolean isEditable() {
        MessagesBundleGroup messagesBundleGroup = this.editor.getBundleGroup();
        IMessagesBundle bundle = messagesBundleGroup.getMessagesBundle(this.locale);
        return ((TextEditor)bundle.getResource().getSource()).isEditable();
    }

    public String getResourceLocationLabel() {
        MessagesBundleGroup messagesBundleGroup = this.editor.getBundleGroup();
        IMessagesBundle bundle = messagesBundleGroup.getMessagesBundle(this.locale);
        return bundle.getResource().getResourceLocationLabel();
    }

    private void createTextbox() {
        this.textBox = new NullableText(this, 2882, this.locale);
        this.textBox.setEnabled(false);
        this.textBox.setOrientation(UIUtils.getOrientation(this.locale));
        this.textBox.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent event) {
                AbstractI18NEntry.this.focusGainedText = AbstractI18NEntry.this.textBox.getText();
            }

            public void focusLost(FocusEvent event) {
                AbstractI18NEntry.this.updateModel();
            }
        });
        this.textBox.setEditable(this.isEditable());
        this.textBox.addTraverseListener(new TraverseListener(){

            public void keyTraversed(TraverseEvent event) {
            }
        });
        this.textBox.addKeyListener(this.getKeyListener());
        this.textBox.getTextBox().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (AbstractI18NEntry.this.textBox.isDirty()) {
                    AbstractI18NEntry.this.updateModel();
                    AbstractI18NEntry.this.textBox.setDirty(false);
                }
            }
        });
        this.editor.addChangeListener(this.msgEditorUpdateKey);
    }

    abstract void updateKey(String var1);

    abstract KeyListener getKeyListener();

    protected void updateModel() {
        if (this.editor.getSelectedKey() != null && !BabelUtils.equals(this.focusGainedText, this.textBox.getText())) {
            String key;
            MessagesBundleGroup messagesBundleGroup = this.editor.getBundleGroup();
            IMessage entry = messagesBundleGroup.getMessage(key = this.editor.getSelectedKey(), this.locale);
            if (entry == null) {
                entry = new Message(key, this.locale);
                IMessagesBundle messagesBundle = messagesBundleGroup.getMessagesBundle(this.locale);
                if (messagesBundle != null) {
                    messagesBundle.addMessage(entry);
                }
            }
            entry.setText(this.textBox.getText());
        }
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.textBox.setEnabled(enabled);
    }

    public void dispose() {
        this.editor.removeChangeListener(this.msgEditorUpdateKey);
        super.dispose();
    }
}

