/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.i18n.actions;

import java.util.Locale;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class ShowDuplicateAction
extends Action {
    private final String[] keys;
    private final String key;
    private final Locale locale;

    public ShowDuplicateAction(String[] keys, String key, Locale locale) {
        this.keys = keys;
        this.key = key;
        this.locale = locale;
        this.setText("Show duplicate keys.");
        this.setImageDescriptor(UIUtils.getImageDescriptor("duplicate.gif"));
        this.setToolTipText("Check duplicate values");
    }

    public void run() {
        StringBuffer buf = new StringBuffer("\"" + this.key + "\" (" + UIUtils.getDisplayName(this.locale) + ") has the same " + "value as the following key(s): \n\n");
        if (this.keys != null) {
            int i = 0;
            while (i < this.keys.length) {
                String duplKey = this.keys[i];
                if (!this.key.equals(duplKey)) {
                    buf.append("    \ufffd ");
                    buf.append(duplKey);
                    buf.append(" (" + UIUtils.getDisplayName(this.locale) + ")");
                    buf.append("\n");
                }
                ++i;
            }
            MessageDialog.openInformation((Shell)Display.getDefault().getActiveShell(), (String)"Duplicate value", (String)buf.toString());
        }
    }
}

