/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.internal;

import org.eclipse.babel.editor.actions.FilterKeysAction;
import org.eclipse.babel.editor.actions.KeyTreeVisibleAction;
import org.eclipse.babel.editor.actions.NewLocaleAction;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDEActionFactory;
import org.eclipse.ui.part.MultiPageEditorActionBarContributor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;

public class MessagesEditorContributor
extends MultiPageEditorActionBarContributor {
    private IEditorPart activeEditorPart;
    private KeyTreeVisibleAction toggleKeyTreeAction;
    private NewLocaleAction newLocaleAction;
    private IMenuManager resourceBundleMenu;
    private static String resourceBundleMenuID;
    public static ActionGroup FILTERS;

    static {
        FILTERS = new FilterKeysActionGroup();
    }

    public MessagesEditorContributor() {
        this.createActions();
    }

    protected IAction getAction(ITextEditor editor, String actionID) {
        return editor == null ? null : editor.getAction(actionID);
    }

    public void setActivePage(IEditorPart part) {
        if (this.activeEditorPart == part) {
            return;
        }
        this.activeEditorPart = part;
        IActionBars actionBars = this.getActionBars();
        if (actionBars != null) {
            ITextEditor editor = part instanceof ITextEditor ? (ITextEditor)part : null;
            actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), this.getAction(editor, ITextEditorActionConstants.DELETE));
            actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), this.getAction(editor, ITextEditorActionConstants.UNDO));
            actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), this.getAction(editor, ITextEditorActionConstants.REDO));
            actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), this.getAction(editor, ITextEditorActionConstants.CUT));
            actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), this.getAction(editor, ITextEditorActionConstants.COPY));
            actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), this.getAction(editor, ITextEditorActionConstants.PASTE));
            actionBars.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), this.getAction(editor, ITextEditorActionConstants.SELECT_ALL));
            actionBars.setGlobalActionHandler(ActionFactory.FIND.getId(), this.getAction(editor, ITextEditorActionConstants.FIND));
            actionBars.setGlobalActionHandler(IDEActionFactory.BOOKMARK.getId(), this.getAction(editor, IDEActionFactory.BOOKMARK.getId()));
            actionBars.updateActionBars();
        }
    }

    private void createActions() {
        this.toggleKeyTreeAction = new KeyTreeVisibleAction();
        this.newLocaleAction = new NewLocaleAction();
    }

    public void contributeToMenu(IMenuManager manager) {
        this.resourceBundleMenu = new MenuManager("&Messages", resourceBundleMenuID);
        manager.prependToGroup("edit", (IContributionItem)this.resourceBundleMenu);
        this.resourceBundleMenu.add((IAction)this.toggleKeyTreeAction);
        this.resourceBundleMenu.add((IAction)this.newLocaleAction);
        FILTERS.fillContextMenu(this.resourceBundleMenu);
    }

    public void contributeToToolBar(IToolBarManager manager) {
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.toggleKeyTreeAction);
        manager.add((IAction)this.newLocaleAction);
        ((FilterKeysActionGroup)FILTERS).fillActionBars(this.getActionBars());
    }

    public void setActiveEditor(IEditorPart part) {
        super.setActiveEditor(part);
        AbstractMessagesEditor me = part instanceof AbstractMessagesEditor ? (AbstractMessagesEditor)part : null;
        this.toggleKeyTreeAction.setEditor(me);
        ((FilterKeysActionGroup)FILTERS).setActiveEditor(part);
        this.newLocaleAction.setEditor(me);
    }

    private static class FilterKeysActionGroup
    extends ActionGroup {
        FilterKeysAction[] filtersAction = new FilterKeysAction[4];

        public FilterKeysActionGroup() {
            this.filtersAction[0] = new FilterKeysAction(0);
            this.filtersAction[1] = new FilterKeysAction(2);
            this.filtersAction[2] = new FilterKeysAction(1);
            this.filtersAction[3] = new FilterKeysAction(3);
        }

        public void fillActionBars(IActionBars actionBars) {
            int i = 0;
            while (i < this.filtersAction.length) {
                actionBars.getToolBarManager().add((IAction)this.filtersAction[i]);
                ++i;
            }
        }

        public void fillContextMenu(IMenuManager menu) {
            MenuManager filters = new MenuManager("Filters");
            int i = 0;
            while (i < this.filtersAction.length) {
                filters.add((IAction)this.filtersAction[i]);
                ++i;
            }
            menu.add((IContributionItem)filters);
        }

        public void updateActionBars() {
            int i = 0;
            while (i < this.filtersAction.length) {
                this.filtersAction[i].update();
                ++i;
            }
        }

        public void setActiveEditor(IEditorPart part) {
            AbstractMessagesEditor me = part instanceof AbstractMessagesEditor ? (AbstractMessagesEditor)part : null;
            int i = 0;
            while (i < this.filtersAction.length) {
                this.filtersAction[i].setEditor(me);
                ++i;
            }
        }
    }
}

