/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.preferences;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public abstract class AbstractPrefPage
extends PreferencePage
implements IWorkbenchPreferencePage {
    protected final int indentPixels = 20;
    protected final Map<Text, String> errors = new HashMap<Text, String>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(MessagesEditorPlugin.getDefault().getPreferenceStore());
    }

    protected Composite createFieldComposite(Composite parent) {
        return this.createFieldComposite(parent, 0);
    }

    protected Composite createFieldComposite(Composite parent, int indent) {
        Composite composite = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = indent;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        composite.setLayout((Layout)gridLayout);
        return composite;
    }

    protected void setWidthInChars(Control field, int widthInChars) {
        GridData gd = new GridData();
        gd.widthHint = UIUtils.getWidthInChars(field, widthInChars);
        field.setLayoutData((Object)gd);
    }

    protected class DoubleTextValidatorKeyListener
    extends KeyAdapter {
        private String errMsg;
        private double minValue;
        private double maxValue;

        public DoubleTextValidatorKeyListener(String errMsg) {
            this.errMsg = errMsg;
        }

        public DoubleTextValidatorKeyListener(String errMsg, double minValue, double maxValue) {
            this.errMsg = errMsg;
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public void keyReleased(KeyEvent event) {
            boolean valid;
            Text text = (Text)event.widget;
            String value = text.getText();
            boolean bl = valid = value.length() > 0;
            if (valid) {
                valid = value.matches("^\\d*\\.?\\d*$");
            }
            if (valid && this.minValue != this.maxValue) {
                double doubleValue = Double.parseDouble(value);
                valid = doubleValue >= this.minValue && doubleValue <= this.maxValue;
            }
            event.doit = valid;
            if (event.doit) {
                AbstractPrefPage.this.errors.remove(text);
                if (AbstractPrefPage.this.errors.isEmpty()) {
                    AbstractPrefPage.this.setErrorMessage(null);
                    AbstractPrefPage.this.setValid(true);
                } else {
                    AbstractPrefPage.this.setErrorMessage(AbstractPrefPage.this.errors.values().iterator().next());
                }
            } else {
                AbstractPrefPage.this.errors.put(text, this.errMsg);
                AbstractPrefPage.this.setErrorMessage(this.errMsg);
                AbstractPrefPage.this.setValid(false);
            }
        }
    }

    protected class IntTextValidatorKeyListener
    extends KeyAdapter {
        private String errMsg = null;

        public IntTextValidatorKeyListener(String errMsg) {
            this.errMsg = errMsg;
        }

        public void keyReleased(KeyEvent event) {
            Text text = (Text)event.widget;
            String value = text.getText();
            event.doit = value.matches("^\\d*$");
            if (event.doit) {
                AbstractPrefPage.this.errors.remove(text);
                if (AbstractPrefPage.this.errors.isEmpty()) {
                    AbstractPrefPage.this.setErrorMessage(null);
                    AbstractPrefPage.this.setValid(true);
                } else {
                    AbstractPrefPage.this.setErrorMessage(AbstractPrefPage.this.errors.values().iterator().next());
                }
            } else {
                AbstractPrefPage.this.errors.put(text, this.errMsg);
                AbstractPrefPage.this.setErrorMessage(this.errMsg);
                AbstractPrefPage.this.setValid(false);
            }
        }
    }
}

