/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.preferences;

import org.eclipse.babel.editor.preferences.AbstractPrefPage;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.osgi.service.prefs.BackingStoreException;

public class GeneralPrefPage
extends AbstractPrefPage {
    private Text keyGroupSeparator;
    private Text filterLocales;
    private Button convertEncodedToUnicode;
    private Button supportNL;
    private Button keyTreeHierarchical;
    private Button keyTreeExpanded;
    private Button fieldTabInserts;
    private Button setupRbeNatureAutomatically;

    protected Control createContents(Composite parent) {
        Composite field = null;
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        field = this.createFieldComposite(composite);
        new Label(field, 0).setText(Messages.prefs_groupSep);
        this.keyGroupSeparator = new Text(field, 2048);
        this.keyGroupSeparator.setText(MsgEditorPreferences.getGroupLevelSeparator());
        this.keyGroupSeparator.setTextLimit(2);
        field = this.createFieldComposite(composite);
        Label filterLocalesLabel = new Label(field, 0);
        filterLocalesLabel.setText(Messages.prefs_filterLocales_label);
        filterLocalesLabel.setToolTipText(Messages.prefs_filterLocales_tooltip);
        this.filterLocales = new Text(field, 2048);
        this.filterLocales.setText(MsgEditorPreferences.getFilterLocalesStringMatcher());
        this.filterLocales.setTextLimit(22);
        this.setWidthInChars((Control)this.filterLocales, 16);
        field = this.createFieldComposite(composite);
        this.convertEncodedToUnicode = new Button(field, 32);
        this.convertEncodedToUnicode.setSelection(MsgEditorPreferences.getUnicodeEscapeEnabled());
        new Label(field, 0).setText(Messages.prefs_convertEncoded);
        field = this.createFieldComposite(composite);
        this.supportNL = new Button(field, 32);
        this.supportNL.setSelection(MsgEditorPreferences.getNLSupportEnabled());
        new Label(field, 0).setText(Messages.prefs_supportNL);
        field = this.createFieldComposite(composite);
        this.setupRbeNatureAutomatically = new Button(field, 32);
        this.setupRbeNatureAutomatically.setSelection(MsgEditorPreferences.isBuilderSetupAutomatically());
        new Label(field, 0).setText(Messages.prefs_setupValidationBuilderAutomatically);
        field = this.createFieldComposite(composite);
        this.keyTreeHierarchical = new Button(field, 32);
        this.keyTreeHierarchical.setSelection(MsgEditorPreferences.getKeyTreeHierarchical());
        new Label(field, 0).setText(Messages.prefs_keyTree_hierarchical);
        field = this.createFieldComposite(composite);
        this.keyTreeExpanded = new Button(field, 32);
        this.keyTreeExpanded.setSelection(MsgEditorPreferences.getKeyTreeExpanded());
        new Label(field, 0).setText(Messages.prefs_keyTree_expanded);
        field = this.createFieldComposite(composite);
        this.fieldTabInserts = new Button(field, 32);
        this.fieldTabInserts.setSelection(MsgEditorPreferences.getFieldTabInserts());
        new Label(field, 0).setText(Messages.prefs_fieldTabInserts);
        this.refreshEnabledStatuses();
        return composite;
    }

    public boolean performOk() {
        IEclipsePreferences prefs = MsgEditorPreferences.getEclipsePreferenceStore();
        prefs.put("groupLevelSeparator", this.keyGroupSeparator.getText());
        prefs.put("localesFilterStringMatchers", this.filterLocales.getText());
        prefs.putBoolean("unicodeUnescapeEnabled", this.convertEncodedToUnicode.getSelection());
        prefs.putBoolean("nLSupportEnabled", this.supportNL.getSelection());
        prefs.putBoolean("addMsgEditorBuilderToJavaProjects", this.setupRbeNatureAutomatically.getSelection());
        prefs.putBoolean("keyTreeHierarchical", this.keyTreeHierarchical.getSelection());
        prefs.putBoolean("keyTreeExpanded", this.keyTreeExpanded.getSelection());
        prefs.putBoolean("fieldTabInserts", this.fieldTabInserts.getSelection());
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            e.printStackTrace();
        }
        this.refreshEnabledStatuses();
        return super.performOk();
    }

    protected void performDefaults() {
        IPreferenceStore prefs = this.getPreferenceStore();
        this.keyGroupSeparator.setText(prefs.getDefaultString("groupLevelSeparator"));
        this.filterLocales.setText(prefs.getDefaultString("localesFilterStringMatchers"));
        this.convertEncodedToUnicode.setSelection(prefs.getDefaultBoolean("unicodeUnescapeEnabled"));
        this.supportNL.setSelection(prefs.getDefaultBoolean("nLSupportEnabled"));
        this.keyTreeHierarchical.setSelection(prefs.getDefaultBoolean("keyTreeHierarchical"));
        this.keyTreeHierarchical.setSelection(prefs.getDefaultBoolean("keyTreeExpanded"));
        this.fieldTabInserts.setSelection(prefs.getDefaultBoolean("fieldTabInserts"));
        this.setupRbeNatureAutomatically.setSelection(prefs.getDefaultBoolean("addMsgEditorBuilderToJavaProjects"));
        this.refreshEnabledStatuses();
        super.performDefaults();
    }

    private void refreshEnabledStatuses() {
    }
}

