/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.actions;

import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.AbstractKeyTreeModel;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractTreeAction
extends Action {
    protected final TreeViewer treeViewer;
    protected final AbstractMessagesEditor editor;

    public AbstractTreeAction(AbstractMessagesEditor editor, TreeViewer treeViewer) {
        this.treeViewer = treeViewer;
        this.editor = editor;
    }

    public AbstractTreeAction(AbstractMessagesEditor editor, TreeViewer treeViewer, int style) {
        super("", style);
        this.treeViewer = treeViewer;
        this.editor = editor;
    }

    protected KeyTreeNode getNodeSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        return (KeyTreeNode)selection.getFirstElement();
    }

    protected KeyTreeNode[] getBranchNodes(KeyTreeNode node) {
        return ((AbstractKeyTreeModel)this.treeViewer.getInput()).getBranch(node);
    }

    protected ITreeContentProvider getContentProvider() {
        return (ITreeContentProvider)this.treeViewer.getContentProvider();
    }

    protected MessagesBundleGroup getBundleGroup() {
        return this.editor.getBundleGroup();
    }

    protected TreeViewer getTreeViewer() {
        return this.treeViewer;
    }

    protected AbstractMessagesEditor getEditor() {
        return this.editor;
    }

    protected Shell getShell() {
        return this.treeViewer.getTree().getShell();
    }
}

