/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.actions;

import org.eclipse.babel.core.message.internal.MessagesBundleGroup;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.babel.editor.internal.AbstractMessagesEditor;
import org.eclipse.babel.editor.tree.actions.AbstractTreeAction;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.messages.Messages;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.TreeViewer;

public class AddKeyAction
extends AbstractTreeAction {
    public AddKeyAction(AbstractMessagesEditor editor, TreeViewer treeViewer) {
        super(editor, treeViewer);
        this.setText(String.valueOf(Messages.key_add) + " ...");
        this.setImageDescriptor(UIUtils.getImageDescriptor("add.png"));
        this.setToolTipText(String.valueOf(Messages.key_add) + " ...");
    }

    public void run() {
        KeyTreeNode node = this.getNodeSelection();
        String key = node != null ? node.getMessageKey() : "new_key";
        String msgHead = Messages.dialog_add_head;
        String msgBody = Messages.dialog_add_body;
        InputDialog dialog = new InputDialog(this.getShell(), msgHead, msgBody, key, new IInputValidator(){

            public String isValid(String newText) {
                if (AddKeyAction.this.getBundleGroup().isMessageKey(newText)) {
                    return Messages.dialog_error_exists;
                }
                return null;
            }
        });
        dialog.open();
        if (dialog.getReturnCode() == 0) {
            String inputKey = dialog.getValue();
            MessagesBundleGroup messagesBundleGroup = this.getBundleGroup();
            messagesBundleGroup.addMessages(inputKey);
        }
    }
}

