/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.tree.internal;

import java.util.ArrayList;
import org.eclipse.babel.core.message.tree.IKeyTreeNode;
import org.eclipse.babel.core.message.tree.IKeyTreeVisitor;
import org.eclipse.babel.core.message.tree.TreeType;
import org.eclipse.babel.core.message.tree.internal.AbstractKeyTreeModel;
import org.eclipse.babel.core.message.tree.internal.KeyTreeNode;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;

public class KeyTreeContentProvider
implements ITreeContentProvider {
    private AbstractKeyTreeModel keyTreeModel;
    private Viewer viewer;
    private TreeType treeType;

    public KeyTreeContentProvider(TreeType treeType) {
        this.treeType = treeType;
    }

    public Object[] getChildren(Object parentElement) {
        KeyTreeNode parentNode = (KeyTreeNode)parentElement;
        switch (this.treeType) {
            case Tree: {
                return this.keyTreeModel.getChildren(parentNode);
            }
            case Flat: {
                return new KeyTreeNode[0];
            }
        }
        return new KeyTreeNode[0];
    }

    public Object getParent(Object element) {
        KeyTreeNode node = (KeyTreeNode)element;
        switch (this.treeType) {
            case Tree: {
                return this.keyTreeModel.getParent(node);
            }
            case Flat: {
                return this.keyTreeModel;
            }
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        switch (this.treeType) {
            case Tree: {
                return this.keyTreeModel.getChildren((KeyTreeNode)element).length > 0;
            }
            case Flat: {
                return false;
            }
        }
        return false;
    }

    public Object[] getElements(Object inputElement) {
        switch (this.treeType) {
            case Tree: {
                return this.keyTreeModel.getRootNodes();
            }
            case Flat: {
                final ArrayList actualKeys = new ArrayList();
                IKeyTreeVisitor visitor = new IKeyTreeVisitor(){

                    @Override
                    public void visitKeyTreeNode(IKeyTreeNode node) {
                        if (node.isUsedAsKey()) {
                            actualKeys.add(node);
                        }
                    }
                };
                this.keyTreeModel.accept(visitor, this.keyTreeModel.getRootNode());
                return actualKeys.toArray();
            }
        }
        return new KeyTreeNode[0];
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.viewer = (TreeViewer)viewer;
        this.keyTreeModel = (AbstractKeyTreeModel)newInput;
    }

    public TreeType getTreeType() {
        return this.treeType;
    }

    public void setTreeType(TreeType treeType) {
        if (this.treeType != treeType) {
            this.treeType = treeType;
            this.viewer.refresh();
        }
    }
}

