/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.util;

import java.awt.ComponentOrientation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Locale;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.messages.Messages;
import org.eclipse.babel.swt.ResourceManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public final class UIUtils {
    public static final String IMAGE_RESOURCE_BUNDLE = "resourcebundle.gif";
    public static final String IMAGE_PROPERTIES_FILE = "propertiesfile.gif";
    public static final String IMAGE_NEW_PROPERTIES_FILE = "newpropertiesfile.gif";
    public static final String IMAGE_LAYOUT_HIERARCHICAL = "hierarchicalLayout.gif";
    public static final String IMAGE_LAYOUT_FLAT = "flatLayout.gif";
    public static final String IMAGE_ADD = "add.png";
    public static final String IMAGE_RENAME = "rename.gif";
    public static final String IMAGE_REFACTORING = "refactoring.png";
    public static final String IMAGE_VIEW_LEFT = "viewLeft.gif";
    public static final String IMAGE_LOCALE = "locale.gif";
    public static final String IMAGE_NEW_LOCALE = "newLocale.gif";
    public static final String IMAGE_EXPAND_ALL = "expandall.png";
    public static final String IMAGE_COLLAPSE_ALL = "collapseall.png";
    public static final String IMAGE_KEY = "keyDefault.png";
    public static final String IMAGE_INCOMPLETE_ENTRIES = "incomplete.gif";
    public static final String IMAGE_EMPTY = "empty.gif";
    public static final String IMAGE_MISSING_TRANSLATION = "missing_translation.gif";
    public static final String IMAGE_UNUSED_TRANSLATION = "unused_translation.png";
    public static final String IMAGE_UNUSED_AND_MISSING_TRANSLATIONS = "unused_and_missing_translations.png";
    public static final String IMAGE_WARNED_TRANSLATION = "warned_translation.png";
    public static final String IMAGE_DUPLICATE = "duplicate.gif";
    public static final String IMAGE_KEY_MISSING_TRANSLATION = "MissingTranslationImageKey";
    public static final String IMAGE_KEY_UNUSED_TRANSLATION = "UnusedTranslationImageKey";
    public static final String IMAGE_KEY_MISSING_UNUSED_TRANSLATION = "MissingUnusedTranslationImageKey";
    public static final String IMAGE_KEY_DUPLICATE_ENTRY_TRANSLATION = "DuplicateEntryTranslationImageKey";
    public static final String IMAGE_KEY_UNUSED_DUPLICATE_ENTRY_TRANSLATION = "UnusedDuplicateEntryTranslationImageKey";
    public static final String IMAGE_WARNING = "warning.gif";
    public static final String IMAGE_ERROR = "error_co.gif";
    public static final String PDE_NATURE = "org.eclipse.pde.PluginNature";
    public static final String JDT_JAVA_NATURE = "org.eclipse.jdt.core.javanature";
    public static final Locale ROOT_LOCALE = new Locale("");

    public static final void sortLocales(Locale[] locales) {
        ArrayList<Locale> localesList = new ArrayList<Locale>(Arrays.asList(locales));
        Comparator<Locale> comp = new Comparator<Locale>(){

            @Override
            public int compare(Locale l1, Locale l2) {
                if (ROOT_LOCALE.equals(l1)) {
                    return -1;
                }
                if (ROOT_LOCALE.equals(l2)) {
                    return 1;
                }
                String name1 = "";
                String name2 = "";
                if (l1 != null) {
                    name1 = l1.getDisplayName();
                }
                if (l2 != null) {
                    name2 = l2.getDisplayName();
                }
                return name1.compareTo(name2);
            }
        };
        Collections.sort(localesList, comp);
        int i = 0;
        while (i < locales.length) {
            locales[i] = (Locale)localesList.get(i);
            ++i;
        }
    }

    public static String wildcardToRegex(String wildcard) {
        StringBuffer s = new StringBuffer(wildcard.length());
        s.append('^');
        int i = 0;
        int is = wildcard.length();
        while (i < is) {
            char c = wildcard.charAt(i);
            switch (c) {
                case '*': {
                    s.append(".*");
                    break;
                }
                case '?': {
                    s.append(".");
                    break;
                }
                case '$': 
                case '(': 
                case ')': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '^': 
                case '{': 
                case '|': 
                case '}': {
                    s.append("\\");
                    s.append(c);
                    break;
                }
                default: {
                    s.append(c);
                }
            }
            ++i;
        }
        s.append('$');
        return s.toString();
    }

    public static boolean isDisplayed(Locale locale) {
        if (ROOT_LOCALE.equals(locale) || locale == null) {
            return true;
        }
        String stringPatterns = MsgEditorPreferences.getFilterLocalesStringMatcher();
        String[] wildcards = stringPatterns.split(",");
        if (wildcards == null || wildcards.length == 0) {
            return true;
        }
        String locStr = locale.toString();
        int i = 0;
        while (i < wildcards.length) {
            if (locStr.matches(UIUtils.wildcardToRegex(wildcards[i]))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static Locale[] filterLocales(Locale[] locales) {
        String stringPatterns = MsgEditorPreferences.getFilterLocalesStringMatcher();
        HashSet<Locale> already = new HashSet<Locale>();
        ArrayList<Locale> result = new ArrayList<Locale>();
        int j = 0;
        while (j < locales.length) {
            Locale loc = locales[j];
            if (ROOT_LOCALE.equals(loc) || loc == null) {
                already.add(loc);
                result.add(loc);
                break;
            }
            ++j;
        }
        String[] wildcards = stringPatterns.split(",");
        int pi = 0;
        while (pi < wildcards.length) {
            String pattern = UIUtils.wildcardToRegex(wildcards[pi]);
            int j2 = 0;
            while (j2 < locales.length) {
                Locale loc = locales[j2];
                if (!already.contains(loc) && loc != null && loc.toString().matches(pattern)) {
                    already.add(loc);
                    result.add(loc);
                    if (already.size() == locales.length) {
                        int k = 0;
                        while (k < locales.length) {
                            locales[k] = (Locale)result.get(k);
                            ++k;
                        }
                        return locales;
                    }
                }
                ++j2;
            }
            ++pi;
        }
        Locale[] filtered = new Locale[result.size()];
        int k = 0;
        while (k < filtered.length) {
            filtered[k] = (Locale)result.get(k);
            ++k;
        }
        return filtered;
    }

    private UIUtils() {
    }

    public static Font createFont(String fontKey, Control control, int style) {
        return UIUtils.createFont(fontKey, control, style, 0);
    }

    public static Font createFont(String fontKey, Control control, int style, int relSize) {
        return ResourceManager.getWidgetFont(fontKey, control, style, relSize);
    }

    public static Color getSystemColor(int colorId) {
        return MessagesEditorPlugin.getDefault().getWorkbench().getDisplay().getSystemColor(colorId);
    }

    public static int getWidthInChars(Control control, int numOfChars) {
        GC gc = new GC((Drawable)control);
        Point extent = gc.textExtent("W");
        gc.dispose();
        return numOfChars * extent.x;
    }

    public static int getHeightInChars(Control control, int numOfChars) {
        GC gc = new GC((Drawable)control);
        Point extent = gc.textExtent("W");
        gc.dispose();
        return numOfChars * extent.y;
    }

    public static void showErrorDialog(Shell shell, CoreException exception, String message) {
        exception.printStackTrace();
        ErrorDialog.openError((Shell)shell, (String)message, (String)exception.getLocalizedMessage(), (IStatus)exception.getStatus());
    }

    public static void showErrorDialog(Shell shell, Exception exception, String message) {
        exception.printStackTrace();
        Status status = new Status(4, "com.jaspersoft.studio.babel.editor", 0, String.valueOf(message) + " " + Messages.error_seeLogs, (Throwable)exception);
        ErrorDialog.openError((Shell)shell, (String)message, (String)exception.getLocalizedMessage(), (IStatus)status);
    }

    public static String getDisplayName(Locale locale) {
        if (locale == null || ROOT_LOCALE.equals(locale)) {
            return Messages.editor_i18nentry_rootlocale_label;
        }
        return locale.getDisplayName();
    }

    public static ImageDescriptor getImageDescriptor(String name) {
        return MessagesEditorPlugin.getImageDescriptor(name);
    }

    public static Image getImage(String imageName) {
        ImageDescriptor desc = MessagesEditorPlugin.getImageDescriptor(imageName);
        if (desc == null) {
            return null;
        }
        return ResourceManager.getImage(desc);
    }

    public static Image getKeyImage() {
        Image image = UIUtils.getImage(IMAGE_KEY);
        return image;
    }

    public static Image getMissingTranslationImage() {
        Image result = ResourceManager.getImage(IMAGE_KEY_MISSING_TRANSLATION);
        if (result == null) {
            Image image = UIUtils.getImage(IMAGE_KEY);
            ImageDescriptor missing = ImageDescriptor.createFromImage((Image)UIUtils.getImage(IMAGE_ERROR));
            result = new DecorationOverlayIcon(image, missing, 3).createImage();
            ResourceManager.addImage(IMAGE_KEY_MISSING_TRANSLATION, result);
        }
        return result;
    }

    public static Image getUnusedTranslationsImage() {
        Image result = ResourceManager.getImage(IMAGE_KEY_UNUSED_TRANSLATION);
        if (result == null) {
            Image image = UIUtils.getImage(IMAGE_UNUSED_TRANSLATION);
            ImageDescriptor missing = ImageDescriptor.createFromImage((Image)UIUtils.getImage(IMAGE_WARNING));
            result = new DecorationOverlayIcon(image, missing, 3).createImage();
            ResourceManager.addImage(IMAGE_KEY_UNUSED_TRANSLATION, result);
        }
        return result;
    }

    public static Image getMissingAndUnusedTranslationsImage() {
        Image result = ResourceManager.getImage(IMAGE_KEY_MISSING_UNUSED_TRANSLATION);
        if (result == null) {
            Image image = UIUtils.getImage(IMAGE_UNUSED_TRANSLATION);
            ImageDescriptor missing = ImageDescriptor.createFromImage((Image)UIUtils.getImage(IMAGE_ERROR));
            result = new DecorationOverlayIcon(image, missing, 3).createImage();
            ResourceManager.addImage(IMAGE_KEY_MISSING_UNUSED_TRANSLATION, result);
        }
        return result;
    }

    public static Image getDuplicateEntryImage() {
        Image result = ResourceManager.getImage(IMAGE_KEY_DUPLICATE_ENTRY_TRANSLATION);
        if (result == null) {
            Image image = UIUtils.getImage(IMAGE_KEY);
            ImageDescriptor missing = ImageDescriptor.createFromImage((Image)UIUtils.getImage(IMAGE_WARNING));
            result = new DecorationOverlayIcon(image, missing, 3).createImage();
            ResourceManager.addImage(IMAGE_KEY_DUPLICATE_ENTRY_TRANSLATION, result);
        }
        return result;
    }

    public static Image getDuplicateEntryAndUnusedTranslationsImage() {
        Image result = ResourceManager.getImage(IMAGE_KEY_UNUSED_DUPLICATE_ENTRY_TRANSLATION);
        if (result == null) {
            Image image = UIUtils.getImage(IMAGE_UNUSED_TRANSLATION);
            ImageDescriptor missing = ImageDescriptor.createFromImage((Image)UIUtils.getImage(IMAGE_DUPLICATE));
            result = new DecorationOverlayIcon(image, missing, 3).createImage();
            ResourceManager.addImage(IMAGE_KEY_UNUSED_DUPLICATE_ENTRY_TRANSLATION, result);
        }
        return result;
    }

    public static int getOrientation(Locale locale) {
        ComponentOrientation orientation;
        if (locale != null && (orientation = ComponentOrientation.getOrientation(locale)) == ComponentOrientation.RIGHT_TO_LEFT) {
            return 0x4000000;
        }
        return 0x2000000;
    }

    /*
     * Exception decompiling
     */
    public static boolean hasNature(IProject proj, String nature) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 13[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

