/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.widgets;

import java.text.Collator;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.messages.Messages;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class LocaleSelector
extends Composite {
    private static final String DEFAULT_LOCALE = "[" + Messages.editor_default + "]";
    protected Locale[] availableLocales = Locale.getAvailableLocales();
    protected Combo localesCombo;
    protected Text langText;
    protected Text countryText;
    protected Text variantText;
    protected Group selectionGroup;

    public LocaleSelector(Composite parent) {
        super(parent, 0);
        Arrays.sort(this.availableLocales, new Comparator<Locale>(){

            @Override
            public int compare(Locale locale1, Locale locale2) {
                return Collator.getInstance().compare(locale1.getDisplayName(), locale2.getDisplayName());
            }
        });
        GridLayout layout = new GridLayout();
        this.setLayout((Layout)layout);
        layout.numColumns = 1;
        layout.verticalSpacing = 20;
        this.selectionGroup = new Group((Composite)this, 0);
        layout = new GridLayout(3, false);
        this.selectionGroup.setLayout((Layout)layout);
        this.selectionGroup.setText(Messages.selector_title);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        this.localesCombo = new Combo((Composite)this.selectionGroup, 8);
        this.localesCombo.setLayoutData((Object)gd);
        this.localesCombo.add(DEFAULT_LOCALE);
        int i = 0;
        while (i < this.availableLocales.length) {
            this.localesCombo.add(this.availableLocales[i].getDisplayName());
            ++i;
        }
        this.localesCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int index = LocaleSelector.this.localesCombo.getSelectionIndex();
                if (index == 0) {
                    LocaleSelector.this.langText.setText("");
                    LocaleSelector.this.countryText.setText("");
                } else {
                    Locale locale = LocaleSelector.this.availableLocales[index - 1];
                    LocaleSelector.this.langText.setText(locale.getLanguage());
                    LocaleSelector.this.countryText.setText(locale.getCountry());
                }
                LocaleSelector.this.variantText.setText("");
            }
        });
        this.langText = new Text((Composite)this.selectionGroup, 2048);
        this.langText.setTextLimit(3);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getWidthInChars((Control)this.langText, 4);
        this.langText.setLayoutData((Object)gd);
        this.langText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LocaleSelector.this.langText.setText(LocaleSelector.this.langText.getText().toLowerCase());
                LocaleSelector.this.setLocaleOnlocalesCombo();
            }
        });
        this.countryText = new Text((Composite)this.selectionGroup, 2048);
        this.countryText.setTextLimit(2);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getWidthInChars((Control)this.countryText, 4);
        this.countryText.setLayoutData((Object)gd);
        this.countryText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LocaleSelector.this.countryText.setText(LocaleSelector.this.countryText.getText().toUpperCase());
                LocaleSelector.this.setLocaleOnlocalesCombo();
            }
        });
        this.variantText = new Text((Composite)this.selectionGroup, 2048);
        gd = new GridData(768);
        gd.widthHint = UIUtils.getWidthInChars((Control)this.variantText, 4);
        this.variantText.setLayoutData((Object)gd);
        this.variantText.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                LocaleSelector.this.setLocaleOnlocalesCombo();
            }
        });
        Label lblLang = new Label((Composite)this.selectionGroup, 0);
        lblLang.setText(Messages.selector_language);
        lblLang.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        Label lblCountry = new Label((Composite)this.selectionGroup, 0);
        lblCountry.setText(Messages.selector_country);
        lblCountry.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
        Label lblVariant = new Label((Composite)this.selectionGroup, 0);
        lblVariant.setText(Messages.selector_variant);
        lblVariant.setLayoutData((Object)new GridData(0x1000000, 128, true, false));
    }

    public Locale getSelectedLocale() {
        String lang = this.langText.getText().trim();
        String country = this.countryText.getText().trim();
        String variant = this.variantText.getText().trim();
        if (lang.length() > 0 && country.length() > 0 && variant.length() > 0) {
            return new Locale(lang, country, variant);
        }
        if (lang.length() > 0 && country.length() > 0) {
            return new Locale(lang, country);
        }
        if (lang.length() > 0) {
            return new Locale(lang);
        }
        return null;
    }

    private int getLocaleIndex(Locale locale) {
        int i = 0;
        while (i < this.availableLocales.length) {
            if (this.availableLocales[i].equals(locale)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void selectLocale(Locale locale) {
        int localeIndex = this.getLocaleIndex(locale);
        if (localeIndex == -1) {
            localeIndex = this.getLocaleIndex(new Locale(locale.getLanguage()));
        }
        if (localeIndex != -1) {
            this.localesCombo.select(localeIndex + 1);
            Locale foundLocale = this.availableLocales[localeIndex];
            this.langText.setText(foundLocale.getLanguage());
            this.countryText.setText(foundLocale.getCountry());
        }
    }

    void setLocaleOnlocalesCombo() {
        Locale locale = new Locale(this.langText.getText(), this.countryText.getText(), this.variantText.getText());
        int index = -1;
        int i = 0;
        while (i < this.availableLocales.length) {
            Locale availLocale = this.availableLocales[i];
            if (availLocale.equals(locale)) {
                index = i + 1;
            }
            ++i;
        }
        if (index >= 1) {
            this.localesCombo.select(index);
        } else {
            this.localesCombo.clearSelection();
        }
    }

    public void addModifyListener(final ModifyListener listener) {
        this.langText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                listener.modifyText(e);
            }
        });
        this.countryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                listener.modifyText(e);
            }
        });
        this.variantText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                listener.modifyText(e);
            }
        });
    }
}

