/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.widgets;

import java.util.Locale;
import java.util.Stack;
import org.eclipse.babel.editor.util.UIUtils;
import org.eclipse.babel.editor.widgets.suggestion.SuggestionBubble;
import org.eclipse.babel.editor.widgets.suggestion.provider.SuggestionProviderUtils;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NullableText
extends Composite {
    private final Text text;
    private final Color defaultColor;
    private final Color nullColor;
    private Locale locale;
    private boolean dirty;
    private boolean suggestionBubbleOn;
    private boolean isnull;
    private KeyListener keyListener = new KeyAdapter(){

        public void keyPressed(KeyEvent e) {
            if ('\b' == e.character && NullableText.this.text.getText().length() == 0) {
                NullableText.this.renderNull();
            }
        }

        public void keyReleased(KeyEvent e) {
            if (NullableText.this.text.getText().length() > 0) {
                NullableText.this.renderNormal();
            }
        }
    };

    public NullableText(Composite parent, int style, Locale locale) {
        super(parent, 0);
        this.text = new Text((Composite)this, style);
        this.text.setData("UNDO", new Stack());
        this.text.setData("REDO", new Stack());
        this.defaultColor = this.text.getBackground();
        this.nullColor = UIUtils.getSystemColor(19);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        this.setLayout((Layout)gridLayout);
        GridData gd = new GridData(1808);
        this.setLayoutData(gd);
        this.initComponents();
        this.locale = locale;
        boolean bl = this.suggestionBubbleOn = !SuggestionProviderUtils.getSuggetionProviders().isEmpty();
        if (this.suggestionBubbleOn) {
            if (locale != null) {
                new SuggestionBubble(this.text, locale.getLanguage());
            } else {
                this.text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        SuggestionBubble.setDefaultText(NullableText.this.text.getText());
                    }
                });
            }
        }
    }

    public Text getTextBox() {
        return this.text;
    }

    public void setOrientation(int orientation) {
        this.text.setOrientation(orientation);
    }

    public void setText(String text) {
        boolean bl = this.isnull = text == null;
        if (this.locale == null && this.suggestionBubbleOn) {
            SuggestionBubble.setDefaultText(text);
        }
        if (this.isnull) {
            this.text.setText("");
            this.renderNull();
        } else {
            this.text.setText(text);
            this.renderNormal();
        }
        Stack undoCache = (Stack)this.text.getData("UNDO");
        undoCache.push(this.text.getText());
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setText(String text, boolean dirty) {
        this.dirty = dirty;
        this.setText(text);
    }

    public String getText() {
        if (this.isnull) {
            return null;
        }
        return this.text.getText();
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.text.setEnabled(enabled);
    }

    private void initComponents() {
        GridData gridData = new GridData(4, 4, true, true);
        this.text.setLayoutData((Object)gridData);
        this.text.addKeyListener(this.keyListener);
    }

    private void renderNull() {
        this.isnull = true;
        if (this.isEnabled()) {
            this.text.setBackground(this.nullColor);
        } else {
            this.text.setBackground(UIUtils.getSystemColor(22));
        }
    }

    private void renderNormal() {
        this.isnull = false;
        if (this.isEnabled()) {
            this.text.setBackground(this.defaultColor);
        } else {
            this.text.setBackground(UIUtils.getSystemColor(22));
        }
    }

    public void addFocusListener(FocusListener listener) {
        this.text.addFocusListener(listener);
    }

    public void addKeyListener(KeyListener listener) {
        this.text.addKeyListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.text.removeFocusListener(listener);
    }

    public void removeKeyListener(KeyListener listener) {
        this.text.removeKeyListener(listener);
    }

    public void setEditable(boolean editable) {
        this.text.setEditable(editable);
    }
}

