/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.babel.editor.wizards.internal;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.babel.editor.preferences.MsgEditorPreferences;
import org.eclipse.babel.editor.wizards.IResourceBundleWizard;
import org.eclipse.babel.editor.wizards.internal.ResourceBundleNewWizardPage;
import org.eclipse.babel.messages.Messages;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class ResourceBundleWizard
extends Wizard
implements INewWizard,
IResourceBundleWizard {
    private ResourceBundleNewWizardPage page;
    private ISelection selection;
    private String defaultRbName = "";
    private String defaultPath = "";

    public ResourceBundleWizard() {
        this.setNeedsProgressMonitor(true);
    }

    public void addPages() {
        this.page = new ResourceBundleNewWizardPage(this.selection, this.defaultPath, this.defaultRbName);
        this.addPage((IWizardPage)this.page);
    }

    public boolean performFinish() {
        final String containerName = this.page.getContainerName();
        final String baseName = this.page.getFileName();
        final String[] locales = this.page.getLocaleStrings();
        if (!this.folderExists(containerName)) {
            String message = Messages.editor_wiz_createfolder;
            message = String.format(message, containerName);
            if (!MessageDialog.openConfirm((Shell)this.getShell(), (String)"Create Folder", (String)message)) {
                return false;
            }
        }
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.worked(1);
                        monitor.setTaskName(Messages.editor_wiz_creating);
                        IFile file = null;
                        int i = 0;
                        while (i < locales.length) {
                            String fileName = baseName;
                            fileName = locales[i].equals(ResourceBundleNewWizardPage.DEFAULT_LOCALE) ? String.valueOf(fileName) + ".properties" : String.valueOf(fileName) + "_" + locales[i] + ".properties";
                            file = ResourceBundleWizard.this.createFile(containerName, fileName, monitor);
                            ++i;
                        }
                        if (file == null) {
                            MessageDialog.openError((Shell)ResourceBundleWizard.this.getShell(), (String)"Error", (String)"Error creating file");
                            ResourceBundleWizard.this.throwCoreException("File \"" + containerName + baseName + "\" could not be created");
                        }
                        final IFile lastFile = file;
                        ResourceBundleWizard.this.getShell().getDisplay().asyncExec(new Runnable(){

                            @Override
                            public void run() {
                                IWorkbenchPage wbPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                                try {
                                    IDE.openEditor((IWorkbenchPage)wbPage, (IFile)lastFile, (boolean)true);
                                }
                                catch (PartInitException partInitException) {}
                            }
                        });
                        monitor.worked(1);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)realException.getLocalizedMessage());
            return false;
        }
        return true;
    }

    boolean folderExists(String path) {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)new Path(path));
        if (resource == null) {
            return false;
        }
        return resource.exists();
    }

    IFile createFile(String containerName, String fileName, IProgressMonitor monitor) throws CoreException {
        IContainer container;
        monitor.beginTask(String.valueOf(Messages.editor_wiz_creating) + fileName, 2);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        Path containerNamePath = new Path(containerName);
        IResource resource = root.findMember((IPath)containerNamePath);
        if (resource == null) {
            if (!this.createFolder(containerNamePath, root, monitor)) {
                MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)String.format(Messages.editor_wiz_error_couldnotcreatefolder, containerName));
                return null;
            }
        } else if (!(resource.exists() && resource instanceof IContainer || this.createFolder(containerNamePath, root, monitor))) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)String.format(Messages.editor_wiz_error_couldnotcreatefolder, containerName));
            return null;
        }
        if ((container = (IContainer)root.findMember((IPath)containerNamePath)) == null) {
            MessageDialog.openError((Shell)this.getShell(), (String)"Error", (String)String.format(Messages.editor_wiz_error_couldnotcreatefolder, containerName));
            return null;
        }
        IFile file = container.getFile((IPath)new Path(fileName));
        try {
            InputStream stream = this.openContentStream();
            if (file.exists()) {
                file.setContents(stream, true, true, monitor);
            } else {
                file.create(stream, true, monitor);
            }
            stream.close();
        }
        catch (IOException iOException) {}
        return file;
    }

    protected boolean createFolder(Path folderPath, IWorkspaceRoot root, IProgressMonitor monitor) {
        IResource baseResource = root.findMember((IPath)folderPath);
        if (baseResource != null) {
            if (baseResource.exists()) {
                return true;
            }
        } else {
            if (folderPath.segmentCount() <= 1) {
                return true;
            }
            Path oneSegmentLess = (Path)folderPath.removeLastSegments(1);
            if (this.createFolder(oneSegmentLess, root, monitor)) {
                IResource resource = root.findMember((IPath)oneSegmentLess);
                if (resource == null) {
                    return false;
                }
                if (!resource.exists() || !(resource instanceof IContainer)) {
                    return false;
                }
                IFolder folder = root.getFolder((IPath)folderPath);
                try {
                    folder.create(true, true, monitor);
                }
                catch (CoreException coreException) {
                    return false;
                }
                return true;
            }
            return false;
        }
        return true;
    }

    private InputStream openContentStream() {
        String contents = "";
        MsgEditorPreferences.getSerializerConfig().isShowSupportEnabled();
        return new ByteArrayInputStream(contents.getBytes());
    }

    private synchronized void throwCoreException(String message) throws CoreException {
        Status status = new Status(4, "org.eclipse.babel.editor", 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public void init(IWorkbench workbench, IStructuredSelection structSelection) {
        this.selection = structSelection;
    }

    @Override
    public void setBundleId(String rbName) {
        this.defaultRbName = rbName;
    }

    @Override
    public void setDefaultPath(String pathName) {
        this.defaultPath = pathName;
    }
}

