/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.editor;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.utils.compatibility.StringMatcher;
import org.eclipse.babel.editor.compat.SwtRapCompatibilityFormToolkit;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILazyContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.pde.nls.internal.ui.dialogs.ConfigureColumnsDialog;
import org.eclipse.pde.nls.internal.ui.dialogs.EditResourceBundleEntriesDialog;
import org.eclipse.pde.nls.internal.ui.dialogs.FilterOptions;
import org.eclipse.pde.nls.internal.ui.dialogs.FilterOptionsDialog;
import org.eclipse.pde.nls.internal.ui.editor.LocalizationEditorInput;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundle;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleFamily;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleKey;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleKeyList;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleModel;
import org.eclipse.pde.nls.internal.ui.parser.LocaleUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPropertyListener;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ContributionItemFactory;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.ShowInContext;

public class LocalizationEditor
extends EditorPart {
    public static final String ID = "org.eclipse.pde.nls.ui.LocalizationEditor";
    protected static final Object KEY = "key";
    private static final String PREF_SECTION_NAME = "org.eclipse.pde.nls.ui.LocalizationEditor";
    private static final String PREF_SORT_ORDER = "sortOrder";
    private static final String PREF_COLUMNS = "columns";
    private static final String PREF_FILTER_OPTIONS_FILTER_PLUGINS = "filterOptions_filterPlugins";
    private static final String PREF_FILTER_OPTIONS_PLUGIN_PATTERNS = "filterOptions_pluginPatterns";
    private static final String PREF_FILTER_OPTIONS_MISSING_ONLY = "filterOptions_missingOnly";
    private EditFilterOptionsAction editFiltersAction;
    private ConfigureColumnsAction selectLanguagesAction;
    private RefreshAction refreshAction;
    private ExportAction exportAction;
    protected SwtRapCompatibilityFormToolkit toolkit = new SwtRapCompatibilityFormToolkit(Display.getCurrent());
    private Form form;
    private Image formImage;
    protected Composite queryComposite;
    protected Text queryText;
    private Section resultsSection;
    private Composite tableComposite;
    protected TableViewer tableViewer;
    protected Table table;
    protected ArrayList<TableColumn> columns = new ArrayList();
    protected LocalizationEditorInput input;
    protected ResourceBundleKeyList entryList;
    protected FilterOptions filterOptions;
    protected Object[] columnConfigs;
    protected Object sortOrder;
    private String lastQuery = "";
    protected Job searchJob;
    private ISchedulingRule mutexRule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };
    private Label filteredLabel;

    public ResourceBundleKey getSelectedEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.tableViewer.getSelection();
        if (selection.size() == 1) {
            return (ResourceBundleKey)selection.getFirstElement();
        }
        return null;
    }

    public String getQueryText() {
        return this.queryText.getText();
    }

    public void createPartControl(Composite parent) {
        this.form = this.toolkit.createForm(parent);
        this.form.setSeparatorVisible(true);
        this.form.setText("Localization");
        this.formImage = MessagesEditorPlugin.getImageDescriptor("obj16/nls_editor.gif").createImage();
        this.form.setImage(this.formImage);
        this.toolkit.adapt((Composite)this.form);
        this.toolkit.paintBordersFor((Composite)this.form);
        Composite body = this.form.getBody();
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        body.setLayout((Layout)gridLayout);
        this.toolkit.paintBordersFor(body);
        this.toolkit.decorateFormHeading(this.form);
        this.queryComposite = this.toolkit.createComposite(body);
        GridData gd = new GridData(4, 0x1000000, true, false);
        this.queryComposite.setLayoutData((Object)gd);
        gridLayout = new GridLayout(5, false);
        gridLayout.marginHeight = 0;
        this.queryComposite.setLayout((Layout)gridLayout);
        this.toolkit.paintBordersFor(this.queryComposite);
        this.editFiltersAction = new EditFilterOptionsAction();
        this.selectLanguagesAction = new ConfigureColumnsAction();
        this.refreshAction = new RefreshAction();
        this.exportAction = new ExportAction();
        IToolBarManager toolBarManager = this.form.getToolBarManager();
        toolBarManager.add((IAction)this.refreshAction);
        toolBarManager.add((IAction)this.editFiltersAction);
        toolBarManager.add((IAction)this.selectLanguagesAction);
        toolBarManager.add((IAction)this.exportAction);
        this.form.updateToolBar();
        this.toolkit.createLabel(this.queryComposite, "Search:");
        this.queryText = this.toolkit.createText(this.queryComposite, "", 68);
        this.queryText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 0x1000002) {
                    LocalizationEditor.this.table.setFocus();
                } else if (e.keyCode == 27) {
                    LocalizationEditor.this.queryText.setText("");
                }
            }
        });
        this.queryText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LocalizationEditor.this.executeQuery();
                Object[] listeners = LocalizationEditor.this.getListeners();
                int i = 0;
                while (i < listeners.length) {
                    IPropertyListener listener = (IPropertyListener)listeners[i];
                    listener.propertyChanged((Object)this, 1);
                    ++i;
                }
            }
        });
        gd = new GridData(4, 0x1000000, true, false);
        this.queryText.setLayoutData((Object)gd);
        this.toolkit.adapt((Control)this.queryText, true, true);
        ToolBarManager toolBarManager2 = new ToolBarManager(0x800000);
        toolBarManager2.createControl(this.queryComposite);
        ToolBar control = toolBarManager2.getControl();
        this.toolkit.adapt((Composite)control);
        this.resultsSection = this.toolkit.createSection(body, 8448);
        this.resultsSection.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.resultsSection.setText("Localization Strings");
        this.toolkit.adapt((Composite)this.resultsSection);
        Composite resultsComposite = this.toolkit.createComposite((Composite)this.resultsSection, 0);
        this.toolkit.adapt(resultsComposite);
        GridLayout gridLayout2 = new GridLayout();
        gridLayout2.marginTop = 1;
        gridLayout2.marginWidth = 1;
        gridLayout2.marginHeight = 1;
        gridLayout2.horizontalSpacing = 0;
        resultsComposite.setLayout((Layout)gridLayout2);
        this.filteredLabel = new Label((Composite)this.resultsSection, 0);
        this.filteredLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        this.filteredLabel.setForeground(Display.getCurrent().getSystemColor(3));
        this.filteredLabel.setText("");
        this.toolkit.paintBordersFor(resultsComposite);
        this.resultsSection.setClient((Control)resultsComposite);
        this.resultsSection.setTextClient((Control)this.filteredLabel);
        this.tableComposite = this.toolkit.createComposite(resultsComposite, 0);
        this.tableComposite.setData("FormWidgetFactory.drawBorder", (Object)"treeBorder");
        this.toolkit.adapt(this.tableComposite);
        this.tableComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTableViewer();
        this.registerContextMenu();
        this.filterOptions = new FilterOptions();
        this.filterOptions.filterPlugins = false;
        this.filterOptions.pluginPatterns = new String[0];
        this.filterOptions.keysWithMissingEntriesOnly = false;
        this.sortOrder = KEY;
        this.columnConfigs = new Object[]{KEY, new Locale(""), new Locale("de")};
        try {
            this.loadSettings();
        }
        catch (Exception exception) {}
        this.updateColumns();
        this.updateFilterLabel();
        this.table.setSortDirection(128);
    }

    protected void updateFilterLabel() {
        if (this.filterOptions.filterPlugins || this.filterOptions.keysWithMissingEntriesOnly) {
            this.filteredLabel.setText("(filtered)");
        } else {
            this.filteredLabel.setText("");
        }
        this.filteredLabel.getParent().layout(true);
    }

    private void loadSettings() {
        String columns;
        IDialogSettings dialogSettings = MessagesEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("org.eclipse.pde.nls.ui.LocalizationEditor");
        if (section == null) {
            return;
        }
        String sortOrderString = section.get(PREF_SORT_ORDER);
        if (sortOrderString != null) {
            if (sortOrderString.equals(KEY)) {
                this.sortOrder = KEY;
            } else {
                try {
                    this.sortOrder = LocaleUtil.parseLocale(sortOrderString);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if ((columns = section.get(PREF_COLUMNS)) != null) {
            String[] cols = columns.substring(1, columns.length() - 1).split(",");
            this.columnConfigs = new Object[cols.length];
            int i = 0;
            while (i < cols.length) {
                String value = cols[i].trim();
                if (value.equals(KEY)) {
                    this.columnConfigs[i] = KEY;
                } else if (value.equals("default")) {
                    this.columnConfigs[i] = new Locale("");
                } else {
                    try {
                        this.columnConfigs[i] = LocaleUtil.parseLocale(value);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        this.columnConfigs[i] = null;
                    }
                }
                ++i;
            }
        }
        String filterOptions = section.get(PREF_FILTER_OPTIONS_FILTER_PLUGINS);
        this.filterOptions.filterPlugins = "true".equals(filterOptions);
        String patterns = section.get(PREF_FILTER_OPTIONS_PLUGIN_PATTERNS);
        if (patterns != null) {
            String[] split = patterns.substring(1, patterns.length() - 1).split(",");
            int i = 0;
            while (i < split.length) {
                split[i] = split[i].trim();
                ++i;
            }
            this.filterOptions.pluginPatterns = split;
        }
        this.filterOptions.keysWithMissingEntriesOnly = "true".equals(section.get(PREF_FILTER_OPTIONS_MISSING_ONLY));
    }

    private void saveSettings() {
        IDialogSettings dialogSettings = MessagesEditorPlugin.getDefault().getDialogSettings();
        IDialogSettings section = dialogSettings.getSection("org.eclipse.pde.nls.ui.LocalizationEditor");
        if (section == null) {
            section = dialogSettings.addNewSection("org.eclipse.pde.nls.ui.LocalizationEditor");
        }
        section.put(PREF_SORT_ORDER, this.sortOrder.toString());
        section.put(PREF_COLUMNS, Arrays.toString(this.columnConfigs));
        section.put(PREF_FILTER_OPTIONS_FILTER_PLUGINS, this.filterOptions.filterPlugins);
        section.put(PREF_FILTER_OPTIONS_PLUGIN_PATTERNS, Arrays.toString(this.filterOptions.pluginPatterns));
        section.put(PREF_FILTER_OPTIONS_MISSING_ONLY, this.filterOptions.keysWithMissingEntriesOnly);
    }

    private void createTableViewer() {
        this.table = new Table(this.tableComposite, 0x10010002);
        this.tableViewer = new TableViewer(this.table);
        this.table.setHeaderVisible(true);
        this.toolkit.adapt((Composite)this.table);
        this.toolkit.paintBordersFor((Composite)this.table);
        this.toolkit.adapt((Control)this.table, true, true);
        this.tableViewer.setContentProvider((IContentProvider)new ILazyContentProvider(){

            public void updateElement(int index) {
                LocalizationEditor.this.tableViewer.replace((Object)LocalizationEditor.this.entryList.getKey(index), index);
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        });
        this.tableViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                new EditEntryAction().run();
            }
        });
    }

    private void registerContextMenu() {
        MenuManager menuManager = new MenuManager("#PopupMenu");
        menuManager.setRemoveAllWhenShown(true);
        menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager menu) {
                LocalizationEditor.this.fillContextMenu(menu);
            }
        });
        Menu contextMenu = menuManager.createContextMenu((Control)this.table);
        this.table.setMenu(contextMenu);
        this.getSite().registerContextMenu(menuManager, this.getSite().getSelectionProvider());
    }

    protected void fillContextMenu(IMenuManager menu) {
        int selectionCount = this.table.getSelectionCount();
        if (selectionCount == 1) {
            menu.add((IAction)new EditEntryAction());
            menu.add((IContributionItem)new Separator());
        }
        MenuManager showInSubMenu = new MenuManager("&Show In");
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        IContributionItem item = ContributionItemFactory.VIEWS_SHOW_IN.create(window);
        showInSubMenu.add(item);
        menu.add((IContributionItem)showInSubMenu);
    }

    public void setFocus() {
        this.queryText.setFocus();
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public void doSaveAs() {
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.input = (LocalizationEditorInput)input;
    }

    public boolean isDirty() {
        return false;
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    public void dispose() {
        this.saveSettings();
        if (this.formImage != null) {
            this.formImage.dispose();
            this.formImage = null;
        }
        MessagesEditorPlugin.disposeModel();
    }

    protected void executeQuery() {
        String pattern;
        this.lastQuery = pattern = this.queryText.getText();
        this.executeQuery(pattern);
    }

    protected void executeQuery(final String pattern) {
        if (this.searchJob != null) {
            this.searchJob.cancel();
        }
        this.searchJob = new Job("Localization Editor Search..."){

            /*
             * WARNING - void declaration
             */
            protected IStatus run(IProgressMonitor monitor) {
                Object[] n5;
                ResourceBundleKey[] keys;
                String strPattern;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).LocalizationEditor.this.form.setBusy(true);
                    }
                });
                String keyPattern = pattern;
                if (!pattern.endsWith("*")) {
                    keyPattern = pattern.concat("*");
                }
                if ((strPattern = keyPattern).length() > 0 && !strPattern.startsWith("*")) {
                    strPattern = "*".concat(strPattern);
                }
                ResourceBundleModel model = MessagesEditorPlugin.getModel((IProgressMonitor)new NullProgressMonitor());
                Locale[] locales = LocalizationEditor.this.getLocales();
                if (!LocalizationEditor.this.filterOptions.filterPlugins || LocalizationEditor.this.filterOptions.pluginPatterns == null || LocalizationEditor.this.filterOptions.pluginPatterns.length == 0) {
                    Locale[] localeArray = locales;
                    int n = locales.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Locale locale = localeArray[n2];
                        try {
                            model.loadBundles(locale);
                        }
                        catch (CoreException e) {
                            MessagesEditorPlugin.log(e);
                        }
                        ++n2;
                    }
                    try {
                        keys = model.getAllKeys();
                    }
                    catch (CoreException e) {
                        MessagesEditorPlugin.log(e);
                        keys = new ResourceBundleKey[]{};
                    }
                } else {
                    int n6;
                    void var12_21;
                    String[] patterns = LocalizationEditor.this.filterOptions.pluginPatterns;
                    StringMatcher[] matchers = new StringMatcher[patterns.length];
                    int i = 0;
                    while (i < matchers.length) {
                        matchers[i] = new StringMatcher(patterns[i], true, false);
                        ++i;
                    }
                    int size = 0;
                    ResourceBundleFamily[] allFamilies = model.getFamilies();
                    ArrayList<Object> families = new ArrayList<Object>();
                    boolean bl = false;
                    while (var12_21 < allFamilies.length) {
                        Object family = allFamilies[var12_21];
                        String pluginId = ((ResourceBundleFamily)family).getPluginId();
                        n5 = matchers;
                        n6 = matchers.length;
                        int n = 0;
                        while (n < n6) {
                            StringMatcher matcher = n5[n];
                            if (matcher.match(pluginId)) {
                                families.add(family);
                                break;
                            }
                            ++n;
                        }
                        ++var12_21;
                    }
                    for (ResourceBundleFamily resourceBundleFamily : families) {
                        size += resourceBundleFamily.getKeyCount();
                    }
                    ArrayList<ResourceBundleKey> n = new ArrayList<ResourceBundleKey>(size);
                    for (Object family : families) {
                        ResourceBundleKey[] familyKeys;
                        n5 = locales;
                        n6 = locales.length;
                        int n2 = 0;
                        while (n2 < n6) {
                            StringMatcher locale = n5[n2];
                            try {
                                ResourceBundle bundle = ((ResourceBundleFamily)family).getBundle((Locale)locale);
                                if (bundle != null) {
                                    bundle.load();
                                }
                            }
                            catch (CoreException e) {
                                MessagesEditorPlugin.log(e);
                            }
                            ++n2;
                        }
                        ResourceBundleKey[] e = familyKeys = ((ResourceBundleFamily)family).getKeys();
                        int n3 = familyKeys.length;
                        n6 = 0;
                        while (n6 < n3) {
                            ResourceBundleKey key = e[n6];
                            n.add(key);
                            ++n6;
                        }
                    }
                    keys = n.toArray(new ResourceBundleKey[n.size()]);
                }
                ArrayList<ResourceBundleKey> filtered = new ArrayList<ResourceBundleKey>();
                StringMatcher keyMatcher = new StringMatcher(keyPattern, true, false);
                StringMatcher strMatcher = new StringMatcher(strPattern, true, false);
                ResourceBundleKey[] resourceBundleKeyArray = keys;
                int n = keys.length;
                int families = 0;
                while (families < n) {
                    block40: {
                        ResourceBundleKey key;
                        block39: {
                            key = resourceBundleKeyArray[families];
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            if (!LocalizationEditor.this.filterOptions.keysWithMissingEntriesOnly) break block39;
                            boolean hasMissingEntry = false;
                            n5 = LocalizationEditor.this.columnConfigs;
                            int objectArray2 = LocalizationEditor.this.columnConfigs.length;
                            int n8 = 0;
                            while (n8 < objectArray2) {
                                StringMatcher config = n5[n8];
                                if (config != KEY) {
                                    Locale locale = (Locale)config;
                                    String value = null;
                                    try {
                                        value = key.getValue(locale);
                                    }
                                    catch (CoreException e) {
                                        MessagesEditorPlugin.log(e);
                                    }
                                    if (value == null || value.length() == 0) {
                                        hasMissingEntry = true;
                                        break;
                                    }
                                }
                                ++n8;
                            }
                            if (!hasMissingEntry) break block40;
                        }
                        if (keyMatcher.match(key.getName())) {
                            filtered.add(key);
                        } else {
                            Object[] objectArray = LocalizationEditor.this.columnConfigs;
                            int n4 = LocalizationEditor.this.columnConfigs.length;
                            int n6 = 0;
                            while (n6 < n4) {
                                Object config = objectArray[n6];
                                if (config != KEY) {
                                    Locale locale = (Locale)config;
                                    String value = null;
                                    try {
                                        value = key.getValue(locale);
                                    }
                                    catch (CoreException e) {
                                        MessagesEditorPlugin.log(e);
                                    }
                                    if (strMatcher.match(value)) {
                                        filtered.add(key);
                                        break;
                                    }
                                }
                                ++n6;
                            }
                        }
                    }
                    ++families;
                }
                ResourceBundleKey[] array = filtered.toArray(new ResourceBundleKey[filtered.size()]);
                if (LocalizationEditor.this.sortOrder == KEY) {
                    Arrays.sort(array, new Comparator<ResourceBundleKey>(){

                        @Override
                        public int compare(ResourceBundleKey o1, ResourceBundleKey o2) {
                            return o1.getName().compareToIgnoreCase(o2.getName());
                        }
                    });
                } else {
                    Locale locale = (Locale)LocalizationEditor.this.sortOrder;
                    Arrays.sort(array, new BundleStringComparator(locale));
                }
                LocalizationEditor.this.entryList = new ResourceBundleKeyList(array);
                if (monitor.isCanceled()) {
                    return Status.OK_STATUS;
                }
                final ResourceBundleKeyList entryList2 = LocalizationEditor.this.entryList;
                Display.getDefault().syncExec(new Runnable(){

                    @Override
                    public void run() {
                        (this).LocalizationEditor.this.form.setBusy(false);
                        if (entryList2 != null) {
                            (this).LocalizationEditor.this.entryList = entryList2;
                        }
                        LocalizationEditor.this.setSearchResult((this).LocalizationEditor.this.entryList);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        this.searchJob.setSystem(true);
        this.searchJob.setRule(this.mutexRule);
        this.searchJob.schedule();
    }

    protected void updateTableLayout() {
        this.table.getParent().layout(true, true);
    }

    protected void setSearchResult(ResourceBundleKeyList entryList) {
        this.table.removeAll();
        if (entryList != null) {
            this.table.setItemCount(entryList.getSize());
        } else {
            this.table.setItemCount(0);
        }
        this.updateTableLayout();
    }

    public void refresh() {
        this.executeQuery(this.lastQuery);
    }

    public void updateLabels() {
        this.table.redraw();
        this.table.update();
    }

    public void setColumns(Object[] columnConfigs) {
        this.columnConfigs = columnConfigs;
        this.updateColumns();
    }

    public void updateColumns() {
        int index;
        for (TableColumn column : this.columns) {
            column.dispose();
        }
        this.columns.clear();
        TableColumnLayout tableColumnLayout = new TableColumnLayout();
        this.tableComposite.setLayout((Layout)tableColumnLayout);
        HashSet<Locale> localesToUnload = new HashSet<Locale>(4);
        Locale[] currentLocales = this.getLocales();
        Object[] objectArray = currentLocales;
        int n = currentLocales.length;
        int n2 = 0;
        while (n2 < n) {
            Locale locale = objectArray[n2];
            localesToUnload.add(locale);
            ++n2;
        }
        objectArray = this.columnConfigs;
        n = this.columnConfigs.length;
        n2 = 0;
        while (n2 < n) {
            Object config = objectArray[n2];
            if (config != null) {
                TableViewerColumn viewerColumn = new TableViewerColumn(this.tableViewer, 0);
                TableColumn column = viewerColumn.getColumn();
                if (config == KEY) {
                    column.setText("Key");
                } else {
                    Locale locale = (Locale)config;
                    if (locale.getLanguage().equals("")) {
                        column.setText("Default Bundle");
                    } else {
                        String displayName = locale.getDisplayName();
                        if (displayName.equals("")) {
                            displayName = locale.toString();
                        }
                        column.setText(displayName);
                        localesToUnload.remove(locale);
                    }
                }
                viewerColumn.setLabelProvider((CellLabelProvider)new LocalizationLabelProvider(config));
                tableColumnLayout.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(33));
                this.columns.add(column);
                column.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int size = LocalizationEditor.this.columns.size();
                        int i = 0;
                        while (i < size) {
                            TableColumn column = LocalizationEditor.this.columns.get(i);
                            if (column == e.widget) {
                                Object config;
                                LocalizationEditor.this.sortOrder = config = LocalizationEditor.this.columnConfigs[i];
                                LocalizationEditor.this.table.setSortColumn(column);
                                LocalizationEditor.this.table.setSortDirection(128);
                                LocalizationEditor.this.refresh();
                                break;
                            }
                            ++i;
                        }
                    }
                });
            }
            ++n2;
        }
        List<Object> configs = Arrays.asList(this.columnConfigs);
        if (!configs.contains(this.sortOrder)) {
            this.sortOrder = KEY;
        }
        if ((index = configs.indexOf(this.sortOrder)) != -1) {
            this.table.setSortColumn(this.columns.get(index));
        }
        this.refresh();
    }

    public Object getAdapter(Class adapter) {
        if (IShowInSource.class == adapter) {
            return new IShowInSource(){

                public ShowInContext getShowInContext() {
                    ResourceBundleKey entry = LocalizationEditor.this.getSelectedEntry();
                    if (entry == null) {
                        return null;
                    }
                    ResourceBundle bundle = entry.getParent().getBundle(new Locale(""));
                    if (bundle == null) {
                        return null;
                    }
                    Object resource = bundle.getUnderlyingResource();
                    return new ShowInContext(resource, (ISelection)new StructuredSelection(resource));
                }
            };
        }
        return super.getAdapter(adapter);
    }

    public Locale[] getLocales() {
        ArrayList<Locale> locales = new ArrayList<Locale>(this.columnConfigs.length);
        Object[] objectArray = this.columnConfigs;
        int n = this.columnConfigs.length;
        int n2 = 0;
        while (n2 < n) {
            Object config = objectArray[n2];
            if (config instanceof Locale) {
                Locale locale = (Locale)config;
                locales.add(locale);
            }
            ++n2;
        }
        return locales.toArray(new Locale[locales.size()]);
    }

    private class BundleStringComparator
    implements Comparator<ResourceBundleKey> {
        private final Locale locale;

        public BundleStringComparator(Locale locale) {
            this.locale = locale;
        }

        @Override
        public int compare(ResourceBundleKey o1, ResourceBundleKey o2) {
            String value1 = null;
            String value2 = null;
            try {
                value1 = o1.getValue(this.locale);
            }
            catch (CoreException e) {
                MessagesEditorPlugin.log(e);
            }
            try {
                value2 = o2.getValue(this.locale);
            }
            catch (CoreException e) {
                MessagesEditorPlugin.log(e);
            }
            if (value1 == null) {
                value1 = "";
            }
            if (value2 == null) {
                value2 = "";
            }
            return value1.compareToIgnoreCase(value2);
        }
    }

    private class ConfigureColumnsAction
    extends Action {
        public ConfigureColumnsAction() {
            super(null, 1);
            this.setImageDescriptor(MessagesEditorPlugin.getImageDescriptor("elcl16/conf_columns.gif"));
            this.setToolTipText("Configure Columns");
        }

        public void run() {
            Shell shell = Display.getCurrent().getActiveShell();
            String[] values = new String[LocalizationEditor.this.columnConfigs.length];
            int i = 0;
            while (i < LocalizationEditor.this.columnConfigs.length) {
                String config = LocalizationEditor.this.columnConfigs[i].toString();
                if (config.equals("")) {
                    config = "default";
                }
                values[i] = config;
                ++i;
            }
            ConfigureColumnsDialog dialog = new ConfigureColumnsDialog(shell, values);
            if (dialog.open() == 0) {
                String[] result = dialog.getResult();
                Object[] newConfigs = new Object[result.length];
                int i2 = 0;
                while (i2 < newConfigs.length) {
                    newConfigs[i2] = result[i2].equals("key") ? KEY : (result[i2].equals("default") ? new Locale("") : LocaleUtil.parseLocale(result[i2]));
                    ++i2;
                }
                LocalizationEditor.this.setColumns(newConfigs);
            }
        }
    }

    private class EditEntryAction
    extends Action {
        public EditEntryAction() {
            super("&Edit", 1);
        }

        public void run() {
            ResourceBundleKey key = LocalizationEditor.this.getSelectedEntry();
            if (key == null) {
                return;
            }
            Shell shell = Display.getCurrent().getActiveShell();
            Locale[] locales = LocalizationEditor.this.getLocales();
            EditResourceBundleEntriesDialog dialog = new EditResourceBundleEntriesDialog(shell, locales);
            dialog.setResourceBundleKey(key);
            if (dialog.open() == 0) {
                LocalizationEditor.this.updateLabels();
            }
        }
    }

    private class EditFilterOptionsAction
    extends Action {
        public EditFilterOptionsAction() {
            super(null, 1);
            this.setImageDescriptor(MessagesEditorPlugin.getImageDescriptor("elcl16/filter_obj.gif"));
            this.setToolTipText("Edit Filter Options");
        }

        public void run() {
            Shell shell = Display.getCurrent().getActiveShell();
            FilterOptionsDialog dialog = new FilterOptionsDialog(shell);
            dialog.setInitialFilterOptions(LocalizationEditor.this.filterOptions);
            if (dialog.open() == 0) {
                LocalizationEditor.this.filterOptions = dialog.getResult();
                LocalizationEditor.this.refresh();
                LocalizationEditor.this.updateFilterLabel();
            }
        }
    }

    private class ExportAction
    extends Action {
        public ExportAction() {
            super(null, 1);
            this.setImageDescriptor(MessagesEditorPlugin.getImageDescriptor("elcl16/export.gif"));
            this.setToolTipText("Export Current View to CSV or HTML File");
        }

        public void run() {
            Shell shell = Display.getCurrent().getActiveShell();
            FileDialog dialog = new FileDialog(shell);
            dialog.setText("Export File");
            dialog.setFilterExtensions(new String[]{"*.*", "*.htm; *.html", "*.txt; *.csv"});
            dialog.setFilterNames(new String[]{"All Files (*.*)", "HTML File (*.htm; *.html)", "Tabulator Separated File (*.txt; *.csv)"});
            final String filename = dialog.open();
            if (filename != null) {
                BusyIndicator.showWhile((Display)Display.getCurrent(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        File file = new File(filename);
                        try {
                            boolean isHtml;
                            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF8"));
                            boolean bl = isHtml = filename.endsWith(".htm") || filename.endsWith(".html");
                            if (isHtml) {
                                writer.write("<html>\r\n<head>\r\n<meta http-equiv=Content-Type content=\"text/html; charset=UTF-8\">\r\n<style>\r\ntable {width:100%;}\r\ntd.sep {height:10px;background:#C0C0C0;}\r\n</style>\r\n</head>\r\n<body>\r\n<table width=\"100%\" border=\"1\">\r\n");
                            }
                            int size = ((ExportAction)ExportAction.this).LocalizationEditor.this.entryList.getSize();
                            Object[] configs = ((ExportAction)ExportAction.this).LocalizationEditor.this.columnConfigs;
                            int valueCount = 0;
                            int missingCount = 0;
                            int i = 0;
                            while (i < size) {
                                ResourceBundleKey key = ((ExportAction)ExportAction.this).LocalizationEditor.this.entryList.getKey(i);
                                if (isHtml) {
                                    writer.write("<table border=\"1\">\r\n");
                                }
                                int j = 0;
                                while (j < configs.length) {
                                    if (isHtml) {
                                        writer.write("<tr><td>");
                                    }
                                    Object config = configs[j];
                                    if (!isHtml && j > 0) {
                                        writer.write("\t");
                                    }
                                    if (config == KEY) {
                                        writer.write(key.getName());
                                    } else {
                                        String value;
                                        Locale locale = (Locale)config;
                                        try {
                                            value = key.getValue(locale);
                                        }
                                        catch (CoreException e) {
                                            value = null;
                                            MessagesEditorPlugin.log(e);
                                        }
                                        if (value == null) {
                                            value = "";
                                            ++missingCount;
                                        } else {
                                            ++valueCount;
                                        }
                                        writer.write(EditResourceBundleEntriesDialog.escape(value));
                                    }
                                    if (isHtml) {
                                        writer.write("</td></tr>\r\n");
                                    }
                                    ++j;
                                }
                                if (isHtml) {
                                    writer.write("<tr><td class=\"sep\">&nbsp;</td></tr>\r\n");
                                    writer.write("</table>\r\n");
                                } else {
                                    writer.write("\r\n");
                                }
                                ++i;
                            }
                            if (isHtml) {
                                writer.write("</body>\r\n</html>\r\n");
                            }
                            writer.close();
                            Shell shell = Display.getCurrent().getActiveShell();
                            MessageDialog.openInformation((Shell)shell, (String)"Finished", (String)("File written successfully.\n\nNumber of entries written: " + ((ExportAction)ExportAction.this).LocalizationEditor.this.entryList.getSize() + "\nNumber of translations: " + valueCount + " (" + missingCount + " missing)"));
                        }
                        catch (IOException e) {
                            Shell shell = Display.getCurrent().getActiveShell();
                            ErrorDialog.openError((Shell)shell, (String)"Error", (String)"Error saving file.", (IStatus)new Status(4, "com.jaspersoft.studio.babel.editor", e.getMessage(), (Throwable)e));
                        }
                    }
                });
            }
        }
    }

    private final class LocalizationLabelProvider
    extends ColumnLabelProvider {
        private final Object columnConfig;

        public LocalizationLabelProvider(Object columnConfig) {
            this.columnConfig = columnConfig;
        }

        public String getText(Object element) {
            String value;
            ResourceBundleKey key = (ResourceBundleKey)element;
            if (this.columnConfig == KEY) {
                return key.getName();
            }
            Locale locale = (Locale)this.columnConfig;
            try {
                value = key.getValue(locale);
            }
            catch (CoreException e) {
                value = null;
                MessagesEditorPlugin.log(e);
            }
            if (value == null) {
                value = "";
            }
            return value;
        }
    }

    private class RefreshAction
    extends Action {
        public RefreshAction() {
            super(null, 1);
            this.setImageDescriptor(MessagesEditorPlugin.getImageDescriptor("elcl16/refresh.gif"));
            this.setToolTipText("Refresh");
        }

        public void run() {
            MessagesEditorPlugin.disposeModel();
            LocalizationEditor.this.entryList = new ResourceBundleKeyList(new ResourceBundleKey[0]);
            LocalizationEditor.this.tableViewer.getTable().setItemCount(0);
            LocalizationEditor.this.updateLabels();
            LocalizationEditor.this.refresh();
        }
    }
}

