/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.babel.editor.plugin.MessagesEditorPlugin;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleElement;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleFamily;

public class ResourceBundle
extends ResourceBundleElement {
    private static boolean debug = false;
    private Locale locale;
    private Object resource;
    private HashMap<String, String> entries;

    public ResourceBundle(ResourceBundleFamily parent, Object resource, Locale locale) {
        super(parent);
        this.resource = resource;
        this.locale = locale;
        if (locale == null) {
            throw new IllegalArgumentException("Locale may not be null.");
        }
    }

    public ResourceBundleFamily getFamily() {
        return (ResourceBundleFamily)super.getParent();
    }

    public Locale getLocale() {
        return this.locale;
    }

    public String getString(String key) throws CoreException {
        this.load();
        return this.entries.get(key);
    }

    public Object getUnderlyingResource() {
        return this.resource;
    }

    protected boolean isLoaded() {
        return this.entries != null;
    }

    public void load() throws CoreException {
        if (this.isLoaded()) {
            return;
        }
        this.entries = new HashMap();
        if (this.resource instanceof IFile) {
            if (debug) {
                System.out.println("Loading " + this.resource + "...");
            }
            IFile file = (IFile)this.resource;
            InputStream inputStream = file.getContents();
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                this.putAll(properties);
            }
            catch (IOException e) {
                MessagesEditorPlugin.log("Error reading property file.", e);
            }
        } else if (this.resource instanceof IJarEntryResource) {
            IJarEntryResource jarEntryResource = (IJarEntryResource)this.resource;
            InputStream inputStream = jarEntryResource.getContents();
            Properties properties = new Properties();
            try {
                properties.load(inputStream);
                this.putAll(properties);
            }
            catch (IOException e) {
                MessagesEditorPlugin.log("Error reading property file.", e);
            }
        } else {
            MessagesEditorPlugin.log("Unknown resource type.", new RuntimeException());
        }
    }

    protected void unload() {
        this.entries = null;
    }

    public boolean isReadOnly() {
        if (this.resource instanceof IJarEntryResource) {
            return true;
        }
        if (this.resource instanceof IFile) {
            IFile file = (IFile)this.resource;
            return file.isReadOnly() || file.isLinked();
        }
        return false;
    }

    protected void putAll(Properties properties) throws CoreException {
        Set<Map.Entry<Object, Object>> entrySet = properties.entrySet();
        Iterator<Map.Entry<Object, Object>> iter = entrySet.iterator();
        ResourceBundleFamily family = this.getFamily();
        while (iter.hasNext()) {
            Map.Entry<Object, Object> next = iter.next();
            Object key = next.getKey();
            Object value = next.getValue();
            if (!(key instanceof String) || !(value instanceof String)) continue;
            String stringKey = (String)key;
            this.entries.put(stringKey, (String)value);
            family.addKey(stringKey);
        }
    }

    public void put(String key, String value) throws CoreException {
        this.load();
        ResourceBundleFamily family = this.getFamily();
        this.entries.put(key, value);
        family.addKey(key);
    }

    public String[] getKeys() throws CoreException {
        this.load();
        Set<String> keySet = this.entries.keySet();
        return keySet.toArray(new String[keySet.size()]);
    }
}

