/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.nls.internal.ui.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundle;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleElement;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleKey;
import org.eclipse.pde.nls.internal.ui.model.ResourceBundleModel;

public class ResourceBundleFamily
extends ResourceBundleElement {
    private String projectName;
    private String pluginId;
    private String packageName;
    private String baseName;
    private ArrayList<ResourceBundle> members = new ArrayList();
    private HashMap<String, ResourceBundleKey> keys = new HashMap();

    public ResourceBundleFamily(ResourceBundleModel parent, String projectName, String pluginId, String packageName, String baseName) {
        super(parent);
        this.projectName = projectName;
        this.pluginId = pluginId;
        this.packageName = packageName;
        this.baseName = baseName;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public ResourceBundle[] getBundles() {
        return this.members.toArray(new ResourceBundle[this.members.size()]);
    }

    public ResourceBundle getBundle(Locale locale) {
        for (ResourceBundle bundle : this.members) {
            if (!bundle.getLocale().equals(locale)) continue;
            return bundle;
        }
        return null;
    }

    public int hashCode() {
        if (this.pluginId != null) {
            return this.baseName.hashCode() ^ this.pluginId.hashCode();
        }
        return this.baseName.hashCode() ^ this.projectName.hashCode();
    }

    protected void addBundle(ResourceBundle bundle) throws CoreException {
        Assert.isTrue((bundle.getParent() == this ? 1 : 0) != 0);
        this.members.add(bundle);
    }

    protected void addKey(String key) {
        if (this.keys.get(key) == null) {
            this.keys.put(key, new ResourceBundleKey(this, key));
        }
    }

    public ResourceBundleKey[] getKeys() {
        Collection<ResourceBundleKey> values = this.keys.values();
        return values.toArray(new ResourceBundleKey[values.size()]);
    }

    public int getKeyCount() {
        return this.keys.size();
    }

    public String toString() {
        return "projectName=" + this.projectName + ", packageName=" + this.packageName + ", baseName=" + this.baseName;
    }
}

