/*
 * Decompiled with CFR 0.152.
 */
package com.collabnet.subversion.merge.actions;

import com.collabnet.subversion.merge.wizards.CustomWizardDialog;
import com.collabnet.subversion.merge.wizards.MergeWizard;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.tigris.subversion.subclipse.core.ISVNLocalResource;
import org.tigris.subversion.subclipse.core.ISVNRepositoryLocation;
import org.tigris.subversion.subclipse.core.resources.LocalResourceStatus;
import org.tigris.subversion.subclipse.core.resources.SVNWorkspaceRoot;
import org.tigris.subversion.subclipse.ui.actions.WorkbenchWindowAction;

public class MergeAction
extends WorkbenchWindowAction {
    protected void execute(IAction action) throws InvocationTargetException, InterruptedException {
        if (action != null && !action.isEnabled()) {
            action.setEnabled(true);
        } else {
            IResource[] resources = this.getSelectedResources();
            MergeWizard wizard = new MergeWizard(resources, this.getTargetPart());
            CustomWizardDialog dialog = new CustomWizardDialog(this.shell, (IWizard)wizard);
            dialog.open();
        }
    }

    protected boolean isEnabledForManagedResources() {
        return true;
    }

    protected boolean isEnabledForUnmanagedResources() {
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean isEnabledForMultipleResources() {
        try {
            ISVNRepositoryLocation repository = null;
            IResource[] selectedResources = this.getSelectedResources();
            int i = 0;
            while (true) {
                if (i >= selectedResources.length) {
                    return true;
                }
                ISVNRepositoryLocation compareToRepository = null;
                ISVNLocalResource svnResource = SVNWorkspaceRoot.getSVNResourceFor((IResource)selectedResources[i]);
                if (svnResource == null) return false;
                if (!svnResource.isManaged()) {
                    return false;
                }
                LocalResourceStatus status = svnResource.getStatusFromCache();
                if (status != null) {
                    compareToRepository = status.getRepository();
                }
                if (compareToRepository == null) {
                    return false;
                }
                if (repository != null && !compareToRepository.equals(repository)) {
                    return false;
                }
                repository = compareToRepository;
                ++i;
            }
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected String getImageId() {
        return "Menu Merge";
    }
}

