/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ws.examples;

import com.jaspersoft.ireport.jasperserver.ws.JServer;
import com.jaspersoft.ireport.jasperserver.ws.WSClient;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;

public class CreateReportUnit {
    public static void main(String[] args) throws Exception {
        JServer server = new JServer();
        server.setUrl("http://127.0.0.1:8080/jasperserver-pro/services/repository");
        server.setUsername("jasperadmin|organization_1");
        server.setPassword("jasperadmin");
        WSClient client = new WSClient(server);
        CreateReportUnit.createFolder(client, "My Sample Folder", "MY_FOLDER");
        CreateReportUnit.createReportUnit(client, "/MY_FOLDER", "MY_REPORT", "My Sample Report", "c:\\test.jrxml");
        CreateReportUnit.addReportResource(client, "/MY_FOLDER/MY_REPORT", "logo.gif", "c:\\logo.gif");
        CreateReportUnit.addReportInputControl(client, "/MY_FOLDER/MY_REPORT", "parameter1", "Accounts starting with");
    }

    public static void createFolder(WSClient client, String folderLabel, String folderName) throws IOException {
        System.out.println("\n\n-----------" + folderName + " --------------");
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setWsType("folder");
        rd.setUriString("/" + folderName);
        rd.setName(folderName);
        rd.setLabel(folderLabel);
        rd.setIsNew(true);
        try {
            client.addOrModifyResource(rd, null);
            System.out.println("Folder /" + folderName + " created");
        }
        catch (Exception ex) {
            System.out.println("Creation of folder /" + folderName + " failed: " + ex.getMessage());
        }
    }

    private static void createReportUnit(WSClient client, String folder, String name, String label, String jrxmlFile) throws Exception {
        String cfr_ignored_0 = String.valueOf(folder) + "/" + name;
        ResourceDescriptor rd = new ResourceDescriptor();
        rd.setName(name);
        rd.setLabel(label);
        rd.setWsType("reportUnit");
        rd.setUriString(String.valueOf(folder) + "/" + name);
        rd.setParentFolder(folder);
        rd.setIsNew(true);
        rd.setResourceProperty("PROP_RU_ALWAYS_PROPMT_CONTROLS", true);
        ResourceDescriptor datasource = new ResourceDescriptor();
        datasource.setIsNew(true);
        datasource.setWsType("datasource");
        datasource.setIsReference(true);
        datasource.setReferenceUri("/datasources/JServerJdbcDS");
        rd.getChildren().add(datasource);
        ResourceDescriptor jrxmlDescriptor = new ResourceDescriptor();
        jrxmlDescriptor.setName("main_jrxml");
        jrxmlDescriptor.setLabel("Main Jrxml");
        jrxmlDescriptor.setWsType("jrxml");
        jrxmlDescriptor.setIsNew(true);
        jrxmlDescriptor.setMainReport(true);
        jrxmlDescriptor.setIsReference(false);
        jrxmlDescriptor.setHasData(true);
        rd.getChildren().add(jrxmlDescriptor);
        client.addOrModifyResource(rd, new File(jrxmlFile));
        System.out.println("  Created report " + label);
        System.out.flush();
    }

    private static void addReportResource(WSClient client, String reportUnitUri, String name, String imageFile) throws Exception {
        ResourceDescriptor resourceDescriptor = new ResourceDescriptor();
        resourceDescriptor.setWsType("img");
        resourceDescriptor.setName(name);
        resourceDescriptor.setLabel(name);
        resourceDescriptor.setIsNew(true);
        resourceDescriptor.setHasData(true);
        resourceDescriptor.setUriString(String.valueOf(reportUnitUri) + "/" + name);
        client.modifyReportUnitResource(reportUnitUri, resourceDescriptor, new File(imageFile));
        System.out.println("  Image " + name + " added to the report");
        System.out.flush();
    }

    private static void addReportInputControl(WSClient client, String reportUnitUri, String name, String label) throws Exception {
        ResourceDescriptor icDescriptor = new ResourceDescriptor();
        icDescriptor.setName(name);
        icDescriptor.setLabel(label);
        icDescriptor.setIsNew(true);
        icDescriptor.setIsReference(false);
        icDescriptor.setWsType("inputControl");
        icDescriptor.setResourceProperty("PROP_INPUTCONTROL_TYPE", 2);
        icDescriptor.setUriString(String.valueOf(reportUnitUri) + "/<controls>/" + name);
        ResourceDescriptor dataTypeDescriptor = new ResourceDescriptor();
        dataTypeDescriptor.setName("myDatatype");
        dataTypeDescriptor.setLabel("Simple text data type");
        dataTypeDescriptor.setIsNew(true);
        dataTypeDescriptor.setIsReference(false);
        dataTypeDescriptor.setWsType("dataType");
        dataTypeDescriptor.setDataType((byte)1);
        dataTypeDescriptor.setUriString(String.valueOf(reportUnitUri) + "/<controls>/" + name + "/myDatatype");
        if (icDescriptor.getChildren() == null) {
            icDescriptor.setChildren(new ArrayList());
        }
        icDescriptor.getChildren().add(dataTypeDescriptor);
        client.modifyReportUnitResource(reportUnitUri, icDescriptor, null);
        System.out.println("  Input control " + name + " added to the report");
        System.out.flush();
    }
}

