/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ws.http;

import com.jaspersoft.studio.server.protocol.JSSTrustStrategy;
import com.jaspersoft.studio.server.protocol.restv2.CertChainValidator;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URL;
import java.security.KeyStore;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.HttpUtils;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.handlers.BasicHandler;
import org.apache.axis.soap.SOAPConstants;
import org.apache.axis.transport.http.CommonsHTTPSender;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.utils.Messages;
import org.apache.axis.utils.NetworkUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.HttpClient;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.fluent.Executor;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.BrowserCompatHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContextBuilder;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.LaxRedirectStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;

public class JSSCommonsHTTPSender
extends BasicHandler {
    private static final long serialVersionUID = 8881188152022966420L;
    protected static Log log = LogFactory.getLog((String)CommonsHTTPSender.class.getName());
    private Executor exec;
    private URL targetURL;

    public void invoke(final MessageContext msgContext) throws AxisFault {
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"enter00", (String)"CommonsHTTPSender::invoke"));
        }
        Request req = null;
        Response response = null;
        try {
            String webMethod;
            if (this.exec == null) {
                int domainIndex;
                this.targetURL = new URL(msgContext.getStrProp("transport.url"));
                String userID = msgContext.getUsername();
                String passwd = msgContext.getPassword();
                if (userID == null && this.targetURL.getUserInfo() != null) {
                    String info = this.targetURL.getUserInfo();
                    int sep = info.indexOf(58);
                    if (sep >= 0 && sep + 1 < info.length()) {
                        userID = info.substring(0, sep);
                        passwd = info.substring(sep + 1);
                    } else {
                        userID = info;
                    }
                }
                UsernamePasswordCredentials cred = new UsernamePasswordCredentials(userID, passwd);
                if (userID != null && (domainIndex = userID.indexOf("\\")) > 0) {
                    String domain = userID.substring(0, domainIndex);
                    if (userID.length() > domainIndex + 1) {
                        String user = userID.substring(domainIndex + 1);
                        cred = new NTCredentials(user, passwd, NetworkUtils.getLocalHostname(), domain);
                    }
                }
                SSLContextBuilder builder = SSLContexts.custom();
                KeyStore trustStore = CertChainValidator.getDefaultTrustStore();
                builder.loadTrustMaterial(trustStore, (TrustStrategy)new JSSTrustStrategy(trustStore));
                SSLContext sslContext = builder.build();
                SSLConnectionSocketFactory sslsf = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new BrowserCompatHostnameVerifier()){

                    protected void prepareSocket(SSLSocket socket) throws IOException {
                        super.prepareSocket(socket);
                        socket.setEnabledProtocols(new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"});
                    }
                };
                CloseableHttpClient httpClient = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)sslsf).setRedirectStrategy((RedirectStrategy)new LaxRedirectStrategy(){

                    public HttpUriRequest getRedirect(HttpRequest request, HttpResponse response, HttpContext context) throws ProtocolException {
                        URI uri = this.getLocationURI(request, response, context);
                        String method = request.getRequestLine().getMethod();
                        if (method.equalsIgnoreCase("HEAD")) {
                            return new HttpHead(uri);
                        }
                        if (method.equalsIgnoreCase("POST")) {
                            HttpPost httpPost = new HttpPost(uri);
                            httpPost.addHeader(request.getFirstHeader("Authorization"));
                            httpPost.addHeader(request.getFirstHeader("SOAPAction"));
                            httpPost.addHeader(request.getFirstHeader("Content-Type"));
                            httpPost.addHeader(request.getFirstHeader("User-Agent"));
                            httpPost.addHeader(request.getFirstHeader("SOAPAction"));
                            if (request instanceof HttpEntityEnclosingRequest) {
                                httpPost.setEntity(((HttpEntityEnclosingRequest)request).getEntity());
                            }
                            return httpPost;
                        }
                        if (method.equalsIgnoreCase("GET")) {
                            return new HttpGet(uri);
                        }
                        throw new IllegalStateException("Redirect called on un-redirectable http method: " + method);
                    }
                }).build();
                this.exec = Executor.newInstance((HttpClient)httpClient);
                HttpHost host = new HttpHost(this.targetURL.getHost(), this.targetURL.getPort(), this.targetURL.getProtocol());
                this.exec.auth(host, (Credentials)cred);
                this.exec.authPreemptive(host);
                HttpUtils.setupProxy((Executor)this.exec, (URI)this.targetURL.toURI());
            }
            boolean posting = true;
            if (msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS && (webMethod = msgContext.getStrProp("soap12.webmethod")) != null) {
                posting = webMethod.equals("POST");
            }
            HttpHost proxy = HttpUtils.getUnauthProxy((Executor)this.exec, (URI)this.targetURL.toURI());
            if (posting) {
                req = Request.Post((String)this.targetURL.toString());
                if (proxy != null) {
                    req.viaProxy(proxy);
                }
                Message reqMessage = msgContext.getRequestMessage();
                this.addContextInfo(req, msgContext, this.targetURL);
                Iterator it = reqMessage.getAttachments();
                if (it.hasNext()) {
                    ByteArrayOutputStream bos = null;
                    try {
                        bos = new ByteArrayOutputStream();
                        reqMessage.writeTo((OutputStream)bos);
                        req.body((HttpEntity)new ByteArrayEntity(bos.toByteArray()));
                    }
                    finally {
                        FileUtils.closeStream((Closeable)bos);
                    }
                } else {
                    req.body((HttpEntity)new StringEntity(reqMessage.getSOAPPartAsString()));
                }
            } else {
                req = Request.Get((String)this.targetURL.toString());
                if (proxy != null) {
                    req.viaProxy(proxy);
                }
                this.addContextInfo(req, msgContext, this.targetURL);
            }
            response = this.exec.execute(req);
            response.handleResponse((ResponseHandler)new ResponseHandler<String>(){

                public String handleResponse(HttpResponse response) throws IOException {
                    HttpEntity en = response.getEntity();
                    InputStream in = null;
                    try {
                        StatusLine statusLine = response.getStatusLine();
                        int returnCode = statusLine.getStatusCode();
                        String contentType = en.getContentType() != null ? en.getContentType().getValue() : null;
                        in = new BufferedHttpEntity(en).getContent();
                        if (!(returnCode > 199 && returnCode < 300 || msgContext.getSOAPConstants() == SOAPConstants.SOAP12_CONSTANTS || contentType != null && !contentType.equals("text/html") && returnCode > 499 && returnCode < 600)) {
                            String statusMessage = statusLine.getReasonPhrase();
                            AxisFault fault = new AxisFault("HTTP", "(" + returnCode + ")" + statusMessage, null, null);
                            fault.setFaultDetailString(Messages.getMessage((String)"return01", (String)("" + returnCode), (String)IOUtils.toString((InputStream)in)));
                            fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_HTTPERRORCODE, Integer.toString(returnCode));
                            throw fault;
                        }
                        Header contentEncoding = response.getFirstHeader("Content-Encoding");
                        if (contentEncoding != null) {
                            if (contentEncoding.getValue().equalsIgnoreCase("gzip")) {
                                in = new GZIPInputStream(in);
                            } else {
                                AxisFault fault = new AxisFault("HTTP", "unsupported content-encoding of '" + contentEncoding.getValue() + "' found", null, null);
                                throw fault;
                            }
                        }
                        MimeHeaders mh = new MimeHeaders();
                        Header[] headerArray = response.getAllHeaders();
                        int n = headerArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Header h = headerArray[n2];
                            mh.addHeader(h.getName(), h.getValue());
                            ++n2;
                        }
                        Message outMsg = new Message((Object)in, false, mh);
                        outMsg.setMessageType("response");
                        msgContext.setResponseMessage(outMsg);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)("\n" + Messages.getMessage((String)"xmlRecd00")));
                            log.debug((Object)"-----------------------------------------------");
                            log.debug((Object)outMsg.getSOAPPartAsString());
                        }
                    }
                    catch (Throwable throwable) {
                        FileUtils.closeStream(in);
                        throw throwable;
                    }
                    FileUtils.closeStream((Closeable)in);
                    return "";
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
            log.debug((Object)e);
            throw AxisFault.makeFault((Exception)e);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)Messages.getMessage((String)"exit00", (String)"CommonsHTTPSender::invoke"));
        }
    }

    private void addContextInfo(Request req, MessageContext msgContext, URL tmpURL) throws Exception {
        Hashtable userHeaderTable;
        MimeHeaders mimeHeaders;
        Message msg;
        String action;
        String v = msgContext.getStrProp("axis.transport.version");
        if (v != null && v.equals(HTTPConstants.HEADER_PROTOCOL_V10)) {
            req.version(HttpVersion.HTTP_1_0);
        }
        if (msgContext.getTimeout() != 0) {
            req.connectTimeout(msgContext.getTimeout());
            req.socketTimeout(msgContext.getTimeout());
        }
        String string = action = msgContext.useSOAPAction() ? msgContext.getSOAPActionURI() : "";
        if (action == null) {
            action = "";
        }
        if ((msg = msgContext.getRequestMessage()) != null) {
            req.addHeader("Content-Type", msg.getContentType(msgContext.getSOAPConstants()));
        }
        req.addHeader("SOAPAction", "\"" + action + "\"");
        req.addHeader("User-Agent", HttpUtils.USER_AGENT_JASPERSOFT_STUDIO);
        if (msgContext.isPropertyTrue("transport.http.acceptGzip")) {
            req.addHeader("Accept-Encoding", "gzip");
        }
        if (msgContext.isPropertyTrue("transport.http.gzipRequest")) {
            req.addHeader("Content-Encoding", "gzip");
        }
        if ((mimeHeaders = msg.getMimeHeaders()) != null) {
            Iterator i = mimeHeaders.getAllHeaders();
            while (i.hasNext()) {
                MimeHeader mimeHeader = (MimeHeader)i.next();
                String headerName = mimeHeader.getName();
                if (headerName.equals("Content-Type") || headerName.equals("SOAPAction")) continue;
                req.addHeader(mimeHeader.getName(), mimeHeader.getValue());
            }
        }
        if ((userHeaderTable = (Hashtable)msgContext.getProperty("HTTP-Request-Headers")) != null) {
            for (Map.Entry me : userHeaderTable.entrySet()) {
                Object keyObj = me.getKey();
                if (keyObj == null) continue;
                String key = keyObj.toString().trim();
                String value = me.getValue().toString().trim();
                if (key.equalsIgnoreCase("Expect") && value.equalsIgnoreCase("100-continue")) {
                    req.useExpectContinue();
                    continue;
                }
                if (key.equalsIgnoreCase(HTTPConstants.HEADER_TRANSFER_ENCODING_CHUNKED)) {
                    req.removeHeader((Header)new BasicHeader("Transfer-Encoding", "chunked"));
                    if (!Boolean.parseBoolean(value)) continue;
                    continue;
                }
                req.addHeader(key, value);
            }
        }
    }
}

