/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.server.protocol.soap;

import com.jaspersoft.ireport.jasperserver.ws.JServer;
import com.jaspersoft.ireport.jasperserver.ws.WSClient;
import com.jaspersoft.ireport.jasperserver.ws.WSRole;
import com.jaspersoft.ireport.jasperserver.ws.WSUser;
import com.jaspersoft.ireport.jasperserver.ws.permissions.WSObjectPermission;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.Argument;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ListItem;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import com.jaspersoft.jasperserver.dto.authority.ClientUser;
import com.jaspersoft.jasperserver.dto.jdbcdrivers.JdbcDriverInfo;
import com.jaspersoft.jasperserver.dto.permissions.RepositoryPermission;
import com.jaspersoft.jasperserver.dto.resources.ClientResource;
import com.jaspersoft.jasperserver.dto.serverinfo.ServerInfo;
import com.jaspersoft.jasperserver.jaxrs.client.dto.importexport.StateDto;
import com.jaspersoft.studio.server.AFinderUI;
import com.jaspersoft.studio.server.WSClientHelper;
import com.jaspersoft.studio.server.editor.input.InputControlsManager;
import com.jaspersoft.studio.server.model.datasource.filter.DatasourcesAllFilter;
import com.jaspersoft.studio.server.model.datasource.filter.IDatasourceFilter;
import com.jaspersoft.studio.server.model.server.ServerProfile;
import com.jaspersoft.studio.server.protocol.Feature;
import com.jaspersoft.studio.server.protocol.IConnection;
import com.jaspersoft.studio.server.protocol.JdbcDriver;
import com.jaspersoft.studio.server.protocol.ReportExecution;
import com.jaspersoft.studio.server.protocol.soap.Messages;
import com.jaspersoft.studio.server.publish.PublishUtil;
import com.jaspersoft.studio.server.utils.Pass;
import com.jaspersoft.studio.server.wizard.exp.ExportOptions;
import com.jaspersoft.studio.server.wizard.imp.ImportOptions;
import com.jaspersoft.studio.server.wizard.permission.PermissionOptions;
import com.jaspersoft.studio.server.wizard.resource.page.selector.SelectorDatasource;
import java.io.File;
import java.io.IOException;
import java.text.DateFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.apache.axis.AxisProperties;
import org.apache.commons.codec.binary.Base64;
import org.eclipse.core.runtime.IProgressMonitor;

public class SoapConnection
implements IConnection {
    protected DateFormat dateFormat = SimpleDateFormat.getDateInstance();
    protected DateFormat timestampFormat = SimpleDateFormat.getDateTimeInstance();
    protected DateFormat timeFormat = new SimpleDateFormat("h:mm:ss");
    protected NumberFormat numberFormat = NumberFormat.getInstance();
    private ServerProfile sp;
    private WSClient client;
    private ServerInfo serverInfo;
    private static Set<String> wstypes = new HashSet<String>();
    private IConnection parent;

    static {
        wstypes.add("css");
        wstypes.add("json");
    }

    public ServerProfile getServerProfile() {
        return this.sp;
    }

    public Format getDateFormat() {
        return this.dateFormat;
    }

    public Format getTimestampFormat() {
        return this.timestampFormat;
    }

    public Format getTimeFormat() {
        return this.timeFormat;
    }

    public Format getNumberFormat() {
        return this.numberFormat;
    }

    public ServerInfo getServerInfo() {
        return this.parent.getServerInfo();
    }

    public ServerInfo getServerInfo(IProgressMonitor monitor) throws Exception {
        if (this.serverInfo != null) {
            return this.serverInfo;
        }
        String v = this.client.getVersion();
        this.serverInfo = this.getServerInfo();
        if (this.serverInfo == null) {
            this.serverInfo = new ServerInfo();
            this.serverInfo.setVersion(v);
            this.serverInfo.setDateFormatPattern(((SimpleDateFormat)this.getDateFormat()).toPattern());
            this.serverInfo.setDatetimeFormatPattern(((SimpleDateFormat)this.getTimestampFormat()).toPattern());
        }
        return this.serverInfo;
    }

    public boolean connect(IProgressMonitor monitor, ServerProfile sp) throws Exception {
        monitor.subTask(Messages.SoapConnection_1);
        JServer server = new JServer();
        this.sp = sp;
        if (this.setupJServer(server, sp, monitor)) {
            if (sp.isLogging()) {
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
                System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.conn", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.client", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.client", "debug");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "debug");
            } else {
                System.setProperty("org.apache.commons.logging.Log", "org.apache.commons.logging.impl.SimpleLog");
                System.setProperty("org.apache.commons.logging.simplelog.showdatetime", "true");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.wire", "ERROR");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.conn", "ERROR");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.impl.client", "ERROR");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http.client", "ERROR");
                System.setProperty("org.apache.commons.logging.simplelog.log.org.apache.http", "ERROR");
            }
            if (monitor.isCanceled()) {
                return false;
            }
            this.client = server.getWSClient();
            return this.getServerInfo(monitor) != null;
        }
        return false;
    }

    private boolean setupJServer(JServer server, ServerProfile sp, IProgressMonitor monitor) throws Exception {
        AxisProperties.setProperty((String)"axis.http.client.maximum.connections.per.host", (String)"4");
        server.setName(sp.getName());
        String rurl = sp.getUrl();
        if (rurl.endsWith("services/repository/")) {
            rurl = rurl.substring(0, rurl.length() - 1);
        }
        if (!rurl.endsWith("services/repository")) {
            rurl = String.valueOf(rurl) + "services/repository";
        }
        server.setUrl(rurl);
        String username = sp.getUser();
        if (sp.getOrganisation() != null && !sp.getOrganisation().trim().isEmpty()) {
            username = String.valueOf(username) + "|" + sp.getOrganisation();
        }
        server.setUsername(username);
        server.setPassword(this.parent.getPassword(monitor));
        server.setTimeout(sp.getTimeout());
        server.setChunked(sp.isChunked());
        server.setMime(sp.isMime());
        return true;
    }

    public ResourceDescriptor get(IProgressMonitor monitor, ResourceDescriptor rd, File f) throws Exception {
        try {
            if (rd.getUriString() == null || rd.getUriString().contains("<")) {
                throw new Exception(Messages.SoapConnection_0);
            }
            rd = this.client.get(rd, f);
            this.sortReportUnit(rd, rd.getChildren());
        }
        catch (Exception e) {
            if (wstypes.contains(rd.getWsType())) {
                throw new Exception(String.format(Messages.SoapConnection_37, rd.getWsType()), e);
            }
            throw e;
        }
        return rd;
    }

    protected void sortReportUnit(ResourceDescriptor rd, List<ResourceDescriptor> children) {
        if (rd.getWsType().equals("reportUnit") || rd.getWsType().equals("adhocDataView") || rd.getWsType().equals("domainTopic") || rd.getWsType().equals("reportOptions")) {
            Collections.sort(children, new Comparator<ResourceDescriptor>(){

                @Override
                public int compare(ResourceDescriptor arg0, ResourceDescriptor arg1) {
                    String wsType1;
                    if (arg0.getLabel() == arg1.getLabel()) {
                        return 0;
                    }
                    if (arg0.getLabel() == null) {
                        return -1;
                    }
                    if (arg1.getLabel() == null) {
                        return 1;
                    }
                    String wsType0 = arg0.getWsType();
                    if (wsType0.equals(wsType1 = arg1.getWsType())) {
                        if (wsType0.equals("jrxml")) {
                            if (arg0.isMainReport()) {
                                return -1;
                            }
                            if (arg1.isMainReport()) {
                                return 1;
                            }
                            return arg0.getLabel().compareToIgnoreCase(arg1.getLabel());
                        }
                        if (wsType0.equals("inputControl")) {
                            return 0;
                        }
                        return arg0.getLabel().compareToIgnoreCase(arg1.getLabel());
                    }
                    if (DatasourcesAllFilter.getTypes().contains(wsType0)) {
                        return -1;
                    }
                    if (DatasourcesAllFilter.getTypes().contains(wsType1)) {
                        return 1;
                    }
                    if (wsType0.equals("jrxml")) {
                        return -1;
                    }
                    if (wsType1.equals("jrxml")) {
                        return 1;
                    }
                    if (wsType0.equals("query")) {
                        return -1;
                    }
                    if (wsType1.equals("query")) {
                        return 1;
                    }
                    if (wsType0.equals("inputControl")) {
                        return -1;
                    }
                    if (wsType1.equals("inputControl")) {
                        return 1;
                    }
                    return wsType0.compareTo(wsType1);
                }
            });
        }
    }

    public List<ResourceDescriptor> list(IProgressMonitor monitor, ResourceDescriptor rd) throws Exception {
        List<ResourceDescriptor> list = this.client.list(rd);
        this.sortReportUnit(rd, list);
        return list;
    }

    public ResourceDescriptor move(IProgressMonitor monitor, ResourceDescriptor rd, String destFolderURI) throws Exception {
        this.client.move(rd, destFolderURI);
        ResourceDescriptor nrd = new ResourceDescriptor();
        nrd.setWsType(rd.getWsType());
        nrd.setUriString(String.valueOf(destFolderURI) + "/" + rd.getName());
        return this.parent.get(monitor, nrd, null);
    }

    public ResourceDescriptor copy(IProgressMonitor monitor, ResourceDescriptor rd, String destFolderURI) throws Exception {
        if (rd.getParentFolder().equals(destFolderURI)) {
            return rd;
        }
        destFolderURI = String.valueOf(destFolderURI) + "/" + rd.getName();
        return this.client.copy(rd, destFolderURI);
    }

    public ResourceDescriptor addOrModifyResource(IProgressMonitor monitor, ResourceDescriptor rd, File inputFile) throws Exception {
        rd.fixStructure();
        if (rd.getIsReference()) {
            rd.setWsType("reference");
        }
        List children = rd.getChildren();
        ResourceDescriptor mainDs = null;
        if (rd.getWsType().equals("reportUnit")) {
            for (ResourceDescriptor r : children) {
                if (rd.getIsNew() && SelectorDatasource.isDatasource((ResourceDescriptor)r)) {
                    mainDs = r;
                }
                if (!r.isMainReport() && (!r.getWsType().equals("jrxml") || !r.getName().equals("main_jrxml"))) continue;
                if (r.getFile() != null) {
                    inputFile = r.getFile();
                    r.setData(null);
                } else if (r.getHasData() && r.getData() != null) {
                    inputFile = SoapConnection.writeToTemp(r.getData());
                    r.setData(null);
                } else if (inputFile == null && !rd.getIsNew() && !r.getIsReference()) {
                    inputFile = FileUtils.createTempFile((String)"res", (String)"jrxml");
                    int ind = children.indexOf(r);
                    r = this.get(monitor, r, inputFile);
                    r.setHasData(true);
                    r.setData(FileUtils.readFileAsAString((File)inputFile).getBytes());
                    children.set(ind, r);
                }
                r.setMainReport(true);
                break;
            }
            if (mainDs != null) {
                rd.getChildren().remove(mainDs);
            }
        }
        rd = this.client.addOrModifyResource(rd, inputFile);
        List<ResourceDescriptor> oldChildren = this.list(monitor, rd);
        ArrayList<ResourceDescriptor> toDel = new ArrayList<ResourceDescriptor>();
        for (ResourceDescriptor r : oldChildren) {
            boolean exists = false;
            for (ResourceDescriptor newr : children) {
                if (newr.getUriString() == null || r.getUriString() == null || !r.getWsType().equals(newr.getWsType()) || !r.getUriString().equals(newr.getUriString())) continue;
                newr.setIsNew(false);
                exists = true;
                break;
            }
            if (exists || r.getWsType() == null || SelectorDatasource.isDatasource((ResourceDescriptor)r)) continue;
            toDel.add(r);
        }
        for (ResourceDescriptor r : toDel) {
            rd = this.delete(monitor, r, rd);
            if (!monitor.isCanceled()) continue;
            return rd;
        }
        if (rd.getWsType().equals("reportUnit")) {
            rd = this.get(monitor, rd, null);
            for (ResourceDescriptor r : children) {
                try {
                    if (SelectorDatasource.isDatasource((ResourceDescriptor)r) || r.isMainReport()) continue;
                    if (r.getWsType().equals("inputControl")) {
                        if (r.getIsReference()) {
                            r.setUriString(String.valueOf(rd.getUriString()) + "_files/" + r.getName());
                        }
                        if (!r.getIsNew()) {
                            r = this.client.addOrModifyResource(r, null);
                        } else {
                            this.client.modifyReportUnitResource(rd.getUriString(), r, null);
                        }
                    } else {
                        if (r.isMainReport()) continue;
                        File f = r.getFile();
                        if (f == null && r.getHasData() && r.getData() != null) {
                            f = SoapConnection.writeToTemp(r.getData());
                            r.setData(null);
                            r.setHasData(true);
                        }
                        r = this.client.modifyReportUnitResource(rd.getUriString(), r, f);
                    }
                    rd.getChildren().add(r);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (mainDs != null) {
                rd = this.get(monitor, rd, null);
                mainDs.setIsNew(false);
                rd.getChildren().add(0, mainDs);
                for (ResourceDescriptor r : rd.getChildren()) {
                    if (!r.getWsType().equals("jrxml") || !r.isMainReport()) continue;
                    r.setHasData(true);
                }
                this.client.addOrModifyResource(rd, inputFile);
            }
        }
        return rd;
    }

    public ResourceDescriptor modifyReportUnitResource(IProgressMonitor monitor, ResourceDescriptor runit, ResourceDescriptor rd, File inFile) throws Exception {
        rd.fixStructure();
        if (rd.getIsReference() && !rd.getWsType().equals("reference")) {
            rd.setIsReference(false);
            return this.client.addOrModifyResource(rd, inFile);
        }
        return this.client.modifyReportUnitResource(runit.getUriString(), rd, inFile);
    }

    public void delete(IProgressMonitor monitor, ResourceDescriptor rd) throws Exception {
        this.client.delete(rd);
    }

    public ResourceDescriptor delete(IProgressMonitor monitor, ResourceDescriptor rd, ResourceDescriptor runit) throws Exception {
        this.client.delete(rd, runit.getUriString());
        return runit;
    }

    public ReportExecution runReport(IProgressMonitor monitor, ReportExecution repExec) throws Exception {
        repExec.setStatus("ready");
        repExec.setFiles(new HashMap());
        repExec.setFiles(this.client.runReport(repExec.getResourceDescriptor(), repExec.getPrm(), repExec.getArgs()));
        return repExec;
    }

    public void cancelReport(IProgressMonitor monitor, ReportExecution repExec) throws Exception {
    }

    public List<ResourceDescriptor> listDatasources(IProgressMonitor monitor, IDatasourceFilter f) throws Exception {
        List<ResourceDescriptor> list = this.client.listDatasources();
        if (f != null) {
            ArrayList<ResourceDescriptor> toremove = new ArrayList<ResourceDescriptor>();
            for (ResourceDescriptor rd : list) {
                if (f.isDatasource(rd)) continue;
                toremove.add(rd);
            }
            list.removeAll(toremove);
        }
        return list;
    }

    public String getWebservicesUri() {
        return this.client.getWebservicesUri();
    }

    public String getUsername() {
        return this.client.getUsername();
    }

    public String getPassword(IProgressMonitor monitor) throws Exception {
        if (this.parent != null) {
            return this.parent.getPassword(monitor);
        }
        return Pass.getPass((String)this.sp.getPass());
    }

    public void findResources(IProgressMonitor monitor, AFinderUI callback) throws Exception {
        throw new UnsupportedOperationException(Messages.SoapConnection_45);
    }

    public ResourceDescriptor toResourceDescriptor(ClientResource<?> rest) {
        throw new UnsupportedOperationException();
    }

    public boolean isSupported(Feature f) {
        return false;
    }

    public void reorderInputControls(String uri, List<ResourceDescriptor> rds, IProgressMonitor monitor) throws Exception {
        ResourceDescriptor runit = new ResourceDescriptor();
        runit.setUriString(uri);
        runit = this.get(monitor, runit, null);
        ArrayList<ResourceDescriptor> toDel = new ArrayList<ResourceDescriptor>();
        for (ResourceDescriptor r : runit.getChildren()) {
            if (!r.getWsType().equals("inputControl")) continue;
            this.delete(monitor, r, runit);
            toDel.add(r);
        }
        runit.getChildren().removeAll(toDel);
        for (ResourceDescriptor r : rds) {
            r.setIsNew(true);
            if (!r.getParentFolder().endsWith("_files")) {
                r.setIsReference(true);
                r.setReferenceUri(r.getUriString());
                r.setParentFolder(String.valueOf(uri) + "_files");
            }
            r.setUriString(String.valueOf(uri) + "_files/" + r.getName());
            PublishUtil.setChild((ResourceDescriptor)runit, (ResourceDescriptor)r);
        }
        this.addOrModifyResource(monitor, runit, null);
    }

    public ResourceDescriptor initInputControls(String uri, String type, IProgressMonitor monitor) throws Exception {
        ResourceDescriptor rdrepunit = WSClientHelper.getReportUnit((IProgressMonitor)monitor, (String)uri);
        ArrayList<ResourceDescriptor> inputcontrols = new ArrayList<ResourceDescriptor>();
        HashSet<String> icNames = new HashSet<String>();
        String dsUri = null;
        for (ResourceDescriptor sub_rd : rdrepunit.getChildren()) {
            String wsType = sub_rd.getWsType();
            if (wsType.equals("inputControl")) {
                inputcontrols.add(sub_rd);
                icNames.add(sub_rd.getName());
                continue;
            }
            if (SelectorDatasource.isDatasource((ResourceDescriptor)sub_rd) && sub_rd.getIsReference()) {
                dsUri = sub_rd.getReferenceUri();
                continue;
            }
            if (!SelectorDatasource.isDatasource((ResourceDescriptor)sub_rd)) continue;
            dsUri = sub_rd.getUriString();
        }
        int i = 0;
        while (i < inputcontrols.size()) {
            ResourceDescriptor ic = (ResourceDescriptor)inputcontrols.get(i);
            if (InputControlsManager.isICQuery((ResourceDescriptor)ic)) {
                String dsUriQuery = SoapConnection.getDataSourceQueryURI(dsUri, ic);
                ic.setResourceProperty("PROP_QUERY_DATA", null);
                ArrayList<Argument> args = new ArrayList<Argument>();
                args.add(new Argument("IC_GET_QUERY_DATA", dsUriQuery));
                args.add(new Argument("RU_REF_URI", uri));
                ic = this.client.get(ic, null, args);
                this.cascadingDependencies(ic, icNames);
            } else if (InputControlsManager.isICListOfValues((ResourceDescriptor)ic) && !ic.getChildren().isEmpty()) {
                ResourceDescriptor rd2 = (ResourceDescriptor)ic.getChildren().get(0);
                if (rd2.getWsType().equals("reference")) {
                    ResourceDescriptor tmpRd = new ResourceDescriptor();
                    tmpRd.setUriString(rd2.getReferenceUri());
                    tmpRd = this.get(monitor, tmpRd, null);
                    ic.setListOfValues(tmpRd.getListOfValues());
                } else {
                    ic.setListOfValues(rd2.getListOfValues());
                }
            }
            int j = 0;
            while (j < rdrepunit.getChildren().size()) {
                ResourceDescriptor r = (ResourceDescriptor)rdrepunit.getChildren().get(j);
                if (r.getName() != null && r.getName().equals(ic.getName())) {
                    rdrepunit.getChildren().set(j, ic);
                }
                ++j;
            }
            ++i;
        }
        return rdrepunit;
    }

    private void cascadingDependencies(ResourceDescriptor ic, Set<String> icNames) {
        List children = ic.getChildren();
        for (ResourceDescriptor sub_ic : children) {
            if (!InputControlsManager.isRDQuery((ResourceDescriptor)sub_ic)) continue;
            String queryString = sub_ic.getSql();
            String lang = sub_ic.getResourceProperty("PROP_QUERY_LANGUAGE").getValue();
            if (Misc.isNullOrEmpty((String)queryString)) break;
            ArrayList<String> parameters = new ArrayList<String>();
            JRDesignQuery query = new JRDesignQuery();
            query.setText(queryString);
            if (lang != null) {
                query.setLanguage(lang);
            }
            JRQueryChunk[] jRQueryChunkArray = query.getChunks();
            int n = jRQueryChunkArray.length;
            int n2 = 0;
            while (n2 < n) {
                JRQueryChunk chunk = jRQueryChunkArray[n2];
                switch (chunk.getType()) {
                    case 1: {
                        break;
                    }
                    case 2: 
                    case 3: {
                        String paramName = chunk.getText().trim();
                        if (parameters.contains(paramName) || !icNames.contains(paramName)) break;
                        parameters.add(paramName);
                        break;
                    }
                    case 4: {
                        String[] tokens = chunk.getTokens();
                        if (tokens.length <= 2) break;
                        String[] stringArray = tokens;
                        int n3 = tokens.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            String t = stringArray[n4];
                            if (!parameters.contains(t = t.trim()) && icNames.contains(t)) {
                                parameters.add(t);
                            }
                            ++n4;
                        }
                        break;
                    }
                }
                ++n2;
            }
            if (parameters.isEmpty()) break;
            ic.setMasterInputControls(parameters);
            break;
        }
    }

    public List<ResourceDescriptor> cascadeInputControls(ResourceDescriptor runit, List<ResourceDescriptor> ics, IProgressMonitor monitor) throws Exception {
        String dsUri = null;
        for (ResourceDescriptor sub_rd : runit.getChildren()) {
            if (SelectorDatasource.isDatasource((ResourceDescriptor)sub_rd) && sub_rd.getIsReference()) {
                dsUri = sub_rd.getReferenceUri();
                continue;
            }
            if (!SelectorDatasource.isDatasource((ResourceDescriptor)sub_rd)) continue;
            dsUri = sub_rd.getUriString();
        }
        String ruri = runit.getUriString();
        ArrayList<ResourceDescriptor> res = new ArrayList<ResourceDescriptor>();
        for (ResourceDescriptor rd : ics) {
            res.add(this.updateControl(ruri, dsUri, rd, monitor));
        }
        return res;
    }

    private ResourceDescriptor updateControl(String runit, String dsUri, ResourceDescriptor rd, IProgressMonitor monitor) throws Exception {
        ArrayList<Argument> args = new ArrayList<Argument>();
        args.add(new Argument("IC_GET_QUERY_DATA", SoapConnection.getDataSourceQueryURI(dsUri, rd)));
        args.add(new Argument("RU_REF_URI", runit));
        rd.getParameters().clear();
        rd.setResourceProperty("PROP_QUERY_DATA", null);
        Map parameters = rd.getIcValues();
        for (String key : parameters.keySet()) {
            Object value = parameters.get(key);
            if (value == null) continue;
            if (value instanceof Collection) {
                for (String item : (Collection)value) {
                    ListItem l = new ListItem(key, (Object)item);
                    l.setIsListItem(true);
                    rd.getParameters().add(l);
                }
                continue;
            }
            rd.getParameters().add(new ListItem(key, value));
        }
        return this.client.get(rd, null, args);
    }

    private static String getDataSourceQueryURI(String dsUri, ResourceDescriptor ic) {
        String dsUriQuery = null;
        int k = 0;
        while (dsUriQuery == null && k < ic.getChildren().size()) {
            ResourceDescriptor sub_ic = (ResourceDescriptor)ic.getChildren().get(k);
            if (InputControlsManager.isRDQuery((ResourceDescriptor)sub_ic)) {
                int k2 = 0;
                while (k2 < sub_ic.getChildren().size()) {
                    ResourceDescriptor sub_sub_ic = (ResourceDescriptor)sub_ic.getChildren().get(k2);
                    if (SelectorDatasource.isDatasource((ResourceDescriptor)sub_sub_ic)) {
                        dsUriQuery = sub_sub_ic.getUriString();
                        break;
                    }
                    ++k2;
                }
            }
            ++k;
        }
        if (dsUriQuery == null) {
            dsUriQuery = dsUri;
        }
        return dsUriQuery;
    }

    public void setParent(IConnection parent) {
        this.parent = parent;
    }

    public static File writeToTemp(byte[] b64data) throws IOException {
        File inputFile = FileUtils.createTempFile((String)"save", (String)"jrxml");
        inputFile.deleteOnExit();
        org.apache.commons.io.FileUtils.write((File)inputFile, (CharSequence)new String(Base64.decodeBase64((byte[])b64data)));
        return inputFile;
    }

    public StateDto importMetaData(ImportOptions options, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public StateDto exportMetaData(ExportOptions options, IProgressMonitor monitor) throws Exception {
        return null;
    }

    public Integer getPermissionMask(ResourceDescriptor rd, IProgressMonitor monitor) throws Exception {
        return 1;
    }

    public List<RepositoryPermission> getPermissions(ResourceDescriptor rd, IProgressMonitor monitor, PermissionOptions options) throws Exception {
        WSObjectPermission[] m = this.client.getPermissionsManagement().getPermissionsForObject("repo:" + rd.getUriString());
        ArrayList<RepositoryPermission> perms = new ArrayList<RepositoryPermission>();
        WSObjectPermission[] wSObjectPermissionArray = m;
        int n = m.length;
        int n2 = 0;
        while (n2 < n) {
            Object prec;
            WSObjectPermission p = wSObjectPermissionArray[n2];
            String uri = p.getUri();
            if (uri != null) {
                uri = uri.replaceAll("repo:", "");
            }
            if ((prec = p.getPermissionRecipient()) instanceof WSRole && !options.isRecipientTypeUser()) {
                perms.add(new RepositoryPermission(uri, ((WSRole)prec).getRoleName(), p.getPermissionMask()));
            } else if (prec instanceof WSUser && options.isRecipientTypeUser()) {
                perms.add(new RepositoryPermission(uri, ((WSUser)prec).getUsername(), p.getPermissionMask()));
            }
            ++n2;
        }
        return perms;
    }

    public ClientUser getUser(IProgressMonitor monitor) throws Exception {
        return null;
    }

    public List<RepositoryPermission> setPermissions(ResourceDescriptor rd, List<RepositoryPermission> perms, PermissionOptions options, IProgressMonitor monitor) throws Exception {
        return perms;
    }

    public void uploadJdbcDrivers(JdbcDriver driver, IProgressMonitor monitor) throws Exception {
    }

    public JdbcDriverInfo getJdbcDrivers(IProgressMonitor monitor) throws Exception {
        return null;
    }
}

