/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.widgets.map.ui;

import com.jaspersoft.studio.widgets.map.browserfunctions.AddNewMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.ClearMarkersList;
import com.jaspersoft.studio.widgets.map.browserfunctions.GMapEnabledFunction;
import com.jaspersoft.studio.widgets.map.browserfunctions.RemoveMarker;
import com.jaspersoft.studio.widgets.map.browserfunctions.UpdateMarkerPosition;
import com.jaspersoft.studio.widgets.map.core.LatLng;
import com.jaspersoft.studio.widgets.map.core.Marker;
import com.jaspersoft.studio.widgets.map.messages.Messages;
import com.jaspersoft.studio.widgets.map.support.MapCredentials;
import com.jaspersoft.studio.widgets.map.ui.GMapsCenterPanel;
import com.jaspersoft.studio.widgets.map.ui.MapTile;
import com.jaspersoft.studio.widgets.map.ui.MapUIUtils;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.ProgressAdapter;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

public class GMapsMarkersPanel
extends GMapsCenterPanel {
    protected static DecimalFormat coordinatesFormatter = new DecimalFormat("#.######", new DecimalFormatSymbols(Locale.ENGLISH));
    protected List markersList;

    public GMapsMarkersPanel(Composite parent, int style, MapCredentials mapCredentials) {
        super(parent, style, mapCredentials);
    }

    @Override
    protected void createContent(Composite parent, int style) {
        this.createTop(parent);
        if (Util.isLinux()) {
            Composite warningCmp = MapUIUtils.createLinuxWarningText(parent);
            warningCmp.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        }
        SashForm sash = new SashForm(parent, style | 0x100){

            public void setBounds(int x, int y, int width, int height) {
                GMapsMarkersPanel.this.initMarkers = true;
                super.setBounds(x, y, width, height);
                GMapsMarkersPanel.this.initMarkers = false;
            }
        };
        if (parent.getLayout() instanceof GridLayout) {
            sash.setLayoutData((Object)new GridData(1808));
        }
        this.createMap((Composite)sash);
        Composite containerCmp = new Composite((Composite)sash, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        containerCmp.setLayout((Layout)layout);
        this.createRightPanel(containerCmp);
        UIUtils.getDisplay().asyncExec(() -> this.map.activateMapTile());
        sash.setWeights(new int[]{4, 1});
    }

    @Override
    protected void createMap(Composite parent) {
        this.map = new MapTile(parent, 0, this.mapCredentials);
        this.map.configureJavaSupport(new DetailsPanelMapSupportMarker(this.map.getMapControl()));
        this.map.getFunctions().add(new AddNewMarker(this.map.getMapControl(), "javaCall_AddMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new ClearMarkersList(this.map.getMapControl(), "javaCall_ClearMarkers", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new RemoveMarker(this.map.getMapControl(), "javaCall_DelMarker", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new UpdateMarkerPosition(this.map.getMapControl(), "javaCall_UpdateMarkerPosition", this.map.getJavaMapSupport()));
        this.map.getFunctions().add(new GMapEnabledFunction(this.map.getMapControl(), "javaCall_MarkerDoubleClick", this.map.getJavaMapSupport()){

            public Object function(Object[] arguments) {
                GMapsMarkersPanel.this.handleMarkerDoubleClick(((Double)arguments[0]).intValue());
                return null;
            }
        });
        this.map.getFunctions().add(new GMapsCenterPanel.InitialConfigurationFunction(this.map.getMapControl(), "javaCall_InitialConfiguration", this.map.getJavaMapSupport()));
        this.map.getMapControl().addListener(27, event -> {
            Object object = this.map.getJavascriptMapSupport().evaluateJavascript("myMap.hideMenus();");
        });
        this.map.getMapControl().addControlListener(new ControlListener(){
            private boolean first = true;

            public void controlResized(ControlEvent e) {
                if (this.first) {
                    UIUtils.getDisplay().asyncExec(() -> GMapsMarkersPanel.this.centerMap(GMapsMarkersPanel.this.getMapCenter()));
                }
                this.first = false;
            }

            public void controlMoved(ControlEvent e) {
            }
        });
        this.map.getMapControl().addProgressListener((ProgressListener)new ProgressAdapter(){

            public void completed(ProgressEvent event) {
                GMapsMarkersPanel.this.map.getJavascriptMapSupport().evaluateJavascript("MENU_KIND=_MENU_COMPLETE");
            }
        });
    }

    protected void createRightPanel(Composite containerCmp) {
        this.createMarkersLabel(containerCmp);
        this.markersList = new List(containerCmp, 2818);
        this.markersList.setLayoutData((Object)new GridData(4, 4, true, true));
        this.markersList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int markerIdx = GMapsMarkersPanel.this.markersList.getSelectionIndex();
                UIUtils.getDisplay().asyncExec(() -> GMapsMarkersPanel.this.map.getJavascriptMapSupport().highlightMarker(markerIdx));
            }
        });
        this.markersList.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 127 || e.keyCode == 8) {
                    GMapsMarkersPanel.this.deleteMarker();
                }
            }
        });
        this.markersList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                if (GMapsMarkersPanel.this.markersList.getSelectionCount() <= 0) {
                    return;
                }
                GMapsMarkersPanel.this.handleMarkerDoubleClick(GMapsMarkersPanel.this.markersList.getSelectionIndex());
            }
        });
        final Menu menu = new Menu((Control)this.markersList);
        this.markersList.setMenu(menu);
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                int selected = GMapsMarkersPanel.this.markersList.getSelectionIndex();
                MenuItem[] items = menu.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                if (selected < 0 || selected >= GMapsMarkersPanel.this.markersList.getItemCount() || GMapsMarkersPanel.this.markersList.getItemCount() == 0) {
                    return;
                }
                MenuItem newItem = new MenuItem(menu, 0);
                newItem.setText(Messages.GMapsMarkersPanel_2);
                newItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        GMapsMarkersPanel.this.deleteMarker();
                    }
                });
            }
        });
    }

    protected void createMarkersLabel(Composite containerCmp) {
        Label markersLbl = new Label(containerCmp, 0);
        markersLbl.setText(Messages.GMapsDetailsPanel_MarkersLbl);
        markersLbl.setLayoutData((Object)new GridData(4, 4, true, false));
    }

    protected void handleHighlightMarker(int markerIdx) {
        this.markersList.setSelection(markerIdx);
    }

    protected void handleUpdateMarkerPosition(int markerIdx, Marker m) {
        this.markersList.setItem(markerIdx, this.formatMarker(m));
    }

    protected void handleRemoveMarker(int markerIndex) {
        this.handleRemoveMarker(new int[]{markerIndex});
    }

    protected void handleRemoveMarker(int[] mIndxs) {
        this.markersList.remove(mIndxs);
    }

    protected void handleClearMarkers() {
        this.markersList.removeAll();
    }

    protected void handleMarkerDoubleClick(int ind) {
    }

    public void addNewMarker(Marker m) {
        LatLng p = m.getPosition();
        if (p != null) {
            this.markersList.add(this.formatMarker(m));
            this.map.getJavascriptMapSupport().addNewMarker(m);
            this.map.getJavaMapSupport().addNewMarker(m);
        }
    }

    protected void handleNewMarker(Marker newMarker) {
        if (this.initMarkers) {
            return;
        }
        this.markersList.add(this.formatMarker(newMarker));
    }

    protected String formatMarker(Marker m) {
        LatLng p = m.getPosition();
        StringBuilder builder = new StringBuilder();
        builder.append(coordinatesFormatter.format(p.getLat()));
        builder.append(" : ");
        builder.append(coordinatesFormatter.format(p.getLng()));
        return builder.toString();
    }

    public void clearMarkers() {
        this.map.getJavascriptMapSupport().clearMarkers();
        if (this.markersList != null) {
            this.markersList.removeAll();
        }
    }

    protected void deleteMarker() {
        if (this.markersList.getSelectionCount() <= 0) {
            return;
        }
        UIUtils.getDisplay().asyncExec(() -> {
            MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.GMapsMarkersPanel_2, null, Messages.GMapsMarkersPanel_7, 3, new String[]{Messages.GMapsMarkersPanel_8, Messages.GMapsMarkersPanel_9}, 1);
            if (dialog.open() == 0) {
                this.handleRemoveMarker(this.markersList.getSelectionIndices());
            }
        });
    }

    @Override
    public void dispose() {
        if (this.map != null) {
            this.map.dispose();
        }
    }

    class DetailsPanelMapSupportMarker
    extends GMapsCenterPanel.DetailsPanelMapSupport {
        DetailsPanelMapSupportMarker(Browser browser) {
            super(browser);
        }

        @Override
        public void removeMarker(int markerIndex) {
            MessageDialog dialog = new MessageDialog(UIUtils.getShell(), Messages.GMapsMarkersPanel_2, null, Messages.GMapsMarkersPanel_7, 3, new String[]{Messages.GMapsMarkersPanel_8, Messages.GMapsMarkersPanel_9}, 1);
            if (dialog.open() == 0) {
                super.removeMarker(markerIndex);
                if (GMapsMarkersPanel.this.initMarkers) {
                    return;
                }
                GMapsMarkersPanel.this.handleRemoveMarker(markerIndex);
            } else {
                GMapsMarkersPanel.this.refresh();
            }
        }

        @Override
        public void removeMarker(Marker oldMarker) {
            if (GMapsMarkersPanel.this.initMarkers) {
                return;
            }
            int mIdx = this.getMarkers().indexOf(oldMarker);
            if (mIdx > 0) {
                this.removeMarker(mIdx);
            }
        }

        @Override
        public void highlightMarker(int markerIdx) {
            if (GMapsMarkersPanel.this.initMarkers) {
                return;
            }
            super.highlightMarker(markerIdx);
            GMapsMarkersPanel.this.handleHighlightMarker(markerIdx);
        }

        @Override
        public void updateMarkerPosition(int markerIdx, LatLng newPosition) {
            super.updateMarkerPosition(markerIdx, newPosition);
            if (GMapsMarkersPanel.this.initMarkers) {
                return;
            }
            GMapsMarkersPanel.this.handleUpdateMarkerPosition(markerIdx, this.getMarkers().get(markerIdx));
        }

        @Override
        public void clearMarkers() {
            super.clearMarkers();
            if (GMapsMarkersPanel.this.initMarkers) {
                return;
            }
            GMapsMarkersPanel.this.handleClearMarkers();
        }

        @Override
        public void addNewMarker(Marker newMarker) {
            super.addNewMarker(newMarker);
            if (GMapsMarkersPanel.this.initMarkers) {
                return;
            }
            GMapsMarkersPanel.this.handleNewMarker(newMarker);
        }
    }
}

