/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio;

import com.jaspersoft.studio.IConversionFilenameProvider;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.util.PropertiesHelper;
import com.jaspersoft.studio.statistics.IFirstStartupAction;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.KeyValue;
import net.sf.jasperreports.engine.util.JRXmlUtils;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.osgi.service.datalocation.Location;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.InputSource;

public class ConfigurationManager {
    private static String cachedPath = null;
    private static File jssDataFolder = null;
    private static File appDataFolder = null;
    private static final String JSS_APPLICATION_ID = "Jaspersoft Studio";
    private static final String PATH_FILE = ".path";
    private static final String CMD_VMARGS = "-vmargs";
    private static final String CMD_NL = "-nl";

    private static void intializePath() {
        String path = null;
        Location configArea = Platform.getInstallLocation();
        String product = Platform.getProduct().getProperty("appName");
        if (configArea != null) {
            if (Util.isMac()) {
                path = String.valueOf(configArea.getURL().toExternalForm()) + "/";
                path = String.valueOf(path) + product + ".ini";
            } else {
                path = String.valueOf(configArea.getURL().toExternalForm()) + product + ".ini";
            }
        }
        cachedPath = path;
    }

    public static String getApplicationConfigurationPath() {
        if (cachedPath == null) {
            ConfigurationManager.intializePath();
        }
        return cachedPath;
    }

    public static File getApplicationConfigurationFile() {
        String configurationPath = ConfigurationManager.getApplicationConfigurationPath();
        try {
            File configurationFile = new File(new URL(configurationPath).getFile());
            return configurationFile;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getApplicationFolder() {
        if (cachedPath == null) {
            ConfigurationManager.intializePath();
        }
        return cachedPath != null ? new File(cachedPath).getParent() : null;
    }

    public static boolean isConfigurationAccessible() {
        File configurationFile = ConfigurationManager.getApplicationConfigurationFile();
        if (configurationFile != null && configurationFile.exists() && configurationFile.isFile()) {
            return configurationFile.canRead() && configurationFile.canWrite();
        }
        return false;
    }

    public static boolean isConfigurationAccessibleWithMessage() {
        boolean accessible = ConfigurationManager.isConfigurationAccessible();
        if (!accessible) {
            String configurationPath = ConfigurationManager.getApplicationConfigurationFile().getAbsolutePath();
            UIUtils.showWarning((String)Messages.ConfigurationManager_notAccessibleTitle, (String)MessageFormat.format(Messages.ConfigurationManager_notAccessibleMessage, configurationPath));
        }
        return accessible;
    }

    private static File getJSSDataFolder() {
        if (jssDataFolder == null) {
            String workingDirectory;
            if (Util.isWindows()) {
                workingDirectory = System.getenv("AppData");
            } else if (Util.isLinux()) {
                workingDirectory = System.getProperty("user.home");
                if (!workingDirectory.endsWith("/")) {
                    workingDirectory = String.valueOf(workingDirectory) + "/";
                }
                workingDirectory = String.valueOf(workingDirectory) + ".config";
            } else {
                workingDirectory = System.getProperty("user.home");
                workingDirectory = String.valueOf(workingDirectory) + "/Library/Application Support";
            }
            jssDataFolder = new File(workingDirectory, JSS_APPLICATION_ID);
            jssDataFolder.mkdirs();
        }
        return jssDataFolder;
    }

    public static File getAppDataFolder() {
        Location configArea;
        if (appDataFolder == null && (configArea = Platform.getInstallLocation()) != null) {
            String path = configArea.getURL().toExternalForm();
            File appFolder = ConfigurationManager.getJSSDataFolder();
            if (appFolder != null) {
                File[] fileArray = appFolder.listFiles();
                int n = fileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    File file = fileArray[n2];
                    String appId = ConfigurationManager.getAppId(file);
                    if (appId != null && appId.equals(path)) {
                        appDataFolder = file;
                        break;
                    }
                    ++n2;
                }
            }
            if (appDataFolder == null) {
                PropertiesHelper ph = PropertiesHelper.getInstance();
                String startingUUID = ph.getString("UUID", null);
                if (startingUUID == null) {
                    startingUUID = UUID.randomUUID().toString();
                }
                appDataFolder = new File(appFolder, startingUUID);
                while (appDataFolder.exists()) {
                    appDataFolder = new File(appFolder, UUID.randomUUID().toString());
                }
                appDataFolder.mkdir();
                ConfigurationManager.writeAppId(appDataFolder, path);
                for (IFirstStartupAction action : JaspersoftStudioPlugin.getExtensionManager().getFirstStartupActions()) {
                    action.executeFirstStartupAction(appDataFolder);
                }
            }
        }
        return appDataFolder;
    }

    public static File getAppDataFolder(String folderName) {
        File dataFolder = new File(ConfigurationManager.getAppDataFolder(), folderName);
        dataFolder.mkdir();
        return dataFolder;
    }

    public static String getInstallationUUID() {
        return ConfigurationManager.getAppDataFolder().getName();
    }

    private static String getAppId(File appDataFolder) {
        File textFile = new File(appDataFolder, PATH_FILE);
        if (textFile.exists()) {
            String string;
            BufferedReader reader = null;
            try {
                String sCurrentLine;
                reader = new BufferedReader(new FileReader(textFile.getAbsolutePath()));
                string = sCurrentLine = reader.readLine();
            }
            catch (Exception e) {
                try {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(com.jaspersoft.studio.statistics.messages.Messages.UsageManager_errorPathFile, e);
                }
                catch (Throwable throwable) {
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(reader);
                    throw throwable;
                }
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)reader);
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)reader);
            return string;
        }
        return null;
    }

    private static void writeAppId(File appDataFolder, String installationPath) {
        block6: {
            File textFile = new File(appDataFolder, PATH_FILE);
            if (textFile.exists()) {
                textFile.delete();
            }
            BufferedWriter writer = null;
            try {
                try {
                    writer = new BufferedWriter(new FileWriter(textFile.getAbsolutePath()));
                    writer.write(installationPath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(com.jaspersoft.studio.statistics.messages.Messages.UsageManager_errorPathFile, e);
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)writer);
                    break block6;
                }
            }
            catch (Throwable throwable) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(writer);
                throw throwable;
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)writer);
        }
    }

    public static File getStorage(String storageName) {
        IPath configurationPath = JaspersoftStudioPlugin.getInstance().getStateLocation();
        File configurationFolder = configurationPath.toFile();
        File storage = new File(configurationFolder, storageName);
        if (!storage.exists()) {
            storage.mkdir();
        }
        return storage;
    }

    public static File[] getStorageContent(String storageName) {
        File[] listFiles;
        File storage = ConfigurationManager.getStorage(storageName);
        ArrayList<File> result = new ArrayList<File>();
        File[] fileArray = listFiles = storage.listFiles();
        int n = listFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (!f.isHidden()) {
                result.add(f);
            }
            ++n2;
        }
        return result.toArray(new File[result.size()]);
    }

    public static boolean removeStoregeResource(String storageName, String resourceName) {
        File storage = ConfigurationManager.getStorage(storageName);
        File resource = new File(storage, resourceName);
        if (resource.exists()) {
            return resource.delete();
        }
        return false;
    }

    public static File getStorageResource(String storageName, String resourceName) {
        return ConfigurationManager.getStorageResource(ConfigurationManager.getStorage(storageName), resourceName);
    }

    public static File getStorageResource(File resourceStorage, String resourceName) {
        File resource = new File(resourceStorage, resourceName);
        if (resource.exists()) {
            return resource;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static void convertPropertyToStorage(String preferenceKey, String storageName, IConversionFilenameProvider nameProvider) {
        block12: {
            prefs = PropertiesHelper.INSTANCE_SCOPE.getNode(JaspersoftStudioPlugin.getUniqueIdentifier());
            xml = prefs.get(preferenceKey, null);
            if (xml == null) {
                return;
            }
            createtElements = new ArrayList<File>();
            sr = new StringReader(xml);
            try {
                document = JRXmlUtils.parse((InputSource)new InputSource(sr));
                configurationNodes = document.getDocumentElement().getChildNodes();
                storage = ConfigurationManager.getStorage(storageName);
                transformerFactory = TransformerFactory.newInstance();
                transformer = transformerFactory.newTransformer();
                i = 0;
                while (i < configurationNodes.getLength()) {
                    configurationNode = configurationNodes.item(i);
                    if (configurationNode.getNodeType() == 1) {
                        source = new DOMSource(configurationNode);
                        name = nameProvider.getFileName(configurationNode);
                        if (name != null) {
                            xmlTargetFile = new File(storage, name);
                            if (!xmlTargetFile.exists()) {
                                createtElements.add(xmlTargetFile);
                                stream = new FileOutputStream(xmlTargetFile);
                                try {
                                    result = new StreamResult(stream);
                                    transformer.transform(source, result);
                                }
                                finally {
                                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)stream);
                                }
                            } else {
                                throw new Exception("File " + xmlTargetFile.getAbsolutePath() + " already exist");
                            }
                        }
                    }
                    ++i;
                }
                prefs.remove(preferenceKey);
                break block12;
            }
            catch (Exception e) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)sr);
                JaspersoftStudioPlugin.getInstance().logError("Error converting the element", e);
                ** for (createdElement : createtElements)
            }
lbl-1000:
            // 1 sources

            {
                if (!createdElement.exists()) continue;
                createdElement.delete();
                continue;
            }
lbl45:
            // 1 sources

            throw new RuntimeException(e);
        }
    }

    private static String listToString(List<String> list) {
        StringBuilder result = new StringBuilder();
        if (!list.isEmpty()) {
            String separator = System.getProperty("line.separator");
            String lastLine = null;
            int i = list.size() - 1;
            while (i >= 0) {
                String currentLine = list.get(i);
                if (currentLine != null) {
                    lastLine = currentLine;
                    break;
                }
                --i;
            }
            for (String outLine : list) {
                if (outLine == null) continue;
                result.append(outLine);
                if (outLine == lastLine) continue;
                result.append(separator);
            }
        }
        return result.toString();
    }

    /*
     * Unable to fully structure code
     */
    public static boolean changeLocale(String locale) {
        block11: {
            block9: {
                fileChanged = false;
                if (!ConfigurationManager.isConfigurationAccessibleWithMessage()) break block11;
                configurationFile = ConfigurationManager.getApplicationConfigurationFile();
                in = null;
                out = null;
                in = new BufferedReader(new FileReader(configurationFile));
                line = in.readLine();
                configLines = new ArrayList<String>();
                localePosition = -1;
                lineNumber = 0;
                while (line != null) {
                    if (line.equals("-nl")) {
                        localePosition = lineNumber + 1;
                    } else if (localePosition == -1 && (line.equals("-vmargs") || line.equals("-clean") || line.equals("-vm"))) {
                        configLines.add("-nl");
                        configLines.add("");
                        localePosition = lineNumber + 1;
                    }
                    configLines.add(line);
                    ++lineNumber;
                    line = in.readLine();
                }
                if (localePosition == -1) ** GOTO lbl40
                if (!((String)configLines.get(localePosition)).equals(locale)) break block9;
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                return false;
            }
            try {
                try {
                    block12: {
                        configLines.set(localePosition, locale);
                        break block12;
lbl40:
                        // 1 sources

                        configLines.add("-nl");
                        configLines.add(locale);
                    }
                    fileChanged = ConfigurationManager.writeConfigurationFile(ConfigurationManager.listToString(configLines));
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(ex);
                    MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.SwitchLanguageHandler_errorTitle, (String)MessageFormat.format(Messages.SwitchLanguageHandler_errorMessage, new Object[]{configurationFile.getAbsolutePath()}));
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                }
            }
            catch (Throwable var9_10) {
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                throw var9_10;
            }
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
            net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
        }
        return fileChanged;
    }

    public static boolean changeVMArgs(KeyValue<String, String>[] vmargs) {
        boolean fileChanged;
        block18: {
            fileChanged = false;
            if (ConfigurationManager.isConfigurationAccessibleWithMessage()) {
                File configurationFile = ConfigurationManager.getApplicationConfigurationFile();
                BufferedReader in = null;
                Closeable out = null;
                try {
                    try {
                        KeyValue<String, String> vmarg;
                        in = new BufferedReader(new FileReader(configurationFile));
                        String line = in.readLine();
                        ArrayList<String> configLines = new ArrayList<String>();
                        int vmArgsPosition = -1;
                        int lineNumber = 0;
                        HashMap<String, Integer> argsMap = new HashMap<String, Integer>();
                        while (line != null) {
                            if (vmArgsPosition == -1 && line.equals(CMD_VMARGS)) {
                                vmArgsPosition = lineNumber;
                            }
                            configLines.add(line);
                            if (vmArgsPosition != -1 && line.contains("=")) {
                                String[] nameValue = line.split("=");
                                argsMap.put(nameValue[0], lineNumber);
                            }
                            ++lineNumber;
                            line = in.readLine();
                        }
                        if (vmArgsPosition != -1) {
                            KeyValue<String, String>[] keyValueArray = vmargs;
                            int n = vmargs.length;
                            int n2 = 0;
                            while (n2 < n) {
                                vmarg = keyValueArray[n2];
                                Integer existingIndex = (Integer)argsMap.get(vmarg.key);
                                if (existingIndex != null) {
                                    if (vmarg.value == null) {
                                        configLines.set(existingIndex, null);
                                    } else {
                                        configLines.set(existingIndex, String.valueOf((String)vmarg.key) + "=" + (String)vmarg.value);
                                    }
                                } else if (vmarg.value != null) {
                                    configLines.add(String.valueOf((String)vmarg.key) + "=" + (String)vmarg.value);
                                }
                                ++n2;
                            }
                        } else {
                            configLines.add(CMD_VMARGS);
                            KeyValue<String, String>[] keyValueArray = vmargs;
                            int n = vmargs.length;
                            int n3 = 0;
                            while (n3 < n) {
                                vmarg = keyValueArray[n3];
                                configLines.add(String.valueOf((String)vmarg.key) + "=" + (String)vmarg.value);
                                ++n3;
                            }
                        }
                        fileChanged = ConfigurationManager.writeConfigurationFile(ConfigurationManager.listToString(configLines));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(ex);
                        MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.SwitchLanguageHandler_errorTitle, (String)MessageFormat.format(Messages.SwitchLanguageHandler_errorMessage, configurationFile.getAbsolutePath()));
                        net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                        net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                        break block18;
                    }
                }
                catch (Throwable throwable) {
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(in);
                    net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
                    throw throwable;
                }
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream((Closeable)in);
                net.sf.jasperreports.eclipse.util.FileUtils.closeStream(out);
            }
        }
        return fileChanged;
    }

    public static boolean writeConfigurationFile(String configurationContent) {
        if (ConfigurationManager.isConfigurationAccessibleWithMessage()) {
            try {
                File fini = ConfigurationManager.getApplicationConfigurationFile();
                if (fini.exists()) {
                    try {
                        FileUtils.copyFile((File)fini, (File)new File(String.valueOf(fini.toString()) + ".bak"));
                    }
                    catch (IOException e) {
                        JaspersoftStudioPlugin.getInstance().logError("Unable to create bak file for the .ini file", e);
                    }
                }
                if (!fini.exists()) {
                    fini.getParentFile().mkdirs();
                    fini.createNewFile();
                }
                FileUtils.writeStringToFile((File)fini, (String)configurationContent);
                return true;
            }
            catch (IOException e) {
                UIUtils.showError((Throwable)e);
            }
        }
        return false;
    }

    public static String getCurrentWorkspaceLocation() {
        return ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
    }
}

