/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio;

import com.jaspersoft.studio.data.defaults.DefaultDAManager;
import com.jaspersoft.studio.editor.gef.decorator.DecoratorManager;
import com.jaspersoft.studio.editor.gef.ui.actions.EditorSettingsContributorManager;
import com.jaspersoft.studio.editor.layout.LayoutManager;
import com.jaspersoft.studio.editor.preview.input.ext.InputControlTypeManager;
import com.jaspersoft.studio.editor.toolitems.ToolItemsManager;
import com.jaspersoft.studio.jasper.ComponentConverterManager;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.plugin.ExtensionManager;
import com.jaspersoft.studio.preferences.util.PreferencesUtils;
import com.jaspersoft.studio.property.PostDeleteManager;
import com.jaspersoft.studio.property.PostSetValueManager;
import com.jaspersoft.studio.property.dataset.dialog.DataQueryAdapters;
import com.jaspersoft.studio.property.section.report.util.PHolderUtil;
import com.jaspersoft.studio.statistics.UsageManager;
import com.jaspersoft.studio.utils.BrandingInfo;
import com.jaspersoft.studio.utils.browser.BrowserInfo;
import com.jaspersoft.studio.utils.jasper.DriversManager;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.category.ReportTemplatesWizardPage;
import java.io.OutputStream;
import java.io.PrintStream;
import net.sf.jasperreports.eclipse.AbstractJRUIPlugin;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.eclipse.wizard.project.ProjectUtil;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.osgi.framework.BundleContext;

public class JaspersoftStudioPlugin
extends AbstractJRUIPlugin {
    public static final String ICONS_RESOURCES_REFRESH_16_PNG = "icons/resources/refresh-16.png";
    public static final String PLUGIN_ID = "com.jaspersoft.studio";
    public static final String COMPONENTS_ID = "com.jaspersoft.studio.components";
    private static ExtensionManager extensionManager;
    private static ComponentConverterManager converterManager;
    private static JaspersoftStudioPlugin plugin;
    private UsageManager manager;
    private static DecoratorManager decoratorManager;
    private static EditorSettingsContributorManager editorSettingsManager;
    private static DefaultDAManager daManager;
    private static ToolItemsManager toolItemsManager;
    private static PostSetValueManager postSetValueManager;
    private static PostDeleteManager postDeleteManager;
    private static InputControlTypeManager inputControlTypeManager;

    public static JaspersoftStudioPlugin getInstance() {
        return plugin;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        String chromeEnabledproperty = "net.sf.jasperreports.chrome.enabled";
        PreferencesUtils.getJaspersoftStudioPrefStore().setValue(chromeEnabledproperty, "true");
        PreferencesUtils.storeJasperReportsProperty(chromeEnabledproperty, "true");
        DefaultJasperReportsContext.getInstance().setProperty(chromeEnabledproperty, "true");
        String chromePageIsolate = "net.sf.jasperreports.chrome.page.isolate";
        PreferencesUtils.getJaspersoftStudioPrefStore().setValue(chromePageIsolate, "true");
        PreferencesUtils.storeJasperReportsProperty(chromePageIsolate, "true");
        DefaultJasperReportsContext.getInstance().setProperty(chromePageIsolate, "true");
        String chromeRemoteAllowOrigins = "net.sf.jasperreports.chrome.argument.remote-allow-origins";
        PreferencesUtils.getJaspersoftStudioPrefStore().setValue(chromeRemoteAllowOrigins, "*");
        PreferencesUtils.storeJasperReportsProperty(chromeRemoteAllowOrigins, "*");
        DefaultJasperReportsContext.getInstance().setProperty(chromeRemoteAllowOrigins, "*");
    }

    public JaspersoftStudioPlugin() {
        plugin = this;
    }

    public synchronized UsageManager getUsageManager() {
        if (this.manager == null) {
            this.manager = new UsageManager();
        }
        return this.manager;
    }

    public void stop(BundleContext context) throws Exception {
        if (this.manager != null) {
            this.manager.stop();
        }
        plugin = null;
        super.stop(context);
    }

    protected void postStartOperations() {
        super.postStartOperations();
        DataQueryAdapters.initMetadata();
        PHolderUtil.initMetadata();
        LayoutManager.initMetadata();
        BrandingInfo info = new BrandingInfo();
        info.setProductName(Messages.JaspersoftStudioPlugin_BrandingInfoJSSPlugin);
        info.setProductVersion(this.getBundle().getVersion().toString());
        info.setProductMainBundleID(PLUGIN_ID);
        this.setBrandingInformation(info);
        this.logInfo(NLS.bind((String)Messages.JaspersoftStudioPlugin_StartingJSSBundleMsg, (Object)info.getProductVersion()));
        JasperReportsConfiguration c = JasperReportsConfiguration.getDefaultInstance();
        String key = "net.sf.jasperreports.default.font.name";
        JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty(key, c.getProperty(key));
        key = "net.sf.jasperreports.default.font.size";
        JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).setProperty(key, c.getProperty(key));
        BrowserInfo.initUserAgent(c);
        String defJRProperty = DefaultJasperReportsContext.getInstance().getProperty("net.sf.jasperreports.compiler.classpath");
        PreferencesUtils.storeJasperReportsProperty("net.sf.jasperreports.compiler.classpath", Misc.nvl((String)defJRProperty));
        defJRProperty = DefaultJasperReportsContext.getInstance().getProperty("net.sf.jasperreports.compiler.temp.dir");
        PreferencesUtils.storeJasperReportsProperty("net.sf.jasperreports.compiler.temp.dir", Misc.nvl((String)defJRProperty));
        JaspersoftStudioPlugin.getExtensionManager();
        Job precacheImagesJob = new Job(Messages.JaspersoftStudioPlugin_CachingTemplateImagesJob){

            protected IStatus run(IProgressMonitor monitor) {
                ReportTemplatesWizardPage.templateImagesPreCache();
                return Status.OK_STATUS;
            }
        };
        precacheImagesJob.setPriority(30);
        precacheImagesJob.schedule();
        if (JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.jss.clean.jrprojects.markers")) {
            JDTUtils.deleteAllJRProjectMarkers();
        }
        if (JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.jss.console")) {
            Job installJSSConsoleJob = new Job(Messages.JaspersoftStudioPlugin_InstallingJSSConsoleJob){

                protected IStatus run(IProgressMonitor monitor) {
                    try {
                        JaspersoftStudioPlugin.installJSSConsole();
                        return Status.OK_STATUS;
                    }
                    catch (Exception e) {
                        return new Status(4, JaspersoftStudioPlugin.PLUGIN_ID, Messages.JaspersoftStudioPlugin_ConsoleInstallationError, (Throwable)e);
                    }
                }
            };
            installJSSConsoleJob.setPriority(20);
            installJSSConsoleJob.schedule();
        }
        this.getUsageManager().start();
        if (JaspersoftStudioPlugin.isRCP()) {
            JDTUtils.forceWorkspaceCompilerSettings((String)"1.6");
            try {
                IProject[] projects;
                IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                int n = projects.length;
                int n2 = 0;
                while (n2 < n) {
                    IProject prj = iProjectArray[n2];
                    if (ProjectUtil.isOpen((IProject)prj) && prj.hasNature("net.sf.jasperreports.nature")) {
                        JDTUtils.forceJRProjectCompilerSettings((IJavaProject)JavaCore.create((IProject)prj), (String)"1.6");
                    }
                    ++n2;
                }
            }
            catch (CoreException e) {
                this.logError(e);
            }
        }
    }

    public static ExtensionManager getExtensionManager() {
        if (extensionManager == null) {
            extensionManager = new ExtensionManager();
            extensionManager.init();
        }
        return extensionManager;
    }

    public static ComponentConverterManager getComponentConverterManager() {
        if (converterManager == null) {
            converterManager = new ComponentConverterManager();
            converterManager.init();
        }
        return converterManager;
    }

    public static DecoratorManager getDecoratorManager() {
        if (decoratorManager == null) {
            decoratorManager = new DecoratorManager();
            decoratorManager.init();
        }
        return decoratorManager;
    }

    public static EditorSettingsContributorManager getEditorSettingsManager() {
        if (editorSettingsManager == null) {
            editorSettingsManager = new EditorSettingsContributorManager();
            editorSettingsManager.init();
        }
        return editorSettingsManager;
    }

    public static DefaultDAManager getDefaultDAManager() {
        if (daManager == null) {
            daManager = new DefaultDAManager();
            daManager.init();
        }
        return daManager;
    }

    public static ToolItemsManager getToolItemsManager() {
        if (toolItemsManager == null) {
            toolItemsManager = new ToolItemsManager();
            toolItemsManager.init();
        }
        return toolItemsManager;
    }

    public static DriversManager getDriversManager() {
        DriversManager driversManager = new DriversManager();
        driversManager.init();
        return driversManager;
    }

    public static PostSetValueManager getPostSetValueManager() {
        if (postSetValueManager == null) {
            postSetValueManager = new PostSetValueManager();
            postSetValueManager.init();
        }
        return postSetValueManager;
    }

    public static PostDeleteManager getPostDeleteManager() {
        if (postDeleteManager == null) {
            postDeleteManager = new PostDeleteManager();
            postDeleteManager.init();
        }
        return postDeleteManager;
    }

    public static InputControlTypeManager getInputControlTypeManager() {
        if (inputControlTypeManager == null) {
            inputControlTypeManager = new InputControlTypeManager();
            inputControlTypeManager.init();
        }
        return inputControlTypeManager;
    }

    public String getPluginID() {
        return PLUGIN_ID;
    }

    public static String getUniqueIdentifier() {
        return PLUGIN_ID;
    }

    public void setBrandingInformation(BrandingInfo info) {
        this.getPreferenceStore().putValue("jssbranding_product_name", info.getProductName());
        this.getPreferenceStore().putValue("jssbranding_product_version", info.getProductVersion());
        this.getPreferenceStore().putValue("jssbranding_product_mainbundle", info.getProductMainBundleID());
    }

    public BrandingInfo getBrandingInformation() {
        BrandingInfo info = new BrandingInfo();
        info.setProductName(this.getPreferenceStore().getString("jssbranding_product_name"));
        info.setProductVersion(this.getPreferenceStore().getString("jssbranding_product_version"));
        info.setProductMainBundleID(this.getPreferenceStore().getString("jssbranding_product_mainbundle"));
        return info;
    }

    public static boolean shouldUseSecureStorage() {
        return JaspersoftStudioPlugin.getInstance().getPreferenceStore().getBoolean("com.jaspersoft.studio.secure.storage");
    }

    private static void installJSSConsole() {
        MessageConsole jssConsole = new MessageConsole(Messages.JaspersoftStudioPlugin_JSSConsoleTitle, null);
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{jssConsole});
        MessageConsoleStream consoleStream = jssConsole.newMessageStream();
        PrintStream pstream = new PrintStream((OutputStream)consoleStream);
        System.setOut(pstream);
        System.setErr(pstream);
    }

    public static boolean isRCP() {
        boolean isRCP;
        boolean bl = isRCP = Platform.getBundle((String)"com.jaspersoft.studio.rcp") != null;
        if (isRCP) {
            return true;
        }
        return Platform.getBundle((String)"com.jaspersoft.studio.pro.rcp") != null;
    }
}

