/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.background;

import com.jaspersoft.studio.background.MBackgrounImage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.property.descriptors.AbstractJSSCellEditorValidator;
import org.eclipse.swt.graphics.Point;

public class JSSBackgroundPixelLocationValidator
extends AbstractJSSCellEditorValidator {
    public String propertyID;

    public JSSBackgroundPixelLocationValidator(String propertyID) {
        this.propertyID = propertyID;
    }

    public String isValid(Object value) {
        try {
            if (value == null) {
                return Messages.JSSPixelEditorValidator_errorNull;
            }
            if (value instanceof String) {
                value = new Integer((String)value);
            }
            if (this.isSizeNegative(value, this.propertyID)) {
                return Messages.JSSPixelEditorValidator_errorNegative;
            }
        }
        catch (NumberFormatException numberFormatException) {
            return Messages.common_this_is_not_an_integer_number;
        }
        return null;
    }

    protected boolean isSizeNegative(Object value, Object propertyId) {
        int newWidth;
        int newHeight;
        return "background.image.height".equals(this.propertyID) ? (newHeight = ((Integer)value).intValue()) < 0 : "background.image.widht".equals(this.propertyID) && (newWidth = ((Integer)value).intValue()) < 0;
    }

    protected Object checkValid(ANode node, Object value, Object propertyID) {
        if (node == null) {
            return value;
        }
        if ("background.image.height".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MBackgrounImage background = (MBackgrounImage)node;
            int newHeight = (Integer)value;
            if (newHeight < 0) {
                return 0;
            }
            if (Math.abs(background.getDefaultY() + newHeight) > maximumSize.y) {
                int delta = maximumSize.y - background.getDefaultY();
                return delta;
            }
            return value;
        }
        if ("background.image.widht".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MBackgrounImage background = (MBackgrounImage)node;
            int newWidth = (Integer)value;
            if (newWidth < 0) {
                return 0;
            }
            if (Math.abs(background.getDefaultX() + newWidth) > maximumSize.x) {
                int delta = maximumSize.x - background.getDefaultX();
                return delta;
            }
            return value;
        }
        if ("background.image.x".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MBackgrounImage background = (MBackgrounImage)node;
            int newX = (Integer)value;
            if (Math.abs(background.getDefaultWidth() + newX) > maximumSize.x) {
                if (newX >= 0) {
                    if (Math.abs(background.getDefaultWidth()) + newX > maximumSize.x) {
                        int delta = maximumSize.x - background.getDefaultWidth();
                        return delta;
                    }
                } else if (Math.abs(newX) > maximumSize.x) {
                    int delta = -maximumSize.x;
                    return delta;
                }
            }
        } else if ("background.image.y".equals(propertyID)) {
            Point maximumSize = node.getAvailableSize();
            MBackgrounImage background = (MBackgrounImage)node;
            int newY = (Integer)value;
            if (Math.abs(background.getDefaultHeight() + newY) > maximumSize.y) {
                if (newY >= 0) {
                    if (Math.abs(background.getDefaultHeight()) + newY > maximumSize.y) {
                        int delta = maximumSize.y - background.getDefaultHeight();
                        return delta;
                    }
                } else if (Math.abs(newY) > maximumSize.y) {
                    int delta = -maximumSize.y;
                    return delta;
                }
            }
        }
        return value;
    }
}

