/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.backward;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.backward.wizard.JRRuntimeDialog;
import com.jaspersoft.studio.compatibility.JRXmlWriterHelper;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.util.FieldEditorOverlayPage;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.builder.JRDefinition;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;

public class JRVersionPreferencesPages
extends FieldEditorOverlayPage {
    public static final String PAGE_ID = "com.jaspersoft.studio.backward.JRVersionPreferencesPages.property";
    public static final String JSS_COMPATIBILITY_SHOW_DIALOG = "com.jaspersoft.studio.compatibility.showdialog";
    public static final String JSS_COMPATIBILITY_VERSION = "com.jaspersoft.studio.compatibility.version";
    public static final String JSS_TIMESTAMP_ONSAVE = "com.jaspersoft.studio.timestamp.onsave";
    public static final String LAST_VERSION = "last";
    public static final String JSS_COMPATIBILITY_COMPILER_OUTPUT = "com.jaspersoft.studio.jr.compile.output";
    private ComboFieldEditor cfeVersion;

    public JRVersionPreferencesPages() {
        super(1);
        this.setPreferenceStore(JaspersoftStudioPlugin.getInstance().getPreferenceStore());
    }

    public void init(IWorkbench workbench) {
    }

    @Override
    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        Composite cmp = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        cmp.setLayout((Layout)layout);
        cmp.setLayoutData((Object)new GridData(1808));
        this.createJRXML(cmp);
        this.createJASPER(cmp);
        super.createFieldEditors();
    }

    private void fillJasperVersions() {
        String[][] v = this.getJasperValues();
        try {
            Class<?> cver = this.cfeVersion.getClass().getSuperclass();
            Field f = cver.getDeclaredField("fEntryNamesAndValues");
            if (f != null) {
                Combo c;
                f.setAccessible(true);
                String[][] old = (String[][])f.get(this.cfeVersion);
                f.set(this.cfeVersion, v);
                f = this.cfeVersion.getClass().getSuperclass().getDeclaredField("fCombo");
                f.setAccessible(true);
                if (f != null && (c = (Combo)f.get(this.cfeVersion)) != null) {
                    String oldKey = null;
                    int indx = c.getSelectionIndex();
                    if (indx >= 0 && indx < old.length) {
                        oldKey = old[indx][1];
                    }
                    c.removeAll();
                    int i = 0;
                    while (i < v.length) {
                        c.add(v[i][0], i);
                        if (oldKey != null && v[i][1].equals(oldKey)) {
                            c.select(i);
                        }
                        ++i;
                    }
                    if (c.getSelectionIndex() < 0) {
                        c.select(1);
                    }
                }
            }
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchFieldException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }

    protected String[][] getJasperValues() {
        List<JRDefinition> jrs = JRRuntimeDialog.getJRDefinitions();
        String[][] v = new String[jrs.size() + 2][2];
        v[0] = new String[]{Messages.JRXmlWriterHelper_1, LAST_VERSION};
        String lv = JasperDesign.class.getPackage().getImplementationVersion();
        v[1] = new String[]{String.valueOf(lv) + Messages.JRVersionPreferencesPages_3, lv};
        int i = 2;
        for (JRDefinition jrd : jrs) {
            v[i][0] = jrd.getVersion();
            v[i][1] = jrd.getVersion();
            ++i;
        }
        return v;
    }

    protected void createJASPER(Composite parent) {
        Group gr = new Group(parent, 0);
        gr.setText(Messages.JRVersionPreferencesPages_4);
        gr.setLayoutData((Object)new GridData(768));
        gr.setBackgroundMode(2);
        this.cfeVersion = new ComboFieldEditor("com.jaspersoft.studio.jr.compile.version", Messages.StudioPreferencePage_versionLabel, this.getJasperValues(), (Composite)gr){

            protected void doStore() {
                String oldValue = this.getPreferenceStore().getString("com.jaspersoft.studio.jr.compile.version");
                super.doStore();
                String newValue = this.getPreferenceStore().getString("com.jaspersoft.studio.jr.compile.version");
                if (oldValue == null && newValue == null || oldValue != null && oldValue.equals(newValue)) {
                    return;
                }
                Job job = new Job("Cleaning project"){

                    protected IStatus run(IProgressMonitor monitor) {
                        monitor.beginTask("Cleaning project", -1);
                        IResource r = JRVersionPreferencesPages.this.getResource();
                        if (r instanceof IFile) {
                            r = r.getProject();
                        }
                        if (r instanceof IProject) {
                            this.buildProject((IProject)r, monitor);
                        } else {
                            IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
                            int n = iProjectArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                IProject p = iProjectArray[n2];
                                if (p.isOpen()) {
                                    this.buildProject(p, monitor);
                                }
                                ++n2;
                            }
                        }
                        return Status.OK_STATUS;
                    }

                    private void buildProject(IProject p, IProgressMonitor monitor) {
                        try {
                            p.build(15, monitor);
                            p.build(6, monitor);
                        }
                        catch (CoreException e) {
                            e.printStackTrace();
                        }
                    }
                };
                job.setUser(true);
                job.setPriority(40);
                job.schedule();
            }
        };
        this.addField((FieldEditor)this.cfeVersion);
        new Label((Composite)gr, 0);
        Link link = new Link((Composite)gr, 0);
        link.setBackground(gr.getBackground());
        link.setText(Messages.JRVersionPreferencesPages_5);
        link.setLayoutData((Object)new GridData(128));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JRRuntimeDialog d = new JRRuntimeDialog(UIUtils.getShell());
                if (d.open() == 0) {
                    JRVersionPreferencesPages.this.fillJasperVersions();
                }
            }
        });
        gr.setLayout((Layout)new GridLayout(2, false));
    }

    protected void createJRXML(Composite parent) {
        final Group gr = new Group(parent, 0);
        gr.setText(Messages.JRVersionPreferencesPages_6);
        gr.setLayoutData((Object)new GridData(768));
        this.addField((FieldEditor)new ComboFieldEditor(JSS_COMPATIBILITY_VERSION, Messages.StudioPreferencePage_versionLabel, JRXmlWriterHelper.getVersions(), (Composite)gr));
        this.addField((FieldEditor)new BooleanFieldEditor(JSS_COMPATIBILITY_SHOW_DIALOG, Messages.StudioPreferencePage_showCompDialog, (Composite)gr));
        Label label = new Label((Composite)gr, 64);
        label.setText(Messages.StudioPreferencePage_message1);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        label = new Label((Composite)gr, 64);
        label.setText(Messages.StudioPreferencePage_message2);
        gd = new GridData(768);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        Label separator = new Label((Composite)gr, 258);
        separator.setLayoutData((Object)new GridData(4, 4, true, false, 2, 1));
        this.addField((FieldEditor)new BooleanFieldEditor(JSS_TIMESTAMP_ONSAVE, Messages.StudioPreferencePage_TimestampOnSave, (Composite)gr));
        this.addField((FieldEditor)new BooleanFieldEditor("net.sf.jasperreports.jrxml.writer.exclude.properties.jss", Messages.StudioPreferencePage_1, (Composite)gr){
            private Properties props;

            protected void doStore() {
                boolean b = this.getBooleanValue();
                boolean exists = false;
                Properties newProps = new Properties();
                String pvalue = "com\\.jaspersoft\\.studio\\..*";
                for (Object item : this.props.keySet()) {
                    String key = (String)item;
                    String value = null;
                    if (!exists && key.equals(this.getPreferenceName())) {
                        if (!b) continue;
                        value = pvalue;
                        exists = true;
                    } else {
                        value = this.props.getProperty(key);
                    }
                    newProps.setProperty(key, value);
                }
                if (b && !exists) {
                    newProps.setProperty(this.getPreferenceName(), pvalue);
                }
                this.getPreferenceStore().setValue("net.sf.jasperreports.JRPROPERTIES", FileUtils.getPropertyAsString((Properties)newProps));
            }

            protected void doLoad() {
                Button checkBox = this.getChangeControl((Composite)gr);
                if (checkBox != null) {
                    try {
                        this.props = FileUtils.load((String)this.getPreferenceStore().getString("net.sf.jasperreports.JRPROPERTIES"));
                        String value = this.props.getProperty(this.getPreferenceName());
                        boolean b = !Misc.isNullOrEmpty((String)value);
                        checkBox.setSelection(b);
                        this.setWasSelected(b);
                    }
                    catch (IOException e) {
                        UIUtils.showError((Throwable)e);
                    }
                }
            }

            private void setWasSelected(boolean value) {
                try {
                    Field field = super.getClass().getSuperclass().getDeclaredField("wasSelected");
                    field.setAccessible(true);
                    field.setBoolean((Object)this, value);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchFieldException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }

            protected void doLoadDefault() {
                Button checkBox = this.getChangeControl((Composite)gr);
                if (checkBox != null) {
                    checkBox.setSelection(false);
                    this.setWasSelected(false);
                }
            }
        });
        gr.setLayout((Layout)new GridLayout(2, false));
    }

    public static void getDefaults(IPreferenceStore store) {
        store.setDefault(JSS_COMPATIBILITY_SHOW_DIALOG, "false");
        store.setDefault("com.jaspersoft.studio.jr.compile.version", "jrxml");
        store.setDefault(JSS_TIMESTAMP_ONSAVE, "false");
    }

    public String getPageId() {
        return PAGE_ID;
    }

    public static String fixCompatibilityVersion(JasperReportsContext jrContext) {
        Assert.isNotNull((Object)jrContext);
        String jssCompatibilityVersion = jrContext.getProperty(JSS_COMPATIBILITY_VERSION);
        if (jssCompatibilityVersion == null || LAST_VERSION.equals(jssCompatibilityVersion)) {
            jrContext.removeProperty("net.sf.jasperreports.report.version");
            return null;
        }
        jrContext.setProperty("net.sf.jasperreports.report.version", jssCompatibilityVersion);
        return jssCompatibilityVersion;
    }
}

