/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.callout.pin.command;

import com.jaspersoft.studio.callout.MCallout;
import com.jaspersoft.studio.callout.pin.MPin;
import com.jaspersoft.studio.callout.pin.MPinConnection;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.utils.SelectionHelper;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.gef.commands.Command;

public class CreatePinOnMouseLocationCommand
extends Command {
    private org.eclipse.swt.graphics.Point location = null;
    private MCallout parent;
    private MPin mpin;

    public CreatePinOnMouseLocationCommand(MCallout parent) {
        super("Create Pin");
        this.parent = parent;
    }

    public void execute() {
        if (this.mpin == null) {
            this.createObject();
        } else {
            this.parent.addPinConnection(this.mpin.getSourceConnections());
            this.mpin.setParent(this.parent, -1);
            this.parent.addChild(this.mpin.getSourceConnections());
        }
        this.parent.setPropertyValue("", "");
    }

    private void createObject() {
        if (this.location == null) {
            this.location = this.getPinLocation();
        }
        this.mpin = new MPin((ANode)this.parent, new Point(this.location.x, this.location.y));
        new MPinConnection(this.parent, this.mpin);
    }

    public void undo() {
        this.parent.removePinConnection(this.mpin.getSourceConnections());
        this.parent.removeChild(this.mpin);
        this.parent.removeChild(this.mpin.getSourceConnections());
        this.parent.setPropertyValue("", "");
    }

    public boolean canExecute() {
        return true;
    }

    protected org.eclipse.swt.graphics.Point getPinLocation() {
        org.eclipse.swt.graphics.Point location = new org.eclipse.swt.graphics.Point(0, 0);
        org.eclipse.swt.graphics.Point cursorPosition = SelectionHelper.getCursorRelativePositionOnClick(3);
        if (cursorPosition == null) {
            cursorPosition = SelectionHelper.getCursorCurrentRelativePosition();
        }
        if (cursorPosition != null) {
            location.x = cursorPosition.x;
            location.y = cursorPosition.y;
        } else {
            location.x = 20 + (Integer)this.parent.getPropertyValue("x");
            location.y = -24 + (Integer)this.parent.getPropertyValue("y");
        }
        return location;
    }
}

