/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.compatibility;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.compatibility.dialog.VersionDialog;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.io.IOException;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRConstants;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.lang.time.DateFormatUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class JRXmlWriterHelper {
    private static final Set<String> writers = new HashSet<String>();

    static {
        Field[] fieldArray = JRConstants.class.getFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field f = fieldArray[n2];
            if (f.getName().startsWith(Messages.JRXmlWriterHelper_0)) {
                try {
                    writers.add((String)f.get(null));
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        writers.add("5.1.0");
        writers.add("5.2.0");
        writers.add("5.5.1");
    }

    public static String[][] getVersions() {
        ArrayList<String> sl = new ArrayList<String>(writers);
        sl.sort((o1, o2) -> {
            if (o1 == null || o2 == null) {
                int o2null = o2 == null ? 0 : -1;
                return o1 == null ? o2null : 1;
            }
            String[] v1 = o1.split("\\.");
            String[] v2 = o2.split("\\.");
            int i = 0;
            while (i < Math.min(v1.length, v2.length)) {
                char c1 = v1[i].charAt(0);
                char c2 = v2[i].charAt(0);
                int cmp = 0;
                if (c1 >= '0' && c1 <= '9' && c2 >= '\u0000' && c2 <= '9') {
                    cmp = new BigInteger(v1[i]).compareTo(new BigInteger(v2[i]));
                }
                if (cmp == 0) {
                    cmp = v1[i].compareTo(v2[i]);
                }
                if (cmp != 0) {
                    return cmp;
                }
                ++i;
            }
            return v1.length - v2.length;
        });
        Collections.reverse(sl);
        String[][] r = new String[sl.size() + 1][2];
        r[0] = new String[]{Messages.JRXmlWriterHelper_1, "last"};
        int i = 1;
        for (String key : sl) {
            r[i][0] = "JasperReports " + key.replace('_', '.');
            if (i == 1) {
                String[] stringArray = r[i];
                stringArray[0] = String.valueOf(stringArray[0]) + Messages.JRXmlWriterHelper_4;
            }
            r[i][1] = key;
            ++i;
        }
        return r;
    }

    public static Set<String> getVersionsSet() {
        return writers;
    }

    public static String writeReport(JasperReportsConfiguration jrContext, JRReport report, IFile file, boolean showDialog) throws Exception {
        return JRXmlWriterHelper.writeReport((JasperReportsContext)jrContext, report, JRXmlWriterHelper.fixencoding("UTF-8"), JRXmlWriterHelper.getVersion((IResource)file, jrContext, showDialog));
    }

    public static String writeReport(JasperReportsContext jrContext, JRReport report, String version) throws Exception {
        return JRXmlWriterHelper.writeReport(jrContext, report, JRXmlWriterHelper.fixencoding("UTF-8"), version);
    }

    public static String writeReport(JasperReportsContext jrContext, JRReport report, String encoding, String version) throws Exception {
        if (report == null) {
            return null;
        }
        encoding = JRXmlWriterHelper.fixencoding(encoding);
        if (!writers.contains(version)) {
            version = "last";
        }
        boolean disposeContext = false;
        if (jrContext == null) {
            jrContext = JasperReportsConfiguration.getDefaultJRConfig();
            disposeContext = true;
        }
        jrContext.removeProperty("net.sf.jasperreports.report.version");
        if (writers.contains(version)) {
            jrContext.setProperty("net.sf.jasperreports.report.version", version);
        }
        String xml = null;
        try {
            xml = new JRXmlWriter(jrContext).write(report, encoding);
            String timestamp = "";
            if (jrContext instanceof JasperReportsConfiguration && ((JasperReportsConfiguration)((Object)jrContext)).getPropertyBoolean("com.jaspersoft.studio.timestamp.onsave", false).booleanValue()) {
                timestamp = "<!-- " + DateFormatUtils.ISO_DATETIME_FORMAT.format(new Date()) + " -->\n";
            }
            if (version.equals("last")) {
                version = JRXmlWriterHelper.getInstalledJasperReportsVersion();
            }
            String jssPluginVersion = JaspersoftStudioPlugin.getInstance().getBundle().getVersion().toString();
            String jrVersionTxt = String.valueOf(Messages.JRXmlWriterHelper_9) + version + " ";
            xml = xml.replaceFirst("<jasperReport ", "<!-- Created with Jaspersoft Studio version " + jssPluginVersion + jrVersionTxt + " -->\n" + timestamp + "<jasperReport ");
        }
        finally {
            if (disposeContext) {
                ((JasperReportsConfiguration)((Object)jrContext)).dispose();
            }
        }
        return xml;
    }

    public static String fixencoding(String encoding) {
        return "UTF-8";
    }

    public static String getVersion(IResource resource, JasperReportsConfiguration jContext, boolean showDialog) {
        VersionDialog dialog;
        String version = jContext.getProperty("com.jaspersoft.studio.compatibility.version", "last");
        if (showDialog && jContext.getPropertyBoolean("com.jaspersoft.studio.compatibility.showdialog", false).booleanValue() && (dialog = new VersionDialog(Display.getDefault().getActiveShell(), version, resource)).open() == 0) {
            version = dialog.getVersion();
            try {
                ScopedPreferenceStore pstore = JaspersoftStudioPlugin.getInstance().getPreferenceStore(resource, JaspersoftStudioPlugin.getUniqueIdentifier());
                pstore.setValue("com.jaspersoft.studio.compatibility.version", version);
                if (dialog.isHideNext()) {
                    pstore.putValue("com.jaspersoft.studio.compatibility.showdialog", Boolean.FALSE.toString());
                }
                pstore.save();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static String getInstalledJasperReportsVersion() {
        try {
            return JasperCompileManager.class.getPackage().getImplementationVersion();
        }
        catch (Throwable throwable) {
            return "last";
        }
    }

    public static boolean isCompatibleVersionGreater(JasperReportsConfiguration jconfig, String compareVersion, boolean equalToo) {
        Assert.isNotNull((Object)((Object)jconfig));
        Assert.isNotNull((Object)compareVersion);
        boolean verified = false;
        verified = equalToo ? JRXmlWriterHelper.getCompatibleVersion(jconfig).compareTo(compareVersion) >= 0 : JRXmlWriterHelper.getCompatibleVersion(jconfig).compareTo(compareVersion) > 0;
        return verified;
    }

    public static boolean isCompatibleVersionMinor(JasperReportsConfiguration jconfig, String compareVersion, boolean equalToo) {
        Assert.isNotNull((Object)((Object)jconfig));
        Assert.isNotNull((Object)compareVersion);
        boolean verified = false;
        verified = equalToo ? JRXmlWriterHelper.getCompatibleVersion(jconfig).compareTo(compareVersion) <= 0 : JRXmlWriterHelper.getCompatibleVersion(jconfig).compareTo(compareVersion) < 0;
        return verified;
    }

    public static boolean isCompatibleVersionEqual(JasperReportsConfiguration jconfig, String compareVersion) {
        Assert.isNotNull((Object)((Object)jconfig));
        Assert.isNotNull((Object)compareVersion);
        return JRXmlWriterHelper.getCompatibleVersion(jconfig).compareTo(compareVersion) == 0;
    }

    private static String getCompatibleVersion(JasperReportsConfiguration jconfig) {
        String ver = Misc.nvl((Object)jconfig.getProperty("com.jaspersoft.studio.compatibility.version"), (String)"last");
        if ("last".equals(ver)) {
            return JasperCompileManager.class.getPackage().getImplementationVersion();
        }
        return ver;
    }
}

