/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.compatibility;

import com.jaspersoft.studio.editor.JrxmlEditor;
import com.jaspersoft.studio.editor.gef.parts.PageEditPart;
import com.jaspersoft.studio.editor.report.AbstractVisualEditor;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.model.INode;
import com.jaspersoft.studio.model.MPage;
import com.jaspersoft.studio.utils.SelectionHelper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.gef.EditPart;
import org.eclipse.ui.IEditorPart;

public class ToolUtilitiesCompatibility {
    private static List<?> lastInput;
    private static List<?> lastOutput;

    public static List<?> getSelectionWithoutDependants(List<?> selectedParts) {
        if (selectedParts.isEmpty()) {
            return selectedParts;
        }
        if (selectedParts.equals(lastInput)) {
            return lastOutput;
        }
        lastInput = selectedParts;
        ArrayList result = new ArrayList();
        HashSet<ANode> models = new HashSet<ANode>();
        ANode pageModel = ToolUtilitiesCompatibility.getPageModel((ANode)((EditPart)selectedParts.get(0)).getModel());
        ToolUtilitiesCompatibility.removeSubeditorMainElement(selectedParts, pageModel);
        for (Object part : selectedParts) {
            models.add((ANode)((EditPart)part).getModel());
        }
        int i = 0;
        while (i < selectedParts.size()) {
            EditPart editpart = (EditPart)selectedParts.get(i);
            ANode model = (ANode)editpart.getModel();
            if (!ToolUtilitiesCompatibility.isAncestorContainedIn(models, model)) {
                result.add(editpart);
            }
            ++i;
        }
        lastOutput = result;
        return result;
    }

    public static EditPart getPageEditPart(EditPart node) {
        if (node == null) {
            return null;
        }
        EditPart parent = node.getParent();
        if (node instanceof PageEditPart) {
            return node;
        }
        return ToolUtilitiesCompatibility.getPageEditPart(parent);
    }

    public static ANode getPageModel(ANode node) {
        if (node == null) {
            return null;
        }
        ANode parent = node.getParent();
        if (parent instanceof MPage) {
            return parent;
        }
        return ToolUtilitiesCompatibility.getPageModel(parent);
    }

    private static void removeSubeditorMainElement(List<?> selectedParts, ANode page) {
        if (page == null) {
            return;
        }
        INode editedElement = page.getChildren().get(page.getChildren().size() - 1);
        for (Object part : selectedParts) {
            EditPart ePart = (EditPart)part;
            if (ePart.getModel() != editedElement) continue;
            selectedParts.remove(part);
            break;
        }
    }

    public static boolean isAncestorContainedIn(HashSet<ANode> c, ANode ep) {
        ep = ep.getParent();
        while (ep != null) {
            if (c.contains(ep)) {
                return true;
            }
            ep = ep.getParent();
        }
        return false;
    }

    public static boolean isSubeditorMainElement(EditPart part) {
        JrxmlEditor editor;
        IEditorPart editorPart = SelectionHelper.getActiveJRXMLEditor();
        if (editorPart instanceof JrxmlEditor && (editor = (JrxmlEditor)editorPart) != null && editor.getReportContainer().getActivePage() > 0 && editor.getReportContainer().getActiveEditor() instanceof AbstractVisualEditor) {
            AbstractVisualEditor visualEditor = (AbstractVisualEditor)editor.getReportContainer().getActiveEditor();
            INode managedNode = visualEditor.getManagedElement();
            return managedNode == part.getModel();
        }
        return false;
    }
}

