/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.custom.adapter.Pair;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.text.MessageFormat;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;

public class AdapterInfo {
    private static final String JAVA_SUFFIX = ".java";
    private static final String FACTORY_SUFFIX = "Factory";
    private static final String DESCRIPTOR_SUFFIX = "Descriptor";
    private static final String FIELDS_PROVIDER_SUFFIX = "FieldsProvider";
    private static final String EDITOR_SUFFIX = "Editor";
    private static final String WIZARD_EDITOR_COMPOSITE_SUFFIX = "WizardEditorComposite";
    private static final String COMPOSITE_SUFFIX = "Composite";
    private static final String IMAGE_EXPRESSION = "Activator.getDefault().getImage(\"images/{0}\")";
    private String projectName;
    private String adapterName;
    private String adapterDescription;
    private String packageName;
    private String iconName;
    private ImageData iconData;
    private String classNamePrefix;
    private String pluginId;
    private Pair dataAdapterInterface;
    private Pair dataAdapterImplementation;
    private Pair dataAdapterService;
    private Pair dataAdapterServiceFactory;

    public AdapterInfo(String projectName, String adapterName, String adapterDescription, String packageName, String iconPath) {
        this.projectName = projectName;
        this.adapterDescription = adapterDescription;
        this.adapterName = adapterName;
        this.packageName = packageName;
        this.loadImage(iconPath);
        this.classNamePrefix = AdapterInfo.toCamelCase(adapterName).replaceAll(" ", "");
        this.pluginId = String.valueOf(packageName) + "." + this.classNamePrefix;
    }

    private void loadImage(String fullPath) {
        File imageFile;
        if (fullPath != null && (imageFile = new File(fullPath)).exists()) {
            try {
                FileInputStream stream = new FileInputStream(imageFile);
                Image loadedImage = new Image(null, (InputStream)stream);
                this.iconName = imageFile.getName();
                this.iconData = loadedImage.getImageData();
                loadedImage.dispose();
                return;
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        this.iconName = "no_image.png";
        this.iconData = JaspersoftStudioPlugin.getInstance().getImage("icons/resources/image-missing.png").getImageData();
    }

    public static String getIconImage(String imageName) {
        return MessageFormat.format(IMAGE_EXPRESSION, imageName);
    }

    public String getFactoryClassName() {
        return String.valueOf(this.classNamePrefix) + FACTORY_SUFFIX;
    }

    public String getFactoryFileName() {
        return String.valueOf(this.getFactoryClassName()) + JAVA_SUFFIX;
    }

    public String getFactoryOnPluginName() {
        return String.valueOf(this.packageName) + "." + this.getFactoryClassName();
    }

    public String getDescriptorClassName() {
        return String.valueOf(this.classNamePrefix) + DESCRIPTOR_SUFFIX;
    }

    public String getDescriptorFileName() {
        return String.valueOf(this.getDescriptorClassName()) + JAVA_SUFFIX;
    }

    public String getFieldsProviderClassName() {
        return String.valueOf(this.classNamePrefix) + FIELDS_PROVIDER_SUFFIX;
    }

    public String getFieldsProviderFileName() {
        return String.valueOf(this.getFieldsProviderClassName()) + JAVA_SUFFIX;
    }

    public String getEditorClassName() {
        return String.valueOf(this.classNamePrefix) + EDITOR_SUFFIX;
    }

    public String getEditorFileName() {
        return String.valueOf(this.getEditorClassName()) + JAVA_SUFFIX;
    }

    public String getWizardEditorCompositeClassName() {
        return String.valueOf(this.classNamePrefix) + WIZARD_EDITOR_COMPOSITE_SUFFIX;
    }

    public String getWizardEditorCompositeFileName() {
        return String.valueOf(this.getWizardEditorCompositeClassName()) + JAVA_SUFFIX;
    }

    public String getCompositeClassName() {
        return String.valueOf(this.classNamePrefix) + COMPOSITE_SUFFIX;
    }

    public String getCompositeFileName() {
        return String.valueOf(this.getCompositeClassName()) + JAVA_SUFFIX;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getAdapterName() {
        return this.adapterName;
    }

    public String getAdapterDescription() {
        return this.adapterDescription;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getIconName() {
        return this.iconName;
    }

    public ImageData getIconData() {
        return this.iconData;
    }

    public String getPluginId() {
        return this.pluginId;
    }

    public static String getActivatorClassName() {
        return "Activator.java";
    }

    public static String getPluginName() {
        return "plugin.xml";
    }

    public Pair getDataAdapterInterface() {
        return this.dataAdapterInterface;
    }

    public void setDataAdapterInterface(Pair dataAdapterInterface) {
        this.dataAdapterInterface = dataAdapterInterface;
    }

    public Pair getDataAdapterImplementation() {
        return this.dataAdapterImplementation;
    }

    public void setDataAdapterImplementation(Pair dataAdapterImplementation) {
        this.dataAdapterImplementation = dataAdapterImplementation;
    }

    public Pair getDataAdapterService() {
        return this.dataAdapterService;
    }

    public void setDataAdapterService(Pair dataAdapterService) {
        this.dataAdapterService = dataAdapterService;
    }

    public Pair getDataAdapterServiceFactory() {
        return this.dataAdapterServiceFactory;
    }

    public void setDataAdapterServiceFactory(Pair dataAdapterServiceFactory) {
        this.dataAdapterServiceFactory = dataAdapterServiceFactory;
    }

    private static String toCamelCase(String s) {
        String[] parts = s.split(" ");
        String camelCaseString = "";
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            camelCaseString = part != null && part.trim().length() > 0 ? String.valueOf(camelCaseString) + AdapterInfo.toProperCase(part) : String.valueOf(camelCaseString) + part + " ";
            ++n2;
        }
        return camelCaseString;
    }

    private static String toProperCase(String s) {
        String temp = s.trim();
        String spaces = "";
        if (temp.length() != s.length()) {
            char startCharIndex = s.charAt(temp.indexOf(0));
            spaces = s.substring(0, startCharIndex);
        }
        temp = String.valueOf(temp.substring(0, 1).toUpperCase()) + spaces + temp.substring(1).toLowerCase() + " ";
        return temp;
    }
}

