/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.controls;

import com.jaspersoft.studio.custom.adapter.controls.CollectionInputDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class PropertyListControl
extends Composite {
    private String elementsType;
    private Text listContent;
    private List<Object> values = new ArrayList<Object>();
    private List<ModifyListener> modifyListeners = new ArrayList<ModifyListener>();

    public PropertyListControl(Composite parent, String elementsType) {
        super(parent, 0);
        this.elementsType = elementsType;
        this.setLayout((Layout)new GridLayout(2, false));
        this.listContent = new Text((Composite)this, 2048);
        this.listContent.setLayoutData((Object)new GridData(768));
        this.listContent.setEditable(false);
        Button browse = new Button((Composite)this, 8);
        browse.setText("...");
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CollectionInputDialog dialog = new CollectionInputDialog(PropertyListControl.this.getShell(), PropertyListControl.this.values, PropertyListControl.this.elementsType);
                if (dialog.open() == 0) {
                    PropertyListControl.this.values = dialog.getValues();
                    PropertyListControl.this.callSelectionListeners();
                }
            }
        });
    }

    public void setSelection(List<Object> values) {
        this.values = values;
        String collection = "[";
        int size = values.size();
        int index = 0;
        for (Object value : values) {
            collection = String.valueOf(collection) + value.toString();
            if (++index >= size) continue;
            collection = String.valueOf(collection) + " , ";
        }
        collection = String.valueOf(collection) + "]";
        this.listContent.setText(collection);
    }

    public String[] getSelection() {
        String[] result = new String[this.values.size()];
        int index = 0;
        for (Object value : this.values) {
            result[index] = value.toString();
            ++index;
        }
        return result;
    }

    public void addModifyListener(ModifyListener listener) {
        this.modifyListeners.add(listener);
    }

    private void callSelectionListeners() {
        Event event = new Event();
        event.doit = true;
        event.widget = this;
        event.data = this.values;
        for (ModifyListener listener : this.modifyListeners) {
            listener.modifyText(new ModifyEvent(event));
        }
    }
}

