/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.export;

import com.jaspersoft.studio.custom.adapter.export.ExportAdapterWizardPage;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.translation.JarFileUtils;
import com.jaspersoft.studio.wizards.JSSWizard;
import java.io.File;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.internal.ide.actions.BuildUtilities;

public class ExportAdapterWizard
extends JSSWizard
implements IExportWizard {
    protected IStructuredSelection fSelection;
    private ExportAdapterWizardPage fPage;
    private static final String STORE_SECTION = "AdapterExportWizard";

    public ExportAdapterWizard(IWorkbench workbench, IStructuredSelection selection) {
        this.init(workbench, selection);
    }

    protected ExportAdapterWizardPage createPage1() {
        this.fPage = new ExportAdapterWizardPage(this.getSelection());
        return this.fPage;
    }

    @Override
    public void addPages() {
        this.fPage = this.createPage1();
        this.addPage((IWizardPage)this.fPage);
    }

    protected String getSettingsSectionName() {
        return STORE_SECTION;
    }

    public IStructuredSelection getSelection() {
        return this.fSelection;
    }

    public IDialogSettings getSettingsSection(IDialogSettings master) {
        String name = this.getSettingsSectionName();
        IDialogSettings settings = master.getSection(name);
        if (settings == null) {
            settings = master.addNewSection(name);
        }
        return settings;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public static String generateQualifier() {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmm");
        Date date = new Date();
        return dateFormat.format(date);
    }

    private String getErrorMessage(List<String> singleErrors) {
        String message = Messages.ExportAdapterWizard_projectErrors;
        for (String error : singleErrors) {
            message = String.valueOf(message) + error + "\n";
        }
        return message;
    }

    private String getSuccessMessage(List<String> singleSuccesses) {
        String message = Messages.ExportAdapterWizard_projectSucceses;
        for (String success : singleSuccesses) {
            message = String.valueOf(message) + success + "\n";
        }
        return message;
    }

    @Override
    public boolean canFinish() {
        return this.fPage.getSelectedItems().size() > 0 && this.fPage.getDestination().trim().length() > 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean buildProject(IProject project) {
        try {
            ArrayList<IProject> projects = new ArrayList<IProject>();
            projects.add(project);
            BuildUtilities.saveEditors(projects);
            ArrayList<IBuildConfiguration> buildConfiguration = new ArrayList<IBuildConfiguration>();
            buildConfiguration.add(project.getActiveBuildConfig());
            IBuildConfiguration[] configs = buildConfiguration.toArray(new IBuildConfiguration[buildConfiguration.size()]);
            ResourcesPlugin.getWorkspace().build(configs, 6, true, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e1) {
            e1.printStackTrace();
            return false;
        }
        try {
            IMarker[] markers;
            IMarker[] iMarkerArray = markers = project.findMarkers("org.eclipse.jdt.core.problem", true, 2);
            int n = markers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return true;
                }
                IMarker marker = iMarkerArray[n2];
                int severity = marker.getAttribute("severity", Integer.MAX_VALUE);
                if (severity == 2) {
                    return false;
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return true;
    }

    @Override
    public boolean performFinish() {
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        File workspaceDirectory = workspace.getRoot().getLocation().toFile();
        ArrayList<String> successfullyExported = new ArrayList<String>();
        ArrayList<String> notExported = new ArrayList<String>();
        for (IProject project : this.fPage.getSelectedItems()) {
            try {
                File sourceFile = new File(workspaceDirectory, project.getFullPath().toOSString());
                Properties prop = new Properties();
                prop.load(project.getFolder("META-INF").getFile("MANIFEST.MF").getContents());
                File manifestFile = new File(sourceFile, "META-INF");
                manifestFile = new File(manifestFile, "MANIFEST.MF");
                String manifestContent = JarFileUtils.deserializeString(manifestFile);
                String version = "_" + prop.getProperty("Bundle-Version").replace("qualifier", ExportAdapterWizard.generateQualifier());
                String fileName = String.valueOf(prop.getProperty("Bundle-SymbolicName").split(";")[0]) + version + ".jar";
                File destinationFile = new File(this.fPage.getDestination(), fileName);
                if (destinationFile.exists()) {
                    destinationFile.delete();
                }
                project.build(15, (IProgressMonitor)new NullProgressMonitor());
                boolean compilationSuccess = this.buildProject(project);
                if (compilationSuccess) {
                    JarFileUtils.createPluginJar(this.fPage.getDestination(), sourceFile, fileName, manifestContent);
                    successfullyExported.add(MessageFormat.format(Messages.ExportAdapterWizard_projectSuccess, project.getName(), new File(this.fPage.getDestination(), fileName).toString()));
                    continue;
                }
                notExported.add(MessageFormat.format(Messages.ExportAdapterWizard_projectError, project.getName()));
            }
            catch (Exception e) {
                notExported.add(MessageFormat.format(Messages.ExportAdapterWizard_projectError, project.getName()));
                e.printStackTrace();
            }
        }
        if (successfullyExported.isEmpty()) {
            MessageDialog.openError((Shell)UIUtils.getShell(), (String)Messages.ExportAdapterWizard_allError, (String)this.getErrorMessage(notExported));
        } else if (notExported.size() == 0) {
            MessageDialog.openInformation((Shell)UIUtils.getShell(), (String)Messages.ExportAdapterWizard_allSuccess, (String)this.getSuccessMessage(successfullyExported));
        } else {
            MessageDialog.openWarning((Shell)UIUtils.getShell(), (String)Messages.ExportAdapterWizard_someErrors, (String)(String.valueOf(this.getSuccessMessage(successfullyExported)) + "\n" + this.getErrorMessage(notExported)));
        }
        return true;
    }
}

