/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.export;

import com.jaspersoft.studio.messages.Messages;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ExportAdapterWizardPage
extends WizardPage {
    private Object[] fSelection;
    protected TabFolder fTabFolder;
    private HashSet<IProject> selectedElements = new HashSet();
    private String destination = "";

    public ExportAdapterWizardPage(IStructuredSelection selection) {
        super("aaaa");
        this.fSelection = selection.toArray();
        this.setTitle(Messages.ExportAdapterWizardPage_title);
        this.setDescription(Messages.ExportAdapterWizardPage_description);
    }

    public Object[] getListElements() {
        Object[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        return projects;
    }

    public Collection<IProject> getSelectedItems() {
        return this.selectedElements;
    }

    public String getDestination() {
        return this.destination;
    }

    private void chooseDestination(Text combo) {
        DirectoryDialog dialog = new DirectoryDialog(this.getShell(), 8192);
        String path = combo.getText();
        if (path.trim().length() == 0) {
            path = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        }
        dialog.setFilterPath(path);
        dialog.setText(Messages.ExportAdapterWizardPage_title);
        dialog.setMessage("Select a destination directory for the export operation");
        String res = dialog.open();
        if (res != null) {
            combo.setText(res);
        }
    }

    protected void validate() {
        if (this.selectedElements.size() == 0) {
            this.setErrorMessage("No items selected");
            this.setPageComplete(false);
        } else if (this.destination.trim().length() == 0) {
            this.setErrorMessage("Destination directory must be specified");
            this.setPageComplete(false);
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        new Label(container, 0).setText("Available Plug-Ins:");
        Composite plugins = new Composite(container, 0);
        plugins.setLayoutData((Object)new GridData(1808));
        plugins.setBackground(ColorConstants.white);
        plugins.setLayout((Layout)new GridLayout(2, false));
        Object[] objectArray = this.fSelection;
        int n = this.fSelection.length;
        int n2 = 0;
        while (n2 < n) {
            final Object selection = objectArray[n2];
            if (selection instanceof IProject) {
                try {
                    IProject project = (IProject)selection;
                    Properties prop = new Properties();
                    prop.load(project.getFolder("META-INF").getFile("MANIFEST.MF").getContents());
                    Button checkBox = new Button(plugins, 32);
                    checkBox.setSelection(this.selectedElements.contains(selection));
                    checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            if (ExportAdapterWizardPage.this.selectedElements.contains(selection)) {
                                ExportAdapterWizardPage.this.selectedElements.remove(selection);
                            } else {
                                ExportAdapterWizardPage.this.selectedElements.add((IProject)selection);
                            }
                            ExportAdapterWizardPage.this.validate();
                        }
                    });
                    String name = String.valueOf(prop.getProperty("Bundle-SymbolicName").split(";")[0]) + " (" + prop.getProperty("Bundle-Version") + ")";
                    new Label(plugins, 0).setText(name);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            ++n2;
        }
        this.fTabFolder = new TabFolder(container, 0);
        this.fTabFolder.setLayoutData((Object)new GridData(768));
        TabItem destinationTab = new TabItem(this.fTabFolder, 0);
        destinationTab.setText("Destination");
        Composite tabContent = new Composite((Composite)this.fTabFolder, 0);
        tabContent.setLayout((Layout)new GridLayout(2, false));
        final Text destinationText = new Text(tabContent, 2048);
        destinationText.setLayoutData((Object)new GridData(768));
        Button browseButton = new Button(tabContent, 8);
        browseButton.setText(Messages.common_browse);
        browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExportAdapterWizardPage.this.chooseDestination(destinationText);
            }
        });
        destinationText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExportAdapterWizardPage.this.destination = ((Text)e.widget).getText();
                ExportAdapterWizardPage.this.validate();
            }
        });
        destinationTab.setControl((Control)tabContent);
        this.setControl((Control)container);
        this.validate();
    }
}

