/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.custom.adapter.wizard;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.custom.adapter.AdapterInfo;
import com.jaspersoft.studio.custom.adapter.DynamicCompositeHelper;
import com.jaspersoft.studio.custom.adapter.Pair;
import com.jaspersoft.studio.custom.adapter.PluginHelper;
import com.jaspersoft.studio.custom.adapter.wizard.AdditionalJarsPage;
import com.jaspersoft.studio.custom.adapter.wizard.CustomJarInformationPage;
import com.jaspersoft.studio.custom.adapter.wizard.DataAdapterInformationPage;
import com.jaspersoft.studio.utils.ImageUtils;
import com.jaspersoft.studio.utils.VelocityUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.builder.jdt.JDTUtils;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Button;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class NewDataAdapterWizard
extends Wizard
implements INewWizard {
    private static final String TEMPLATES_LOCATION_PREFIX = "com/jaspersoft/studio/custom/adapter/resources/";
    private static final String ACTIVATOR_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Activator.vm";
    private static final String FACTORY_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Factory.vm";
    private static final String DESCRIPTOR_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Descriptor.vm";
    private static final String EDITOR_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Editor.vm";
    private static final String COMPOSITE_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Composite.vm";
    private static final String EMPTY_COMPOSITE_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/EmptyComposite.vm";
    private static final String PROVIDER_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/FieldsProvider.vm";
    private static final String WIZARD_EDITOR_CLASS_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/WizardEditor.vm";
    private static final String PLUGIN_TEMPLATE_LOCATION = "com/jaspersoft/studio/custom/adapter/resources/Plugin.vm";
    private static final String LIB_LOCATION = "/resources/lib/DummyDataAdapter.jar";
    private static final String DATA_ADAPTER_TYPE = "DummyDataAdapter";
    private static final String DATA_ADAPTER_IMPL_TYPE = "DummyDataAdapterImpl";
    private static final String DATA_ADAPTER_SERVICE_TYPE = "DummyDataAdapterService";
    private static final String DATA_ADAPTER_SERVICE_FACTORY_TYPE = "DummyDataAdapterServiceFactory";
    private static final String DATA_ADAPTER_PACKAGE = "com.jaspersoft.adapter.*";
    private DataAdapterInformationPage page1;
    private CustomJarInformationPage page2;
    private AdditionalJarsPage page3;
    private VelocityEngine ve = VelocityUtils.getConfiguredVelocityEngine();

    public NewDataAdapterWizard() {
        this.setWindowTitle("New Data Adapter Wizard");
        this.setNeedsProgressMonitor(true);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.page1 = new DataAdapterInformationPage();
        this.page1.setWizard((IWizard)this);
        this.page2 = new CustomJarInformationPage();
        this.page2.setWizard((IWizard)this);
        this.page3 = new AdditionalJarsPage();
        this.addPage((IWizardPage)this.page1);
        this.addPage((IWizardPage)this.page2);
        this.addPage((IWizardPage)this.page3);
    }

    private String getImportStrings(List<String> packagesName) {
        HashSet<String> generatedPackages = new HashSet<String>();
        String result = "";
        for (String packageName : packagesName) {
            String newPackage = "import " + packageName;
            newPackage = packageName.endsWith(".*") ? String.valueOf(newPackage) + ";" : String.valueOf(newPackage) + ".*;";
            if (generatedPackages.contains(newPackage)) continue;
            result = String.valueOf(result) + newPackage + "\n";
            generatedPackages.add(newPackage);
        }
        return result;
    }

    private String getActivatorClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("pluginId", (Object)adapterInfo.getPluginId());
        Template functionTemplate = this.ve.getTemplate(ACTIVATOR_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getFactoryClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("factoryName", (Object)adapterInfo.getFactoryClassName());
        functionContext.put("descriptorName", (Object)adapterInfo.getDescriptorClassName());
        functionContext.put("dataAdapterFamiliarName", (Object)adapterInfo.getAdapterName());
        functionContext.put("dataAdapterDescription", (Object)adapterInfo.getAdapterDescription());
        functionContext.put("image", (Object)AdapterInfo.getIconImage(adapterInfo.getIconName()));
        functionContext.put("isCustomJar", (Object)String.valueOf(this.page1.isUsingCustomJar()).toLowerCase());
        ArrayList<String> requiredAdapterPackages = new ArrayList<String>();
        functionContext.put("dataAdapterType", (Object)adapterInfo.getDataAdapterInterface().getClassName());
        requiredAdapterPackages.add(adapterInfo.getDataAdapterInterface().getPackageName());
        functionContext.put("dataAdapterImplType", (Object)adapterInfo.getDataAdapterImplementation().getClassName());
        requiredAdapterPackages.add(adapterInfo.getDataAdapterImplementation().getPackageName());
        functionContext.put("dataAdapterService", (Object)adapterInfo.getDataAdapterService().getClassName());
        requiredAdapterPackages.add(adapterInfo.getDataAdapterService().getPackageName());
        functionContext.put("additionalImports", (Object)this.getImportStrings(requiredAdapterPackages));
        Template functionTemplate = this.ve.getTemplate(FACTORY_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getDescriptorClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("descriptorName", (Object)adapterInfo.getDescriptorClassName());
        functionContext.put("dataAdapterEditor", (Object)adapterInfo.getEditorClassName());
        functionContext.put("dataAdapterFieldsProvider", (Object)adapterInfo.getFieldsProviderClassName());
        functionContext.put("dataAdapterWizardEditorComposite", (Object)adapterInfo.getWizardEditorCompositeClassName());
        functionContext.put("image", (Object)AdapterInfo.getIconImage(adapterInfo.getIconName()));
        ArrayList<String> requiredAdapterPackages = new ArrayList<String>();
        functionContext.put("dataAdapterType", (Object)adapterInfo.getDataAdapterInterface().getClassName());
        requiredAdapterPackages.add(adapterInfo.getDataAdapterInterface().getPackageName());
        functionContext.put("dataAdapterImplType", (Object)adapterInfo.getDataAdapterImplementation().getClassName());
        requiredAdapterPackages.add(adapterInfo.getDataAdapterImplementation().getPackageName());
        functionContext.put("additionalImports", (Object)this.getImportStrings(requiredAdapterPackages));
        Template functionTemplate = this.ve.getTemplate(DESCRIPTOR_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getEditorClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("dataAdapterEditor", (Object)adapterInfo.getEditorClassName());
        functionContext.put("adapterComposite", (Object)adapterInfo.getCompositeClassName());
        functionContext.put("descriptorName", (Object)adapterInfo.getDescriptorClassName());
        Template functionTemplate = this.ve.getTemplate(EDITOR_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getCompositeClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("adapterComposite", (Object)adapterInfo.getCompositeClassName());
        functionContext.put("descriptorName", (Object)adapterInfo.getDescriptorClassName());
        StringWriter fsw = new StringWriter();
        if (this.page1.isUsingCustomJar()) {
            if (this.page2.createDynamicControls()) {
                DynamicCompositeHelper compositeBuilder = new DynamicCompositeHelper(new File(this.page2.getJarPath()), adapterInfo);
                return compositeBuilder.getCompositeClass();
            }
            functionContext.put("dynamicControls", (Object)String.valueOf(this.page2.createDynamicControls()).toLowerCase());
            Template functionTemplate = this.ve.getTemplate(EMPTY_COMPOSITE_CLASS_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        } else {
            functionContext.put("dataAdapterType", (Object)adapterInfo.getDataAdapterInterface().getClassName());
            ArrayList<String> requiredAdapterPackages = new ArrayList<String>();
            requiredAdapterPackages.add(adapterInfo.getDataAdapterInterface().getPackageName());
            functionContext.put("additionalImports", (Object)this.getImportStrings(requiredAdapterPackages));
            Template functionTemplate = this.ve.getTemplate(COMPOSITE_CLASS_TEMPLATE_LOCATION);
            functionTemplate.merge((Context)functionContext, (Writer)fsw);
        }
        return fsw.toString();
    }

    private String getFieldsProviderClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("dataAdapterFieldsProvider", (Object)adapterInfo.getFieldsProviderClassName());
        Template functionTemplate = this.ve.getTemplate(PROVIDER_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getWizardEditorClass(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("packageName", (Object)adapterInfo.getPackageName());
        functionContext.put("dataAdapterWizardEditorComposite", (Object)adapterInfo.getWizardEditorCompositeClassName());
        functionContext.put("image", (Object)AdapterInfo.getIconImage(adapterInfo.getIconName()));
        Template functionTemplate = this.ve.getTemplate(WIZARD_EDITOR_CLASS_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private String getPlugin(AdapterInfo adapterInfo) {
        VelocityContext functionContext = new VelocityContext();
        functionContext.put("adapterFactory", (Object)adapterInfo.getFactoryOnPluginName());
        Template functionTemplate = this.ve.getTemplate(PLUGIN_TEMPLATE_LOCATION);
        StringWriter fsw = new StringWriter();
        functionTemplate.merge((Context)functionContext, (Writer)fsw);
        return fsw.toString();
    }

    private void saveImageIntoProject(AdapterInfo adapterInfo, IProject project, IProgressMonitor monitor) {
        if (adapterInfo.getIconData() != null && adapterInfo.getIconName() != null) {
            int scaleFactor;
            ImageData imgData = adapterInfo.getIconData();
            Image loadedImage = null;
            int width = imgData.width;
            int height = imgData.height;
            if (width > 16) {
                scaleFactor = width / 16;
                width /= scaleFactor;
                height /= scaleFactor;
            }
            if (height > 16) {
                scaleFactor = height / 16;
                width /= scaleFactor;
                height /= scaleFactor;
            }
            if (width != imgData.width || height != imgData.height) {
                Image biggerImage = new Image(null, imgData);
                loadedImage = ImageUtils.resize(biggerImage, width, height);
                biggerImage.dispose();
            } else {
                loadedImage = new Image(null, imgData);
            }
            try {
                File tmpDir = FileUtils.createTempDir();
                File tempImage = new File(tmpDir, adapterInfo.getIconName());
                if (tempImage.exists()) {
                    tempImage.delete();
                }
                ImageLoader loader = new ImageLoader();
                loader.data = new ImageData[]{loadedImage.getImageData()};
                loader.save(tempImage.getAbsolutePath(), this.getImageFormatFromExtension(FilenameUtils.getExtension((String)tempImage.getName())));
                BufferedInputStream pin = new BufferedInputStream(new FileInputStream(tempImage.getAbsolutePath()));
                PluginHelper.createFile(adapterInfo.getIconName(), (IContainer)project.getFolder("images"), pin, monitor);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            loadedImage.dispose();
        }
    }

    private int getImageFormatFromExtension(String extension) {
        if (extension.equals("jpeg") || extension.equals("jpg")) {
            return 4;
        }
        if (extension.equals("bmp")) {
            return 0;
        }
        if (extension.equals("gif")) {
            return 2;
        }
        if (extension.equals("png")) {
            return 5;
        }
        if (extension.equals("ico")) {
            return 3;
        }
        return 4;
    }

    private IFolder getSourceFolder(String packageName, IProject project) {
        IFolder src = project.getFolder("src");
        try {
            String[] packageFragments;
            if (!src.exists()) {
                src.create(true, true, (IProgressMonitor)new NullProgressMonitor());
            }
            String[] stringArray = packageFragments = packageName.split("\\.");
            int n = packageFragments.length;
            int n2 = 0;
            while (n2 < n) {
                String packageFragment = stringArray[n2];
                if (!(src = src.getFolder(packageFragment)).exists()) {
                    src.create(true, true, (IProgressMonitor)new NullProgressMonitor());
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return src;
    }

    private void setDummyAdapterData(AdapterInfo info) {
        info.setDataAdapterInterface(new Pair(DATA_ADAPTER_PACKAGE, DATA_ADAPTER_TYPE));
        info.setDataAdapterImplementation(new Pair(DATA_ADAPTER_PACKAGE, DATA_ADAPTER_IMPL_TYPE));
        info.setDataAdapterService(new Pair(DATA_ADAPTER_PACKAGE, DATA_ADAPTER_SERVICE_TYPE));
        info.setDataAdapterServiceFactory(new Pair(DATA_ADAPTER_PACKAGE, DATA_ADAPTER_SERVICE_FACTORY_TYPE));
    }

    private Button getButton(String fieldName, WizardDialog container) {
        try {
            Field field = WizardDialog.class.getDeclaredField(fieldName);
            field.setAccessible(true);
            Button button = (Button)field.get(container);
            return button;
        }
        catch (Throwable e) {
            String errorMessage = "Error getting button {0} on the custom adapter dialog";
            JaspersoftStudioPlugin.getInstance().logError(MessageFormat.format(errorMessage, fieldName), e);
            return null;
        }
    }

    private void disableButtons() {
        if (this.getContainer() instanceof WizardDialog) {
            WizardDialog container = (WizardDialog)this.getContainer();
            Button currentButton = this.getButton("finishButton", container);
            if (currentButton != null) {
                currentButton.setEnabled(false);
            }
            if ((currentButton = this.getButton("backButton", container)) != null) {
                currentButton.setEnabled(false);
            }
            if ((currentButton = this.getButton("nextButton", container)) != null) {
                currentButton.setEnabled(false);
            }
            if ((currentButton = this.getButton("cancelButton", container)) != null) {
                currentButton.setEnabled(false);
            }
        }
    }

    public boolean performFinish() {
        this.disableButtons();
        NullProgressMonitor monitor = new NullProgressMonitor();
        monitor.setTaskName("Crating project");
        try {
            ArrayList<String> src = new ArrayList<String>();
            src.add("src");
            ArrayList<String> requiredBundles = new ArrayList<String>();
            requiredBundles.add("org.eclipse.ui");
            requiredBundles.add("org.eclipse.core.runtime");
            requiredBundles.add("com.jaspersoft.studio.data");
            requiredBundles.add("com.jaspersoft.studio.components");
            AdapterInfo info = this.page1.getAdapterInfo();
            ArrayList<File> libFiles = new ArrayList<File>();
            if (this.page1.isUsingCustomJar()) {
                libFiles.add(new File(this.page2.getJarPath()));
                this.page2.setCustomAdapterInfo(info);
                List<String> additionalJars = this.page3.getValues();
                for (String jarPath : additionalJars) {
                    libFiles.add(new File(jarPath));
                }
            } else {
                libFiles.add(new File(JaspersoftStudioPlugin.getInstance().getFileLocation(LIB_LOCATION)));
                this.setDummyAdapterData(info);
            }
            IProject pluginProject = PluginHelper.createPluginProject(info, src, requiredBundles, libFiles, (IProgressMonitor)monitor);
            if (pluginProject != null) {
                PluginHelper.createFile(AdapterInfo.getActivatorClassName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getActivatorClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(info.getFactoryFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getFactoryClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(info.getDescriptorFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getDescriptorClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(info.getEditorFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getEditorClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(info.getFieldsProviderFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getFieldsProviderClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(info.getWizardEditorCompositeFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getWizardEditorClass(info), (IProgressMonitor)monitor);
                PluginHelper.createFile(AdapterInfo.getPluginName(), (IContainer)pluginProject, this.getPlugin(info), (IProgressMonitor)monitor);
                this.saveImageIntoProject(info, pluginProject, (IProgressMonitor)monitor);
                IFile compositeFile = PluginHelper.createFile(info.getCompositeFileName(), (IContainer)this.getSourceFolder(info.getPackageName(), pluginProject), this.getCompositeClass(info), (IProgressMonitor)monitor);
                if (this.page1.isUsingCustomJar() && this.page2.createDynamicControls()) {
                    JDTUtils.organizeImport((ICompilationUnit)JavaCore.createCompilationUnitFrom((IFile)compositeFile));
                }
            }
        }
        catch (Exception e) {
            UIUtils.showError((Throwable)e);
        }
        monitor.done();
        return true;
    }

    public boolean canFinish() {
        if (this.page1.isUsingCustomJar()) {
            return this.page1.isPageComplete() && this.page2.isPageComplete();
        }
        return this.page1.isPageComplete();
    }
}

