/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.adapter;

import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.data.DataAdapterService;
import net.sf.jasperreports.data.DataAdapterServiceUtil;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ParameterContributor;
import net.sf.jasperreports.engine.ParameterContributorContext;
import net.sf.jasperreports.engine.ParameterContributorFactory;
import net.sf.jasperreports.repo.DataAdapterResource;
import net.sf.jasperreports.repo.RepositoryUtil;
import org.eclipse.core.resources.IFile;

public final class DataAdapterParameterContributorFactory
implements ParameterContributorFactory {
    public static final String PARAMETER_DATA_ADAPTER = "PARAMETER_DATA_ADAPTER";
    private static final DataAdapterParameterContributorFactory INSTANCE = new DataAdapterParameterContributorFactory();

    private DataAdapterParameterContributorFactory() {
    }

    public static DataAdapterParameterContributorFactory getInstance() {
        return INSTANCE;
    }

    public List<ParameterContributor> getContributors(ParameterContributorContext context) throws JRException {
        String dataAdapterUri;
        ArrayList<ParameterContributor> contributors = new ArrayList<ParameterContributor>();
        DataAdapter dataAdapter = null;
        Object param = context.getParameterValues().get(PARAMETER_DATA_ADAPTER);
        if (param instanceof DataAdapter) {
            dataAdapter = (DataAdapter)param;
        }
        if (dataAdapter == null && (dataAdapterUri = JRPropertiesUtil.getInstance((JasperReportsContext)context.getJasperReportsContext()).getProperty((JRPropertiesHolder)context.getDataset(), "net.sf.jasperreports.data.adapter")) != null) {
            Object obj;
            if ((dataAdapterUri.startsWith("../") || dataAdapterUri.startsWith("./") || !dataAdapterUri.startsWith("/")) && (obj = ((JasperReportsConfiguration)context.getJasperReportsContext()).get("ifile")) instanceof IFile) {
                IFile f = (IFile)obj;
                String pref = "";
                if (dataAdapterUri.startsWith("../") && f.getParent() != null && f.getParent().getParent() != null) {
                    pref = f.getParent().getParent().getProjectRelativePath().toString();
                    dataAdapterUri = String.valueOf(pref) + dataAdapterUri.substring(2);
                } else if (dataAdapterUri.startsWith("./") && f.getParent() != null) {
                    pref = f.getParent().getProjectRelativePath().toString();
                    dataAdapterUri = String.valueOf(pref) + dataAdapterUri.substring(1);
                } else if (!dataAdapterUri.startsWith("/")) {
                    pref = f.getParent().getProjectRelativePath().toString();
                    dataAdapterUri = String.valueOf(pref) + "/" + dataAdapterUri;
                }
            }
            DataAdapterResource dataAdapterResource = (DataAdapterResource)RepositoryUtil.getInstance((JasperReportsContext)context.getJasperReportsContext()).getResourceFromLocation(dataAdapterUri, DataAdapterResource.class);
            dataAdapter = dataAdapterResource.getDataAdapter();
        }
        if (dataAdapter != null) {
            DataAdapterService dataAdapterService = DataAdapterServiceUtil.getInstance((ParameterContributorContext)context).getService(dataAdapter);
            return Collections.singletonList(dataAdapterService);
        }
        return contributors;
    }
}

