/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.customadapters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.customadapters.IAdapterPropertyHandler;
import com.jaspersoft.studio.widgets.framework.IPropertyEditor;
import java.beans.PropertyChangeSupport;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.data.DataAdapter;
import net.sf.jasperreports.engine.JRExpression;

public class DataAdapterPropertyEditor
implements IPropertyEditor {
    private DataAdapter handledAdapter = null;
    private PropertyChangeSupport changeSupport = null;
    private Map<String, List<Method>> methodsSettersMap = new HashMap<String, List<Method>>();
    private Map<String, List<Method>> methodsGettersMap = new HashMap<String, List<Method>>();
    private IAdapterPropertyHandler adapterPropertyHandler = null;
    private static final Map<Class<?>, Class<?>> primitiveMap = new HashMap();

    static {
        primitiveMap.put(Boolean.TYPE, Boolean.class);
        primitiveMap.put(Byte.TYPE, Byte.class);
        primitiveMap.put(Short.TYPE, Short.class);
        primitiveMap.put(Character.TYPE, Character.class);
        primitiveMap.put(Integer.TYPE, Integer.class);
        primitiveMap.put(Long.TYPE, Long.class);
        primitiveMap.put(Float.TYPE, Float.class);
        primitiveMap.put(Double.TYPE, Double.class);
    }

    @Override
    public void removeProperty(String propertyName) {
        if (this.isSupportedByHandler(propertyName)) {
            this.adapterPropertyHandler.removeProperty(propertyName, this.handledAdapter);
            this.changeSupport.firePropertyChange("dirty", false, true);
        } else {
            List<Method> method = this.methodsSettersMap.get("set" + propertyName.toLowerCase());
            if (method != null && !method.isEmpty()) {
                try {
                    method.get(0).invoke((Object)this.handledAdapter, new Object[1]);
                    this.changeSupport.firePropertyChange("dirty", false, true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
        }
    }

    protected String invokeGetMethod(List<Method> methods) {
        block6: {
            try {
                for (Method method : methods) {
                    if (!String.class.isAssignableFrom(method.getReturnType())) continue;
                    return (String)method.invoke((Object)this.handledAdapter, new Object[0]);
                }
                Method firstGetter = methods.get(0);
                if (Collection.class.isAssignableFrom(firstGetter.getReturnType()) || Array.class.isAssignableFrom(firstGetter.getReturnType())) {
                    ObjectMapper mapper = new ObjectMapper();
                    try {
                        return mapper.writeValueAsString(firstGetter.invoke((Object)this.handledAdapter, new Object[0]));
                    }
                    catch (JsonProcessingException e) {
                        e.printStackTrace();
                        JaspersoftStudioPlugin.getInstance().logError(e);
                        break block6;
                    }
                }
                Object value = methods.get(0).invoke((Object)this.handledAdapter, new Object[0]);
                return value != null ? value.toString() : null;
            }
            catch (Exception e) {
                e.printStackTrace();
                JaspersoftStudioPlugin.getInstance().logError(e);
            }
        }
        return null;
    }

    @Override
    public String getPropertyValue(String propertyName) {
        if (this.isSupportedByHandler(propertyName)) {
            this.adapterPropertyHandler.getPropertyValue(propertyName, this.handledAdapter);
        } else {
            List<Method> methods = this.methodsGettersMap.get("get" + propertyName.toLowerCase());
            if (methods != null && !methods.isEmpty()) {
                return this.invokeGetMethod(methods);
            }
            methods = this.methodsGettersMap.get("is" + propertyName.toLowerCase());
            if (methods != null && !methods.isEmpty()) {
                return this.invokeGetMethod(methods);
            }
        }
        return null;
    }

    private List<?> buildList(String values, Class<?> listInnerClass) {
        ObjectMapper mapper = new ObjectMapper();
        String[] stringValues = new String[]{};
        if (values != null && !values.isEmpty()) {
            try {
                stringValues = (String[])mapper.readValue(values, String[].class);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        if (listInnerClass.isAssignableFrom(List.class)) {
            Class persistentClass = (Class)((ParameterizedType)listInnerClass.getGenericSuperclass()).getActualTypeArguments()[0];
            ArrayList result = new ArrayList();
            String[] stringArray = stringValues;
            int n = stringValues.length;
            int n2 = 0;
            while (n2 < n) {
                String stringValue = stringArray[n2];
                result.add(this.buildList(stringValue, persistentClass));
                ++n2;
            }
            return result;
        }
        ArrayList<Object> result = new ArrayList<Object>();
        String[] stringArray = stringValues;
        int n = stringValues.length;
        int n3 = 0;
        while (n3 < n) {
            String stringValue = stringArray[n3];
            Object content = this.buildSimpleType(stringValue, listInnerClass);
            if (content != null) {
                result.add(content);
            }
            ++n3;
        }
        return result;
    }

    private Object buildSimpleType(String value, Class<?> type) {
        Constructor<?> constructor;
        Constructor<?>[] constructorArray = type.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (constructor.getParameterTypes().length == 1 && constructor.getParameterTypes()[0].isAssignableFrom(String.class)) {
                try {
                    return constructor.newInstance(value);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
            ++n2;
        }
        constructorArray = type.getConstructors();
        n = constructorArray.length;
        n2 = 0;
        while (n2 < n) {
            constructor = constructorArray[n2];
            if (constructor.getParameterTypes().length == 1) {
                try {
                    Object constructorParameter = this.buildSimpleType(value, constructor.getParameters()[0].getClass());
                    if (constructorParameter != null) {
                        return constructor.newInstance(constructorParameter);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    JaspersoftStudioPlugin.getInstance().logError(e);
                }
            }
            ++n2;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void createUpdateProperty(String propertyName, String value, JRExpression valueExpression) {
        if (this.isSupportedByHandler(propertyName)) {
            this.adapterPropertyHandler.setPropertyValue(propertyName, value, this.handledAdapter);
            this.changeSupport.firePropertyChange("dirty", false, true);
            return;
        }
        List<Method> methods = this.methodsSettersMap.get("set" + propertyName.toLowerCase());
        if (methods == null) return;
        for (Method method : methods) {
            if (!String.class.isAssignableFrom(method.getParameterTypes()[0])) continue;
            method.invoke((Object)this.handledAdapter, value);
            this.changeSupport.firePropertyChange("dirty", false, true);
            return;
        }
        for (Method method : methods) {
            Class<Collection> parameterClass = method.getParameterTypes()[0];
            if (primitiveMap.containsKey(parameterClass)) {
                parameterClass = primitiveMap.get(parameterClass);
            }
            try {
                if (parameterClass.isAssignableFrom(List.class) || parameterClass.isAssignableFrom(Collection.class)) {
                    Class persistentClass = null;
                    if (parameterClass.getGenericSuperclass() != null) {
                        persistentClass = (Class)((ParameterizedType)parameterClass.getGenericSuperclass()).getActualTypeArguments()[0];
                    } else {
                        ParameterizedType type = (ParameterizedType)method.getGenericParameterTypes()[0];
                        persistentClass = (Class)type.getActualTypeArguments()[0];
                    }
                    List<?> parameter = this.buildList(value, persistentClass);
                    if (parameter == null) continue;
                    method.invoke((Object)this.handledAdapter, parameter);
                    this.changeSupport.firePropertyChange("dirty", false, true);
                    return;
                }
                Object parameter = this.buildSimpleType(value, parameterClass);
                if (parameter == null) continue;
                method.invoke((Object)this.handledAdapter, parameter);
                this.changeSupport.firePropertyChange("dirty", false, true);
                return;
            }
            catch (Exception ex) {
                try {
                    ex.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                    throw new Exception("No setter found for property " + propertyName);
                }
            }
        }
    }

    public void setDataAdapter(DataAdapter handledAdapter, PropertyChangeSupport changeSupport) {
        this.changeSupport = changeSupport;
        this.handledAdapter = handledAdapter;
        this.methodsSettersMap.clear();
        this.methodsGettersMap.clear();
        Method[] methodArray = handledAdapter.getClass().getMethods();
        int n = methodArray.length;
        int n2 = 0;
        while (n2 < n) {
            List<Method> methods;
            Method method = methodArray[n2];
            String methodName = method.getName().toLowerCase();
            if ((methodName.startsWith("get") || methodName.startsWith("is")) && !method.getReturnType().equals(Void.TYPE)) {
                methods = this.methodsGettersMap.get(methodName);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    this.methodsGettersMap.put(methodName, methods);
                }
                methods.add(method);
            } else if (methodName.startsWith("set") && method.getParameterTypes().length == 1) {
                methods = this.methodsSettersMap.get(methodName);
                if (methods == null) {
                    methods = new ArrayList<Method>();
                    this.methodsSettersMap.put(methodName, methods);
                }
                methods.add(method);
            }
            ++n2;
        }
    }

    public void setAdapterPropertyHandler(IAdapterPropertyHandler adapterPropertyHandler) {
        this.adapterPropertyHandler = adapterPropertyHandler;
    }

    protected boolean isSupportedByHandler(String propertyName) {
        return this.adapterPropertyHandler != null && this.adapterPropertyHandler.isSupportedProperty(propertyName, this.handledAdapter);
    }

    @Override
    public JRExpression getPropertyValueExpression(String propertyName) {
        return null;
    }
}

