/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer;

import com.jaspersoft.studio.data.IQueryDesigner;
import com.jaspersoft.studio.data.designer.AQueryDesignerContainer;
import com.jaspersoft.studio.swt.widgets.CSashForm;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.AWizardPage;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;

public abstract class AQueryDesigner
implements IQueryDesigner,
IRunnableContext {
    protected AQueryDesignerContainer container;
    protected JasperDesign jDesign;
    protected JRDesignDataset jDataset;
    protected JasperReportsConfiguration jConfig;

    public JRDesignDataset getjDataset() {
        return this.jDataset;
    }

    public void showError(Throwable t) {
        this.container.getQueryStatus().showError(t);
    }

    public void showWarning(String msg) {
        this.container.getQueryStatus().showWarning(msg);
    }

    public void showInfo(String msg) {
        this.container.getQueryStatus().showInfo(msg);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        this.container.run(fork, cancelable, runnable);
    }

    public AQueryDesignerContainer getContainer() {
        return this.container;
    }

    public JasperDesign getjDesign() {
        return this.jDesign;
    }

    @Override
    public void setQuery(JasperDesign jDesign, JRDataset jDataset, JasperReportsConfiguration jConfig) {
        this.jDesign = jDesign;
        this.jDataset = (JRDesignDataset)jDataset;
        ((JRDesignDataset)jDataset).getEventSupport().addPropertyChangeListener(evt -> {
            if (evt.getPropertyName().equals("parameters") && evt.getNewValue() != null) {
                this.listenParameter((JRDesignParameter)evt.getNewValue());
            }
        });
        JRParameter[] jRParameterArray = jDataset.getParameters();
        int n = jRParameterArray.length;
        int n2 = 0;
        while (n2 < n) {
            JRParameter p = jRParameterArray[n2];
            this.listenParameter((JRDesignParameter)p);
            ++n2;
        }
        this.jConfig = jConfig;
    }

    protected void listenParameter(JRDesignParameter p) {
        p.getEventSupport().addPropertyChangeListener(e -> {
            if (e.getPropertyName().equals("name")) {
                this.parameterNameChanged((String)e.getOldValue(), (String)e.getNewValue());
            }
        });
    }

    protected void parameterNameChanged(String oldValue, String newValue) {
    }

    @Override
    public String getQuery() {
        if (this.jDataset != null) {
            return this.jDataset.getQuery().getText();
        }
        return "";
    }

    @Override
    public void setParentContainer(AQueryDesignerContainer parent) {
        this.container = parent;
    }

    @Override
    public void setFields(List<JRDesignField> fields) {
        ArrayList<JRDesignField> toadd = new ArrayList<JRDesignField>();
        HashSet<String> names = new HashSet<String>();
        for (JRDesignField f : fields) {
            if (names.contains(f.getName())) continue;
            names.add(f.getName());
            toadd.add(f);
        }
        this.container.setFields(toadd);
    }

    @Override
    public void setParameters(List<JRParameter> params) {
        for (JRParameter dp : params) {
            if (this.jDataset.getParametersMap().containsKey(dp.getName())) continue;
            try {
                this.jDataset.addParameter(dp);
            }
            catch (JRException e) {
                e.printStackTrace();
            }
        }
        this.container.setParameters(params);
    }

    public static void showError(IRunnableContext container, Throwable e) {
        if (container instanceof AQueryDesigner) {
            ((AQueryDesigner)container).showError(e);
        } else if (container instanceof AWizardPage) {
            ((AWizardPage)container).setErrorMessage(e.getMessage());
        } else {
            UIUtils.showError((Throwable)e);
        }
    }

    public static void showInfo(IRunnableContext container, String msg) {
        if (container instanceof AQueryDesigner) {
            ((AQueryDesigner)container).showInfo(msg);
        } else if (container instanceof AWizardPage) {
            ((AWizardPage)container).setMessage(msg);
        } else if (!Misc.isNullOrEmpty((String)msg)) {
            UIUtils.showInformation((String)msg);
        }
    }

    @Override
    public void setJasperConfiguration(JasperReportsConfiguration jConfig) {
        this.jConfig = jConfig;
    }

    public JasperReportsConfiguration getjConfig() {
        return this.jConfig;
    }

    protected void initSashForm(CSashForm sashform) {
        final String SASH_W1 = String.valueOf(this.getClass().getCanonicalName()) + ".sash.w1";
        final String SASH_W2 = String.valueOf(this.getClass().getCanonicalName()) + ".sash.w2";
        int w1 = 450;
        int w2 = 500;
        if (this.jDataset != null) {
            try {
                String sw1 = this.jDataset.getPropertiesMap().getProperty(SASH_W1);
                if (sw1 != null) {
                    w1 = Integer.parseInt(sw1);
                }
            }
            catch (NumberFormatException numberFormatException) {}
            try {
                String sw2 = this.jDataset.getPropertiesMap().getProperty(SASH_W2);
                if (sw2 != null) {
                    w2 = Integer.parseInt(sw2);
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        sashform.setWeights(new int[]{w1, w2});
        sashform.addCustomSashFormListener(new CSashForm.ICustomSashFormListener(){

            @Override
            public void dividerMoved(int firstControlWeight, int secondControlWeight) {
                AQueryDesigner.this.jDataset.getPropertiesMap().setProperty(SASH_W1, Integer.toString(firstControlWeight));
                AQueryDesigner.this.jDataset.getPropertiesMap().setProperty(SASH_W2, Integer.toString(secondControlWeight));
            }
        });
    }
}

