/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.data.designer.UndoRedoImpl;
import com.jaspersoft.studio.data.fields.IFieldsProvider;
import com.jaspersoft.studio.messages.Messages;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import com.jaspersoft.studio.wizards.ContextHelpIDs;
import java.util.regex.Matcher;
import net.sf.jasperreports.eclipse.util.Misc;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public class QueryDesigner
extends AQueryDesigner {
    private boolean refresh = false;
    protected StyledText control;
    private Composite tbCompo;
    private Button btn;
    protected UndoRedoImpl undoHandlrer;
    private static final String LineDelimiter = System.getProperty("line.separator");

    protected void doSourceTextChanged() {
        if (!this.refresh) {
            this.refresh = true;
            if (this.jDataset != null && this.jDataset.getQuery() != null) {
                ((JRDesignQuery)this.jDataset.getQuery()).setText(Misc.nvl((String)this.getQueryFromWidget()));
            }
            this.refresh = false;
        }
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public Control getToolbarControl() {
        return this.tbCompo;
    }

    @Override
    protected void parameterNameChanged(String oldValue, String newValue) {
        String q = this.control.getText();
        q = q.replaceAll("\\$P\\{" + oldValue + "\\}", Matcher.quoteReplacement("$P{" + newValue + "}"));
        this.updateQueryText(q);
    }

    protected String getNewLineDelimiter() {
        return LineDelimiter;
    }

    @Override
    public Control createControl(Composite parent) {
        this.control = new StyledText(parent, 2882){

            public String getLineDelimiter() {
                return QueryDesigner.this.getNewLineDelimiter();
            }
        };
        this.control.addModifyListener((ModifyListener)new QueryListener());
        this.setupSourceEditorFont();
        this.undoHandlrer = new UndoRedoImpl(this.control);
        return this.control;
    }

    protected void setupSourceEditorFont() {
        this.control.setFont(FontUtils.getEditorsFont(this.jConfig));
    }

    @Override
    public void setQuery(JasperDesign jDesign, JRDataset jDataset, JasperReportsConfiguration jConfig) {
        super.setQuery(jDesign, jDataset, jConfig);
        this.refresh = true;
        this.updateQueryText(jDataset.getQuery().getText());
        if (this.undoHandlrer != null) {
            this.undoHandlrer.clearStack();
        }
        this.refresh = false;
    }

    protected void updateQueryText(String txt) {
        this.control.setText(txt);
    }

    protected String getQueryFromWidget() {
        return this.control.getText();
    }

    @Override
    public void dispose() {
    }

    @Override
    public Control createToolbar(Composite parent) {
        if (parent != null) {
            this.tbCompo = new Composite(parent, 0);
            this.tbCompo.setBackgroundMode(2);
            GridLayout layout = new GridLayout(1, false);
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this.tbCompo.setLayout((Layout)layout);
            this.tbCompo.setLayoutData((Object)new GridData(4, 4, true, false));
            this.btn = new Button(this.tbCompo, 8);
            this.btn.setLayoutData((Object)new GridData(131072, 4, true, false));
            this.btn.setText(Messages.QueryDesigner_readFieldsButton);
            this.btn.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    QueryDesigner.this.container.doGetFields();
                }
            });
            this.setFieldProviderEnabled(true);
        }
        return this.tbCompo;
    }

    @Override
    public void setDataAdapter(DataAdapterDescriptor da) {
        boolean enable = da instanceof IFieldsProvider && ((IFieldsProvider)((Object)da)).supportsGetFieldsOperation(this.container.getjConfig(), (JRDataset)this.getjDataset());
        this.setFieldProviderEnabled(enable);
    }

    protected void setFieldProviderEnabled(boolean enable) {
        if (this.btn != null) {
            this.btn.setEnabled(enable);
        }
    }

    @Override
    public String getContextHelpId() {
        return ContextHelpIDs.WIZARD_QUERY_DIALOG;
    }

    public final class QueryListener
    implements ModifyListener {
        public void modifyText(ModifyEvent e) {
            QueryDesigner.this.doSourceTextChanged();
        }
    }
}

