/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer;

import com.jaspersoft.studio.JaspersoftStudioPlugin;
import com.jaspersoft.studio.data.designer.AQueryStatus;
import net.sf.jasperreports.eclipse.ui.util.UIUtils;
import net.sf.jasperreports.eclipse.util.Misc;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;

public class QueryStatus
extends AQueryStatus {
    private ToolItem msgItem;
    private ToolBar toolBar;

    public QueryStatus(Composite composite) {
        this.createStatusBar(composite);
    }

    @Override
    public void showError(final Throwable t) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryStatus.this.msgItem.isDisposed()) {
                    return;
                }
                QueryStatus.this.msgItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/error_tsk.gif"));
                QueryStatus.this.setMessage(t, t.getMessage(), true);
            }
        });
    }

    @Override
    public void showError(final String message, final Throwable t) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryStatus.this.msgItem.isDisposed()) {
                    return;
                }
                QueryStatus.this.msgItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/error_tsk.gif"));
                QueryStatus.this.setMessage(t, message, true);
            }
        });
    }

    @Override
    public void showWarning(final String msg) {
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryStatus.this.msgItem.isDisposed()) {
                    return;
                }
                QueryStatus.this.msgItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/warn_tsk.gif"));
                QueryStatus.this.setMessage(null, msg, true);
            }
        });
    }

    @Override
    public void showInfo(final String msg) {
        UIUtils.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                if (QueryStatus.this.msgItem.isDisposed()) {
                    return;
                }
                QueryStatus.this.msgItem.setImage(JaspersoftStudioPlugin.getInstance().getImage("icons/resources/eclipse/obj16/info_tsk.gif"));
                QueryStatus.this.setMessage(null, msg, false);
            }
        });
    }

    @Override
    protected void setMessage(Throwable t, String message, boolean enabled) {
        super.setMessage(t, message, enabled);
        this.cutMessage();
        this.msgItem.setToolTipText(Misc.nvl((String)this.msg));
        this.msgItem.setEnabled(enabled);
        this.toolBar.setVisible(this.msg != null && !this.msg.trim().isEmpty());
        this.toolBar.getParent().layout();
    }

    protected void createStatusBar(Composite comp) {
        this.toolBar = new ToolBar(comp, 8519744);
        this.toolBar.setLayoutData((Object)new GridData(768));
        this.msgItem = new ToolItem(this.toolBar, 8);
        this.showInfo("Build a query for your report.");
        this.msgItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (QueryStatus.this.t != null) {
                    UIUtils.showError((String)QueryStatus.this.msg, (Throwable)QueryStatus.this.t);
                } else {
                    UIUtils.showWarning((String)QueryStatus.this.msg);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.toolBar.addControlListener(new ControlListener(){

            public void controlResized(ControlEvent e) {
                QueryStatus.this.cutMessage();
            }

            public void controlMoved(ControlEvent e) {
            }
        });
    }

    public void cutMessage() {
        String str = Misc.nvl((String)this.msg);
        int endIndex = str.length();
        if (endIndex > 0) {
            int w = this.toolBar.getBounds().width - 70;
            GC gc = new GC((Drawable)this.toolBar);
            try {
                endIndex = Math.max(w / gc.getFontMetrics().getAverageCharWidth(), 0);
            }
            finally {
                gc.dispose();
            }
            if (str.contains("\n")) {
                endIndex = Math.min(str.indexOf(10), endIndex);
            }
            if (endIndex - 3 < str.length() && endIndex > 0) {
                this.msgItem.setText(String.valueOf(str.substring(0, endIndex - 3)) + "...");
                return;
            }
        }
        this.msgItem.setText(str);
    }
}

