/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.studio.data.designer.tree;

import com.jaspersoft.studio.data.DataAdapterDescriptor;
import com.jaspersoft.studio.data.designer.AQueryDesigner;
import com.jaspersoft.studio.model.ANode;
import com.jaspersoft.studio.preferences.fonts.utils.FontUtils;
import com.jaspersoft.studio.utils.ModelUtils;
import com.jaspersoft.studio.utils.jasper.JasperReportsConfiguration;
import java.util.List;
import java.util.regex.Matcher;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class TreeBasedQueryDesigner
extends AQueryDesigner {
    protected Composite control;
    protected StyledText queryTextArea;
    protected TreeViewer treeViewer;
    protected boolean isRefreshing;

    @Override
    protected void parameterNameChanged(String oldValue, String newValue) {
        String q = this.queryTextArea.getText();
        q = q.replaceAll("\\$P\\{" + oldValue + "\\}", Matcher.quoteReplacement("$P{" + newValue + "}"));
        this.queryTextArea.setText(q);
    }

    @Override
    public Control getControl() {
        return this.control;
    }

    @Override
    public Control createControl(Composite parent) {
        this.control = new Composite(parent, 0);
        GridLayout controlGl = new GridLayout(1, true);
        controlGl.marginWidth = 0;
        controlGl.marginHeight = 0;
        this.control.setLayout((Layout)controlGl);
        this.createTitleBar(this.control);
        SashForm sashForm = new SashForm(this.control, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this.createTreeViewer((Composite)sashForm);
        this.createQueryTextArea((Composite)sashForm);
        sashForm.setWeights(new int[]{30, 70});
        return this.control;
    }

    protected void createQueryTextArea(Composite parent) {
        this.queryTextArea = new StyledText(parent, 2048);
        this.queryTextArea.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                TreeBasedQueryDesigner.this.queryTextAreaModified();
            }
        });
        this.queryTextArea.setFont(FontUtils.getEditorsFont(this.jConfig));
    }

    protected void queryTextAreaModified() {
        ((JRDesignQuery)this.jDataset.getQuery()).setText(this.queryTextArea.getText());
        this.decorateTreeUsingQueryText();
    }

    protected void decorateTreeUsingQueryText() {
    }

    protected void createTitleBar(Composite parent) {
    }

    protected void createTreeViewer(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 2048);
        this.treeViewer.getTree().setLayoutData((Object)new GridData(4, 4, true, true));
        this.treeViewer.setContentProvider(this.getTreeContentProvider());
        this.treeViewer.setLabelProvider(this.getTreeLabelProvider());
    }

    protected abstract IBaseLabelProvider getTreeLabelProvider();

    protected abstract IContentProvider getTreeContentProvider();

    protected abstract void refreshTreeViewerContent(DataAdapterDescriptor var1);

    public void createField(ANode node) {
        List<JRDesignField> currentFields = this.container.getCurrentFields();
        JRDesignField field = (JRDesignField)node.getAdapter(JRDesignField.class);
        field.setName(ModelUtils.getNameForField(currentFields, field.getName()));
        currentFields.add(field);
        this.container.setFields(currentFields);
    }

    @Override
    public void setQuery(JasperDesign jDesign, JRDataset jDataset, JasperReportsConfiguration jConfig) {
        super.setQuery(jDesign, jDataset, jConfig);
        this.queryTextArea.setText(jDataset.getQuery().getText());
    }

    @Override
    public Control getToolbarControl() {
        return null;
    }

    @Override
    public Control createToolbar(Composite parent) {
        return null;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setDataAdapter(DataAdapterDescriptor da) {
        this.refreshTreeViewerContent(da);
    }
}

